/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.mail.kernel.service.MailService;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheMapSynchronizeUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.exception.CompanyMaxUsersException;
import com.liferay.portal.kernel.exception.ContactBirthdayException;
import com.liferay.portal.kernel.exception.ContactNameException;
import com.liferay.portal.kernel.exception.DuplicateGoogleUserIdException;
import com.liferay.portal.kernel.exception.DuplicateOpenIdException;
import com.liferay.portal.kernel.exception.GroupFriendlyURLException;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchOrganizationException;
import com.liferay.portal.kernel.exception.NoSuchTicketException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PasswordExpiredException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RequiredUserException;
import com.liferay.portal.kernel.exception.SendPasswordException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.exception.UserEmailAddressException;
import com.liferay.portal.kernel.exception.UserIdException;
import com.liferay.portal.kernel.exception.UserLockoutException;
import com.liferay.portal.kernel.exception.UserPasswordException;
import com.liferay.portal.kernel.exception.UserReminderQueryException;
import com.liferay.portal.kernel.exception.UserScreenNameException;
import com.liferay.portal.kernel.exception.UserSmsException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Account;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.search.BaseModelSearchResult;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.EmailAddressGenerator;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.security.auth.FullNameDefinition;
import com.liferay.portal.kernel.security.auth.FullNameDefinitionFactory;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.FullNameValidator;
import com.liferay.portal.kernel.security.auth.PasswordModificationThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.auth.ScreenNameGenerator;
import com.liferay.portal.kernel.security.auth.ScreenNameValidator;
import com.liferay.portal.kernel.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SubscriptionSender;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.model.impl.LayoutImpl;
import com.liferay.portal.model.impl.UserCacheModel;
import com.liferay.portal.model.impl.UserImpl;
import com.liferay.portal.security.auth.AuthPipeline;
import com.liferay.portal.security.auth.EmailAddressGeneratorFactory;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.security.auth.FullNameValidatorFactory;
import com.liferay.portal.security.auth.ScreenNameGeneratorFactory;
import com.liferay.portal.security.auth.ScreenNameValidatorFactory;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.security.pwd.PwdAuthenticator;
import com.liferay.portal.security.pwd.PwdToolkitUtil;
import com.liferay.portal.security.pwd.RegExpToolkit;
import com.liferay.portal.service.base.UserLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.social.kernel.model.SocialRelation;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import com.liferay.util.Encryptor;
import com.liferay.util.EncryptorException;
import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletPreferences;

public class UserLocalServiceImpl
extends UserLocalServiceBaseImpl {
    @BeanReference(type=MailService.class)
    protected MailService mailService;
    private static final Log _log = LogFactoryUtil.getLog(UserLocalServiceImpl.class);
    private final Map<Long, User> _defaultUsers = new ConcurrentHashMap<Long, User>();

    public User addDefaultAdminUser(long companyId, String screenName, String emailAddress, Locale locale, String firstName, String middleName, String lastName) throws PortalException {
        User screenNameUser;
        String password1;
        long creatorUserId = 0L;
        boolean autoPassword = false;
        String password2 = password1 = PropsValues.DEFAULT_ADMIN_PASSWORD;
        boolean autoScreenName = false;
        screenName = this.getLogin(screenName);
        int i = 1;
        while ((screenNameUser = this.userPersistence.fetchByC_SN(companyId, screenName)) != null) {
            screenName = screenName + i;
            ++i;
        }
        long facebookId = 0L;
        String openId = "";
        long prefixId = 0L;
        long suffixId = 0L;
        boolean male = true;
        int birthdayMonth = 0;
        int birthdayDay = 1;
        int birthdayYear = 1970;
        String jobTitle = "";
        Group guestGroup = this.groupLocalService.getGroup(companyId, "Guest");
        long[] groupIds = new long[]{guestGroup.getGroupId()};
        long[] organizationIds = null;
        Role adminRole = this.roleLocalService.getRole(companyId, "Administrator");
        Role powerUserRole = this.roleLocalService.getRole(companyId, "Power User");
        long[] roleIds = new long[]{adminRole.getRoleId(), powerUserRole.getRoleId()};
        long[] userGroupIds = null;
        boolean sendEmail = false;
        ServiceContext serviceContext = new ServiceContext();
        User defaultAdminUser = this.addUser(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
        this.updateEmailAddressVerified(defaultAdminUser.getUserId(), true);
        this.updateLastLogin(defaultAdminUser.getUserId(), defaultAdminUser.getLoginIP());
        this.updatePasswordReset(defaultAdminUser.getUserId(), false);
        return defaultAdminUser;
    }

    public void addDefaultGroups(long userId) throws PortalException {
        String[] defaultOrganizationGroupNames;
        String[] defaultGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> groupIdsSet = new HashSet<Long>();
        for (String defaultGroupName : defaultGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.group.names", "\n", PropsValues.ADMIN_DEFAULT_GROUP_NAMES)) {
            Group group;
            Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
            Account account = company.getAccount();
            if (StringUtil.equalsIgnoreCase((String)defaultGroupName, (String)account.getName())) {
                defaultGroupName = "Guest";
            }
            if ((group = this.groupPersistence.fetchByC_GK(user.getCompanyId(), defaultGroupName)) == null) continue;
            groupIdsSet.add(group.getGroupId());
        }
        for (String defaultOrganizationGroupName : defaultOrganizationGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.organization.group.names", "\n", PropsValues.ADMIN_DEFAULT_ORGANIZATION_GROUP_NAMES)) {
            defaultOrganizationGroupName = defaultOrganizationGroupName + " LFR_ORGANIZATION";
            Group group = this.groupPersistence.fetchByC_GK(user.getCompanyId(), defaultOrganizationGroupName);
            if (group == null) continue;
            groupIdsSet.add(group.getGroupId());
        }
        long[] groupIds = ArrayUtil.toArray((Long[])groupIdsSet.toArray(new Long[groupIdsSet.size()]));
        this.userPersistence.addGroups(userId, groupIds);
        for (long groupId : groupIds) {
            this.addDefaultRolesAndTeams(groupId, new long[]{userId});
        }
    }

    public void addDefaultRoles(long userId) throws PortalException {
        String[] defaultRoleNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> roleIdSet = new HashSet<Long>();
        for (String defaultRoleName : defaultRoleNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.role.names", "\n", PropsValues.ADMIN_DEFAULT_ROLE_NAMES)) {
            Role role = this.rolePersistence.fetchByC_N(user.getCompanyId(), defaultRoleName);
            if (role == null || role.getType() != 1) continue;
            roleIdSet.add(role.getRoleId());
        }
        long[] roleIds = ArrayUtil.toArray((Long[])roleIdSet.toArray(new Long[roleIdSet.size()]));
        roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
        this.userPersistence.addRoles(userId, roleIds);
    }

    public void addDefaultUserGroups(long userId) throws PortalException {
        String[] defaultUserGroupNames;
        User user = this.userPersistence.findByPrimaryKey(userId);
        HashSet<Long> userGroupIdSet = new HashSet<Long>();
        for (String defaultUserGroupName : defaultUserGroupNames = PrefsPropsUtil.getStringArray(user.getCompanyId(), "admin.default.user.group.names", "\n", PropsValues.ADMIN_DEFAULT_USER_GROUP_NAMES)) {
            UserGroup userGroup = this.userGroupPersistence.fetchByC_N(user.getCompanyId(), defaultUserGroupName);
            if (userGroup == null) continue;
            userGroupIdSet.add(userGroup.getUserGroupId());
        }
        long[] userGroupIds = ArrayUtil.toArray((Long[])userGroupIdSet.toArray(new Long[userGroupIdSet.size()]));
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            for (long userGroupId : userGroupIds) {
                this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userId);
            }
        }
        this.userPersistence.addUserGroups(userId, userGroupIds);
    }

    @Override
    public void addGroupUsers(long groupId, long[] userIds) throws PortalException {
        this.groupPersistence.addUsers(groupId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
        this.addDefaultRolesAndTeams(groupId, userIds);
    }

    @Override
    public void addOrganizationUsers(long organizationId, long[] userIds) throws PortalException {
        this.organizationPersistence.addUsers(organizationId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    public void addPasswordPolicyUsers(long passwordPolicyId, long[] userIds) {
        this.passwordPolicyRelLocalService.addPasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    @Override
    public void addRoleUsers(long roleId, long[] userIds) throws PortalException {
        this.rolePersistence.addUsers(roleId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    @Override
    public void addTeamUsers(long teamId, long[] userIds) throws PortalException {
        this.teamPersistence.addUsers(teamId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User addUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        boolean workflowEnabled = WorkflowThreadLocal.isEnabled();
        try {
            WorkflowThreadLocal.setEnabled((boolean)false);
            if (serviceContext == null) {
                serviceContext = new ServiceContext();
            }
            if (serviceContext.getWorkflowAction() != 1) {
                serviceContext.setWorkflowAction(1);
            }
            User user = this.addUserWithWorkflow(creatorUserId, companyId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, facebookId, openId, locale, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, jobTitle, groupIds, organizationIds, roleIds, userGroupIds, sendEmail, serviceContext);
            return user;
        }
        finally {
            WorkflowThreadLocal.setEnabled((boolean)workflowEnabled);
        }
    }

    @Override
    public void addUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        }
        this.userGroupPersistence.addUsers(userGroupId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    public User addUserWithWorkflow(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, long[] userGroupIds, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        String passwordUnencrypted;
        ServiceContext workflowServiceContext;
        long workflowUserId;
        String uuid;
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        screenName = this.getLogin(screenName);
        openId = StringUtil.trim((String)openId);
        if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
            autoScreenName = true;
        }
        long userId = this.counterLocalService.increment();
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        emailAddress = emailAddress == null || emailAddressGenerator.isGenerated(emailAddress) ? "" : StringUtil.toLowerCase((String)emailAddress.trim());
        if (!PrefsPropsUtil.getBoolean(companyId, "users.email.address.required") && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(companyId, userId);
        }
        this.validate(companyId, userId, autoPassword, password1, password2, autoScreenName, screenName, emailAddress, openId, firstName, middleName, lastName, organizationIds, locale);
        if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        if (autoScreenName) {
            ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
            try {
                screenName = screenNameGenerator.generate(companyId, userId, emailAddress);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        User defaultUser = this.getDefaultUser(companyId);
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
        String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullName, (boolean)false);
        User user = this.userPersistence.create(userId);
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        user.setCompanyId(companyId);
        user.setDefaultUser(false);
        user.setContactId(this.counterLocalService.increment());
        if (Validator.isNotNull((String)password1)) {
            user.setPassword(PasswordEncryptorUtil.encrypt((String)password1));
            user.setPasswordUnencrypted(password1);
        }
        user.setPasswordEncrypted(true);
        PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
            user.setPasswordReset(true);
        } else {
            user.setPasswordReset(false);
        }
        user.setDigest("");
        user.setScreenName(screenName);
        user.setEmailAddress(emailAddress);
        user.setFacebookId(facebookId);
        Long ldapServerId = null;
        if (serviceContext != null) {
            ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        }
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        } else {
            user.setLdapServerId(-1L);
        }
        user.setOpenId(openId);
        user.setLanguageId(LocaleUtil.toLanguageId((Locale)locale));
        user.setTimeZoneId(defaultUser.getTimeZoneId());
        user.setGreeting(greeting);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setStatus(2);
        user.setExpandoBridgeAttributes(serviceContext);
        this.userPersistence.update((BaseModel)user, serviceContext);
        String creatorUserName = "";
        if (creatorUserId <= 0L) {
            creatorUserId = user.getUserId();
        } else {
            User creatorUser = this.userPersistence.findByPrimaryKey(creatorUserId);
            creatorUserName = creatorUser.getFullName();
        }
        Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
        Contact contact = this.contactPersistence.create(user.getContactId());
        contact.setCompanyId(user.getCompanyId());
        contact.setUserId(creatorUserId);
        contact.setUserName(creatorUserName);
        contact.setClassName(User.class.getName());
        contact.setClassPK(user.getUserId());
        contact.setAccountId(company.getAccountId());
        contact.setParentContactId(0L);
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, serviceContext);
        this.groupLocalService.addGroup(user.getUserId(), 0L, User.class.getName(), user.getUserId(), 0L, (Map)null, null, 0, true, 0, "/" + screenName, false, true, null);
        if (!ArrayUtil.isEmpty((long[])groupIds)) {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (long groupId : groupIds) {
                Group group = this.groupLocalService.fetchGroup(groupId);
                if (group != null) {
                    groups.add(group);
                    continue;
                }
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Group " + groupId + " does not exist"));
            }
            this.groupLocalService.addUserGroups(userId, groups);
        }
        this.addDefaultGroups(userId);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.addDefaultRoles(userId);
        if (userGroupIds != null) {
            if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                for (long userGroupId : userGroupIds) {
                    this.userGroupLocalService.copyUserGroupLayouts(userGroupId, new long[]{userId});
                }
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.addDefaultUserGroups(userId);
        this.resourceLocalService.addResources(companyId, 0L, creatorUserId, User.class.getName(), user.getUserId(), false, false, false);
        if (serviceContext != null) {
            this.updateAsset(creatorUserId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            this.reindex(user);
        }
        if ((workflowUserId = creatorUserId) == userId) {
            workflowUserId = defaultUser.getUserId();
        }
        if ((workflowServiceContext = serviceContext) == null) {
            workflowServiceContext = new ServiceContext();
        }
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("passwordUnencrypted", (Serializable)((Object)password1));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)workflowUserId, (String)User.class.getName(), (long)userId, (Object)user, (ServiceContext)workflowServiceContext);
        if (serviceContext != null && Validator.isNotNull((String)(passwordUnencrypted = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"))))) {
            user.setPasswordUnencrypted(passwordUnencrypted);
        }
        return user;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        PortalCache portalCache = EntityCacheUtil.getPortalCache(UserImpl.class);
        PortalCacheMapSynchronizeUtil.synchronize((PortalCache)portalCache, this._defaultUsers, (PortalCacheMapSynchronizeUtil.Synchronizer)new PortalCacheMapSynchronizeUtil.Synchronizer<Serializable, Serializable>(){

            public void onSynchronize(Map<? extends Serializable, ? extends Serializable> map, Serializable key, Serializable value, int timeToLive) {
                if (!(value instanceof UserCacheModel)) {
                    return;
                }
                UserCacheModel userCacheModel = (UserCacheModel)value;
                if (userCacheModel.defaultUser) {
                    UserLocalServiceImpl.this._defaultUsers.remove(userCacheModel.companyId);
                }
            }
        });
    }

    public int authenticateByEmailAddress(long companyId, String emailAddress, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, emailAddress, password, "emailAddress", headerMap, parameterMap, resultsMap);
    }

    public int authenticateByScreenName(long companyId, String screenName, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, screenName, password, "screenName", headerMap, parameterMap, resultsMap);
    }

    public int authenticateByUserId(long companyId, long userId, String password, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        return this.authenticate(companyId, String.valueOf(userId), password, "userId", headerMap, parameterMap, resultsMap);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public long authenticateForBasic(long companyId, String authType, String login, String password) throws PortalException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.fetchUserByEmailAddress(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.fetchUserByScreenName(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null) {
            return 0L;
        }
        if (!this.isUserAllowedToAuthenticate(user)) {
            return 0L;
        }
        if (!PropsValues.BASIC_AUTH_PASSWORD_REQUIRED) {
            return user.getUserId();
        }
        String userPassword = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            userPassword = PasswordEncryptorUtil.encrypt((String)userPassword);
        }
        String encPassword = PasswordEncryptorUtil.encrypt((String)password, (String)userPassword);
        if (userPassword.equals(password) || userPassword.equals(encPassword)) {
            this.resetFailedLoginAttempts(user);
            return user.getUserId();
        }
        this.handleAuthenticationFailure(login, authType, user, Collections.emptyMap(), Collections.emptyMap());
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public long authenticateForDigest(long companyId, String username, String realm, String nonce, String method, String uri, String response) throws PortalException {
        String[] digestArray;
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return 0L;
        }
        User user = this.fetchUserByEmailAddress(companyId, username);
        if (user == null) {
            user = this.fetchUserByScreenName(companyId, username);
        }
        if (user == null) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)username));
        }
        if (user == null) {
            return 0L;
        }
        if (!this.isUserAllowedToAuthenticate(user)) {
            return 0L;
        }
        String digest = user.getDigest();
        if (Validator.isNull((String)digest)) {
            _log.error((Object)("User must first login through the portal " + user.getUserId()));
            return 0L;
        }
        for (String ha1 : digestArray = StringUtil.split((String)user.getDigest())) {
            String ha2 = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{method, uri});
            String curResponse = DigesterUtil.digestHex((String)"MD5", (String[])new String[]{ha1, nonce, ha2});
            if (!response.equals(curResponse)) continue;
            this.resetFailedLoginAttempts(user);
            return user.getUserId();
        }
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        this.handleAuthenticationFailure(username, company.getAuthType(), user, new HashMap<String, String[]>(), new HashMap<String, String[]>());
        return 0L;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean authenticateForJAAS(long userId, String encPassword) {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return false;
        }
        try {
            User user = this.userPersistence.findByPrimaryKey(userId);
            if (user.isDefaultUser()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"JAAS authentication is disabled for the default user");
                }
                return false;
            }
            if (!user.isActive()) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("JAAS authentication is disabled for inactive user " + userId));
                }
                return false;
            }
            String userPassword = user.getPassword();
            if (user.isPasswordEncrypted()) {
                if (userPassword.equals(encPassword)) {
                    return true;
                }
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && userPassword.equals(encPassword = PasswordEncryptorUtil.encrypt((String)encPassword, (String)userPassword))) {
                    return true;
                }
            } else {
                if (!PropsValues.PORTAL_JAAS_STRICT_PASSWORD && userPassword.equals(encPassword)) {
                    return true;
                }
                if ((userPassword = PasswordEncryptorUtil.encrypt((String)userPassword, (String)encPassword)).equals(encPassword)) {
                    return true;
                }
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
        return false;
    }

    public void checkLockout(User user) throws PortalException {
        long requiredElapsedTime;
        long elapsedTime;
        if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (!passwordPolicy.isLockout()) {
            return;
        }
        Date now = new Date();
        int failedLoginAttempts = user.getFailedLoginAttempts();
        if (failedLoginAttempts > 0) {
            long failedLoginTime = user.getLastFailedLoginDate().getTime();
            elapsedTime = now.getTime() - failedLoginTime;
            requiredElapsedTime = passwordPolicy.getResetFailureCount() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setFailedLoginAttempts(0);
                this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            long lockoutTime = user.getLockoutDate().getTime();
            elapsedTime = now.getTime() - lockoutTime;
            requiredElapsedTime = passwordPolicy.getLockoutDuration() * 1000L;
            if (requiredElapsedTime != 0L && elapsedTime > requiredElapsedTime) {
                user.setLockout(false);
                user.setLockoutDate(null);
                this.userPersistence.update((BaseModel)user);
            }
        }
        if (user.isLockout()) {
            throw new UserLockoutException.PasswordPolicyLockout(user, passwordPolicy);
        }
    }

    public void checkLoginFailure(User user) {
        int failedLoginAttempts = user.getFailedLoginAttempts();
        user.setLastFailedLoginDate(new Date());
        user.setFailedLoginAttempts(++failedLoginAttempts);
        this.userPersistence.update((BaseModel)user);
    }

    public void checkLoginFailureByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureById(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.checkLoginFailure(user);
    }

    public void checkLoginFailureByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        this.checkLoginFailure(user);
    }

    public void checkPasswordExpired(User user) throws PortalException {
        if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
            return;
        }
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (this.isPasswordExpired(user)) {
            int graceLoginCount = user.getGraceLoginCount();
            if (graceLoginCount < passwordPolicy.getGraceLimit()) {
                user.setGraceLoginCount(++graceLoginCount);
                this.userPersistence.update((BaseModel)user);
            } else {
                user.setDigest("");
                this.userPersistence.update((BaseModel)user);
                throw new PasswordExpiredException();
            }
        }
        if (passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired() && user.getLastLoginDate() == null) {
            user.setPasswordReset(true);
            this.userPersistence.update((BaseModel)user);
        }
    }

    @Override
    public void clearOrganizationUsers(long organizationId) {
        this.organizationPersistence.clearUsers(organizationId);
        PermissionCacheUtil.clearCache();
    }

    @Override
    public void clearUserGroupUsers(long userGroupId) {
        this.userGroupPersistence.clearUsers(userGroupId);
        PermissionCacheUtil.clearCache();
    }

    public void completeUserRegistration(User user, ServiceContext serviceContext) throws PortalException {
        Company company;
        boolean sendEmail;
        boolean autoPassword = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"autoPassword");
        String password = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"));
        if (autoPassword) {
            if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(4);
                    sb.append("When LDAP password policy is enabled, it is ");
                    sb.append("possible that portal generated passwords will ");
                    sb.append("not match the LDAP policy. Using ");
                    sb.append("RegExpToolkit to generate new password.");
                    _log.warn((Object)sb.toString());
                }
                RegExpToolkit regExpToolkit = new RegExpToolkit();
                password = regExpToolkit.generate(null);
            } else {
                PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicy(user.getCompanyId(), user.getOrganizationIds());
                password = PwdToolkitUtil.generate(passwordPolicy);
            }
            serviceContext.setAttribute("passwordUnencrypted", (Serializable)((Object)password));
            user.setPassword(PasswordEncryptorUtil.encrypt((String)password));
            user.setPasswordUnencrypted(password);
            user.setPasswordEncrypted(true);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user);
            user.setPasswordModified(false);
        }
        if (user.hasCompanyMx()) {
            this.mailService.addUser(user.getCompanyId(), user.getUserId(), password, user.getFirstName(), user.getMiddleName(), user.getLastName(), user.getEmailAddress());
        }
        if (sendEmail = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"sendEmail")) {
            this.notifyUser(user, password, serviceContext);
        }
        if ((company = this.companyPersistence.findByPrimaryKey(user.getCompanyId())).isStrangersVerify()) {
            this.sendEmailAddressVerification(user, user.getEmailAddress(), serviceContext);
        }
    }

    public KeyValuePair decryptUserId(long companyId, String name, String password) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        try {
            name = Encryptor.decrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        try {
            password = Encryptor.decrypt((Key)company.getKeyObj(), (String)password);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
        String userPassword = user.getPassword();
        String encPassword = PasswordEncryptorUtil.encrypt((String)password, (String)userPassword);
        if (userPassword.equals(encPassword)) {
            if (this.isPasswordExpired(user)) {
                user.setPasswordReset(true);
                this.userPersistence.update((BaseModel)user);
            }
            return new KeyValuePair(name, password);
        }
        throw new PrincipalException.MustBeAuthenticated(userId);
    }

    public void deletePortrait(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        PortalUtil.updateImageId((BaseModel)user, (boolean)false, null, (String)"portraitId", (long)0L, (int)0, (int)0);
    }

    @Override
    public void deleteRoleUser(long roleId, long userId) throws PortalException {
        this.rolePersistence.removeUser(roleId, userId);
        this.reindex(userId);
        PermissionCacheUtil.clearCache(userId);
    }

    @Override
    public User deleteUser(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.deleteUser(user);
    }

    @Override
    public User deleteUser(User user) throws PortalException {
        block6: {
            if (!PropsValues.USERS_DELETE) {
                throw new RequiredUserException();
            }
            this.browserTrackerLocalService.deleteUserBrowserTracker(user.getUserId());
            Group group = null;
            if (!user.isDefaultUser()) {
                group = user.getGroup();
            }
            if (group != null) {
                this.groupLocalService.deleteGroup(group);
            }
            try {
                this.imageLocalService.deleteImage(user.getPortraitId());
            }
            catch (NoSuchImageException nsie) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)("Unable to delete image " + user.getPortraitId()), (Throwable)nsie);
            }
        }
        this.passwordPolicyRelLocalService.deletePasswordPolicyRel(User.class.getName(), user.getUserId());
        this.passwordTrackerLocalService.deletePasswordTrackers(user.getUserId());
        this.subscriptionLocalService.deleteSubscriptions(user.getUserId());
        this.userIdMapperLocalService.deleteUserIdMappers(user.getUserId());
        this.announcementsDeliveryLocalService.deleteDeliveries(user.getUserId());
        this.assetEntryLocalService.deleteEntry(User.class.getName(), user.getUserId());
        this.blogsStatsUserLocalService.deleteStatsUserByUserId(user.getUserId());
        this.dlFileRankLocalService.deleteFileRanksByUserId(user.getUserId());
        this.expandoRowLocalService.deleteRows(user.getUserId());
        this.mbBanLocalService.deleteBansByBanUserId(user.getUserId());
        this.mbStatsUserLocalService.deleteStatsUsersByUserId(user.getUserId());
        this.mbThreadFlagLocalService.deleteThreadFlagsByUserId(user.getUserId());
        this.membershipRequestLocalService.deleteMembershipRequestsByUserId(user.getUserId());
        this.ratingsStatsLocalService.deleteStats(User.class.getName(), user.getUserId());
        this.socialActivityLocalService.deleteUserActivities(user.getUserId());
        this.socialRequestLocalService.deleteReceiverUserRequests(user.getUserId());
        this.socialRequestLocalService.deleteUserRequests(user.getUserId());
        this.mailService.deleteUser(user.getCompanyId(), user.getUserId());
        Contact contact = this.contactLocalService.fetchContact(user.getContactId());
        if (contact != null) {
            this.contactLocalService.deleteContact(contact);
        }
        this.userGroupRoleLocalService.deleteUserGroupRolesByUserId(user.getUserId());
        this.recentLayoutBranchLocalService.deleteUserRecentLayoutBranches(user.getUserId());
        this.recentLayoutRevisionLocalService.deleteUserRecentLayoutRevisions(user.getUserId());
        this.recentLayoutSetBranchLocalService.deleteUserRecentLayoutSetBranches(user.getUserId());
        this.resourceLocalService.deleteResource(user.getCompanyId(), User.class.getName(), 4, user.getUserId());
        this.userPersistence.remove((BaseModel)user);
        PermissionCacheUtil.clearCache(user.getUserId());
        this.workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(user.getCompanyId(), 0L, User.class.getName(), user.getUserId());
        return user;
    }

    @Override
    public void deleteUserGroupUser(long userGroupId, long userId) throws PortalException {
        this.userGroupPersistence.removeUser(userGroupId, userId);
        this.reindex(userId);
        PermissionCacheUtil.clearCache(userId);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String encryptUserId(String name) throws PortalException {
        long userId = GetterUtil.getLong((String)name);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        try {
            return Encryptor.encrypt((Key)company.getKeyObj(), (String)name);
        }
        catch (EncryptorException ee) {
            throw new SystemException((Throwable)ee);
        }
    }

    public User fetchUserByContactId(long contactId) {
        return this.userPersistence.fetchByContactId(contactId);
    }

    public User fetchUserByEmailAddress(long companyId, String emailAddress) {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.fetchByC_EA(companyId, emailAddress);
    }

    public User fetchUserByFacebookId(long companyId, long facebookId) {
        return this.userPersistence.fetchByC_FID(companyId, facebookId);
    }

    public User fetchUserByGoogleUserId(long companyId, String googleUserId) {
        return this.userPersistence.fetchByC_GUID(companyId, googleUserId);
    }

    public User fetchUserById(long userId) {
        return this.userPersistence.fetchByPrimaryKey(userId);
    }

    public User fetchUserByOpenId(long companyId, String openId) {
        return this.userPersistence.fetchByC_O(companyId, openId);
    }

    public User fetchUserByPortraitId(long portraitId) {
        return this.userPersistence.fetchByPortraitId(portraitId);
    }

    public User fetchUserByScreenName(long companyId, String screenName) {
        screenName = this.getLogin(screenName);
        return this.userPersistence.fetchByC_SN(companyId, screenName);
    }

    public List<User> getCompanyUsers(long companyId, int start, int end) {
        return this.userPersistence.findByCompanyId(companyId, start, end);
    }

    public int getCompanyUsersCount(long companyId) {
        return this.userPersistence.countByCompanyId(companyId);
    }

    @Skip
    public User getDefaultUser(long companyId) throws PortalException {
        User userModel = this._defaultUsers.get(companyId);
        if (userModel == null) {
            userModel = this.userLocalService.loadGetDefaultUser(companyId);
            this._defaultUsers.put(companyId, userModel);
        }
        return userModel;
    }

    @Skip
    public long getDefaultUserId(long companyId) throws PortalException {
        User user = this.getDefaultUser(companyId);
        return user.getUserId();
    }

    public long[] getGroupUserIds(long groupId) {
        return this.groupPersistence.getUserPrimaryKeys(groupId);
    }

    public int getGroupUsersCount(long groupId, int status) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", groupId);
        return this.searchCount(group.getCompanyId(), null, status, params);
    }

    public List<User> getInheritedRoleUsers(long roleId, int start, int end, OrderByComparator<User> obc) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("inherit", Boolean.TRUE);
        params.put("usersRoles", roleId);
        return this.search(role.getCompanyId(), null, 0, params, start, end, obc);
    }

    public List<User> getNoAnnouncementsDeliveries(String type) {
        return this.userFinder.findByNoAnnouncementsDeliveries(type);
    }

    public List<User> getNoContacts() {
        return this.userFinder.findByNoContacts();
    }

    public List<User> getNoGroups() {
        return this.userFinder.findByNoGroups();
    }

    public long[] getOrganizationUserIds(long organizationId) {
        return this.organizationPersistence.getUserPrimaryKeys(organizationId);
    }

    public int getOrganizationUsersCount(long organizationId, int status) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersOrgs", organizationId);
        return this.searchCount(organization.getCompanyId(), null, status, params);
    }

    public long[] getRoleUserIds(long roleId) {
        return this.rolePersistence.getUserPrimaryKeys(roleId);
    }

    public int getRoleUsersCount(long roleId, int status) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersRoles", roleId);
        return this.searchCount(role.getCompanyId(), null, status, params);
    }

    @Deprecated
    public List<User> getSocialUsers(long userId, int socialRelationType, int start, int end, OrderByComparator<User> obc) throws PortalException {
        return this.getSocialUsers(userId, socialRelationType, "=", start, end, obc);
    }

    @Deprecated
    public List<User> getSocialUsers(long userId, int start, int end, OrderByComparator<User> obc) throws PortalException {
        return this.getSocialUsers(userId, 9, "!=", start, end, obc);
    }

    public List<User> getSocialUsers(long userId, int socialRelationType, String socialRelationTypeComparator, int start, int end, OrderByComparator<User> obc) throws PortalException {
        if (!socialRelationTypeComparator.equals("=") && !socialRelationTypeComparator.equals("!=")) {
            throw new IllegalArgumentException("Invalid social relation type comparator " + socialRelationTypeComparator);
        }
        if (start == -1 && end == -1) {
            List socialRelations = this.socialRelationPersistence.findByU1_T(userId, socialRelationType);
            if (socialRelationTypeComparator.equals("!=")) {
                socialRelations = ListUtil.remove((List)this.socialRelationPersistence.findByUserId1(userId), (List)socialRelations);
            }
            List<Object> users = new ArrayList<User>();
            for (SocialRelation socialRelation : socialRelations) {
                User user = this.userPersistence.findByPrimaryKey(socialRelation.getUserId2());
                if (user.isDefaultUser() || user.getStatus() != 0 || users.contains(user)) continue;
                users.add(user);
            }
            if (obc != null) {
                users = ListUtil.sort(users, obc);
            }
            return users;
        }
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.userFinder.findBySocialUsers(user.getCompanyId(), userId, socialRelationType, socialRelationTypeComparator, 0, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int socialRelationType, int start, int end, OrderByComparator<User> obc) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, socialRelationType, userId2, socialRelationType});
        return this.search(user1.getCompanyId(), null, 0, params, start, end, obc);
    }

    public List<User> getSocialUsers(long userId1, long userId2, int start, int end, OrderByComparator<User> obc) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.search(user1.getCompanyId(), null, 0, params, start, end, obc);
    }

    @Deprecated
    public int getSocialUsersCount(long userId) throws PortalException {
        return this.getSocialUsersCount(userId, 9, "!=");
    }

    @Deprecated
    public int getSocialUsersCount(long userId, int socialRelationType) throws PortalException {
        return this.getSocialUsersCount(userId, socialRelationType, "=");
    }

    public int getSocialUsersCount(long userId, int socialRelationType, String socialRelationTypeComparator) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!socialRelationTypeComparator.equals("=") && !socialRelationTypeComparator.equals("!=")) {
            throw new IllegalArgumentException("Invalid social relation type comparator " + socialRelationTypeComparator);
        }
        return this.userFinder.countBySocialUsers(user.getCompanyId(), user.getUserId(), socialRelationType, socialRelationTypeComparator, 0);
    }

    public int getSocialUsersCount(long userId1, long userId2) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelation", new Long[]{userId1, userId2});
        return this.searchCount(user1.getCompanyId(), null, 0, params);
    }

    public int getSocialUsersCount(long userId1, long userId2, int socialRelationType) throws PortalException {
        User user1 = this.userPersistence.findByPrimaryKey(userId1);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialMutualRelationType", new Long[]{userId1, socialRelationType, userId2, socialRelationType});
        return this.searchCount(user1.getCompanyId(), null, 0, params);
    }

    public User getUserByContactId(long contactId) throws PortalException {
        return this.userPersistence.findByContactId(contactId);
    }

    public User getUserByEmailAddress(long companyId, String emailAddress) throws PortalException {
        emailAddress = this.getLogin(emailAddress);
        return this.userPersistence.findByC_EA(companyId, emailAddress);
    }

    public User getUserByFacebookId(long companyId, long facebookId) throws PortalException {
        return this.userPersistence.findByC_FID(companyId, facebookId);
    }

    public User getUserByGoogleUserId(long companyId, String googleUserId) throws PortalException {
        return this.userPersistence.findByC_GUID(companyId, googleUserId);
    }

    public User getUserById(long userId) throws PortalException {
        return this.userPersistence.findByPrimaryKey(userId);
    }

    public User getUserById(long companyId, long userId) throws PortalException {
        return this.userPersistence.findByC_U(companyId, userId);
    }

    public User getUserByOpenId(long companyId, String openId) throws PortalException {
        return this.userPersistence.findByC_O(companyId, openId);
    }

    public User getUserByPortraitId(long portraitId) throws PortalException {
        return this.userPersistence.findByPortraitId(portraitId);
    }

    public User getUserByScreenName(long companyId, String screenName) throws PortalException {
        screenName = this.getLogin(screenName);
        return this.userPersistence.findByC_SN(companyId, screenName);
    }

    @Override
    public User getUserByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        List users = this.userPersistence.findByUuid_C(uuid, companyId);
        if (users.isEmpty()) {
            StringBundler sb = new StringBundler(5);
            sb.append("{uuid=");
            sb.append(uuid);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append("}");
            throw new NoSuchUserException(sb.toString());
        }
        return (User)users.get(0);
    }

    public int getUserGroupUsersCount(long userGroupId, int status) throws PortalException {
        UserGroup userGroup = this.userGroupPersistence.findByPrimaryKey(userGroupId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersUserGroups", userGroupId);
        return this.searchCount(userGroup.getCompanyId(), null, status, params);
    }

    public long getUserIdByEmailAddress(long companyId, String emailAddress) throws PortalException {
        emailAddress = StringUtil.toLowerCase((String)emailAddress.trim());
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return user.getUserId();
    }

    public long getUserIdByScreenName(long companyId, String screenName) throws PortalException {
        screenName = this.getLogin(screenName);
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return user.getUserId();
    }

    public boolean hasPasswordPolicyUser(long passwordPolicyId, long userId) {
        return this.passwordPolicyRelLocalService.hasPasswordPolicyRel(passwordPolicyId, User.class.getName(), userId);
    }

    public boolean hasRoleUser(long companyId, String name, long userId, boolean inherited) throws PortalException {
        return this.roleLocalService.hasUserRole(userId, companyId, name, inherited);
    }

    public boolean isPasswordExpired(User user) throws PortalException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.getExpireable()) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user);
            }
            long passwordStartTime = user.getPasswordModifiedDate().getTime();
            long elapsedTime = now.getTime() - passwordStartTime;
            return elapsedTime > passwordPolicy.getMaxAge() * 1000L;
        }
        return false;
    }

    public boolean isPasswordExpiringSoon(User user) throws PortalException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy != null && passwordPolicy.isExpireable() && passwordPolicy.getWarningTime() > 0L) {
            Date now = new Date();
            if (user.getPasswordModifiedDate() == null) {
                user.setPasswordModifiedDate(now);
                this.userLocalService.updateUser(user);
            }
            long timeModified = user.getPasswordModifiedDate().getTime();
            long passwordExpiresOn = passwordPolicy.getMaxAge() * 1000L + timeModified;
            long timeStartWarning = passwordExpiresOn - passwordPolicy.getWarningTime() * 1000L;
            return now.getTime() > timeStartWarning;
        }
        return false;
    }

    public User loadGetDefaultUser(long companyId) throws PortalException {
        return this.userPersistence.findByC_DU(companyId, true);
    }

    public List<User> search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<User> obc) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.findByKeywords(companyId, keywords, status, params, start, end, obc);
        }
        try {
            return UsersAdminUtil.getUsers((Hits)this.search(companyId, keywords, status, params, start, end, this.getSorts(obc)));
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort sort) {
        return this.search(companyId, keywords, status, params, start, end, new Sort[]{sort});
    }

    public Hits search(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String fullName = null;
        String screenName = null;
        String emailAddress = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            fullName = keywords;
            screenName = keywords;
            emailAddress = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, street, city, zip, region, country, status, params, andOperator, start, end, sorts);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public List<User> search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, OrderByComparator<User> obc) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.findByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, obc);
        }
        try {
            return UsersAdminUtil.getUsers((Hits)this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, this.getSorts(obc)));
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) {
        return this.search(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, new Sort[]{sort});
    }

    public Hits search(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) {
        try {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, null, screenName, emailAddress, null, null, null, null, null, status, params, andSearch, start, end, sorts);
            return indexer.search(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public int searchCount(long companyId, String keywords, int status, LinkedHashMap<String, Object> params) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.countByKeywords(companyId, keywords, status, params);
        }
        try {
            String firstName = null;
            String middleName = null;
            String lastName = null;
            String fullName = null;
            String screenName = null;
            String emailAddress = null;
            String street = null;
            String city = null;
            String zip = null;
            String region = null;
            String country = null;
            boolean andOperator = false;
            if (Validator.isNotNull((String)keywords)) {
                firstName = keywords;
                middleName = keywords;
                lastName = keywords;
                fullName = keywords;
                screenName = keywords;
                emailAddress = keywords;
                street = keywords;
                city = keywords;
                zip = keywords;
                region = keywords;
                country = keywords;
            } else {
                andOperator = true;
            }
            if (params != null) {
                params.put("keywords", keywords);
            }
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, street, city, zip, region, country, status, params, andOperator, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public int searchCount(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch) {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        if (!indexer.isIndexerEnabled() || !PropsValues.USERS_SEARCH_WITH_INDEX || this.isUseCustomSQL(params)) {
            return this.userFinder.countByC_FN_MN_LN_SN_EA_S(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch);
        }
        try {
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
            SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, null, null, null, null, null, status, params, true, -1, -1, null);
            return (int)indexer.searchCount(searchContext);
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
    }

    public Map<Long, Integer> searchCounts(long companyId, int status, long[] groupIds) {
        return this.userFinder.countByGroups(companyId, status, groupIds);
    }

    public List<User> searchSocial(long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[][]{{userId}, ArrayUtil.toLongArray((int[])socialRelationTypes)});
        params.put("wildcardMode", WildcardMode.TRAILING);
        return this.userFinder.findByKeywords(user.getCompanyId(), keywords, 0, params, start, end, null);
    }

    public List<User> searchSocial(long companyId, long[] groupIds, String keywords, int start, int end) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", ArrayUtil.toLongArray((long[])groupIds));
        params.put("wildcardMode", WildcardMode.TRAILING);
        return this.userFinder.findByKeywords(companyId, keywords, 0, params, start, end, null);
    }

    public List<User> searchSocial(long[] groupIds, long userId, int[] socialRelationTypes, String keywords, int start, int end) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("socialRelationType", new Long[][]{{userId}, ArrayUtil.toLongArray((int[])socialRelationTypes)});
        params.put("socialRelationTypeUnionUserGroups", true);
        params.put("usersGroups", ArrayUtil.toLongArray((long[])groupIds));
        params.put("wildcardMode", WildcardMode.TRAILING);
        return this.userFinder.findByKeywords(user.getCompanyId(), keywords, 0, params, start, end, null);
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort sort) throws PortalException {
        return this.searchUsers(companyId, keywords, status, params, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String keywords, int status, LinkedHashMap<String, Object> params, int start, int end, Sort[] sorts) throws PortalException {
        String firstName = null;
        String middleName = null;
        String lastName = null;
        String fullName = null;
        String screenName = null;
        String emailAddress = null;
        String street = null;
        String city = null;
        String zip = null;
        String region = null;
        String country = null;
        boolean andOperator = false;
        if (Validator.isNotNull((String)keywords)) {
            firstName = keywords;
            middleName = keywords;
            lastName = keywords;
            fullName = keywords;
            screenName = keywords;
            emailAddress = keywords;
            street = keywords;
            city = keywords;
            zip = keywords;
            region = keywords;
            country = keywords;
        } else {
            andOperator = true;
        }
        if (params != null) {
            params.put("keywords", keywords);
        }
        SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, fullName, screenName, emailAddress, street, city, zip, region, country, status, params, andOperator, start, end, sorts);
        return this.searchUsers(searchContext);
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort sort) throws PortalException {
        return this.searchUsers(companyId, firstName, middleName, lastName, screenName, emailAddress, status, params, andSearch, start, end, new Sort[]{sort});
    }

    public BaseModelSearchResult<User> searchUsers(long companyId, String firstName, String middleName, String lastName, String screenName, String emailAddress, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) throws PortalException {
        SearchContext searchContext = this.buildSearchContext(companyId, firstName, middleName, lastName, null, screenName, emailAddress, null, null, null, null, null, status, params, andSearch, start, end, sorts);
        return this.searchUsers(searchContext);
    }

    public void sendEmailAddressVerification(User user, String emailAddress, ServiceContext serviceContext) throws PortalException {
        Layout layout;
        if (user.isEmailAddressVerified() && StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        Ticket ticket = this.ticketLocalService.addDistinctTicket(user.getCompanyId(), User.class.getName(), user.getUserId(), 1, emailAddress, null, serviceContext);
        String verifyEmailAddressURL = serviceContext.getPortalURL() + serviceContext.getPathMain() + "/portal/verify_email_address?ticketKey=" + ticket.getKey();
        long plid = serviceContext.getPlid();
        if (plid > 0L && (layout = this.layoutLocalService.fetchLayout(plid)) != null) {
            Group group = layout.getGroup();
            if (!layout.isPrivateLayout() && !group.isUser()) {
                verifyEmailAddressURL = verifyEmailAddressURL + "&p_l_id=" + serviceContext.getPlid();
            }
        }
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = emailAddress;
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(user.getCompanyId(), true);
        Map localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailVerificationSubject", (String)"admin.email.verification.subject");
        Map localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailVerificationBody", (String)"admin.email.verification.body");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(user.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$EMAIL_VERIFICATION_CODE$]", ticket.getKey(), "[$EMAIL_VERIFICATION_URL$]", verifyEmailAddressURL, "[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr(), "[$REMOTE_HOST$]", serviceContext.getRemoteHost(), "[$USER_ID$]", user.getUserId(), "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    public boolean sendPassword(long companyId, String emailAddress, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (!company.isSendPassword() && !company.isSendPasswordResetLink()) {
            throw new SendPasswordException.MustBeEnabled(company);
        }
        if (Validator.isNull((String)(emailAddress = StringUtil.toLowerCase((String)emailAddress.trim())))) {
            throw new UserEmailAddressException.MustNotBeNull();
        }
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        String newPassword = "";
        String passwordResetURL = "";
        if (company.isSendPasswordResetLink()) {
            Date expirationDate = null;
            if (passwordPolicy != null && passwordPolicy.getResetTicketMaxAge() > 0L) {
                expirationDate = new Date(System.currentTimeMillis() + passwordPolicy.getResetTicketMaxAge() * 1000L);
            }
            Ticket ticket = this.ticketLocalService.addDistinctTicket(companyId, User.class.getName(), user.getUserId(), 3, null, expirationDate, serviceContext);
            passwordResetURL = serviceContext.getPortalURL() + serviceContext.getPathMain() + "/portal/update_password?p_l_id=" + serviceContext.getPlid() + "&ticketKey=" + ticket.getKey();
        } else if (!Objects.equals(PasswordEncryptorUtil.getDefaultPasswordAlgorithmType(), "NONE")) {
            if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                if (_log.isWarnEnabled()) {
                    StringBundler sb = new StringBundler(5);
                    sb.append("When LDAP password policy is enabled, it ");
                    sb.append("is possible that portal generated ");
                    sb.append("passwords will not match the LDAP policy.");
                    sb.append("Using RegExpToolkit to generate new ");
                    sb.append("password.");
                    _log.warn((Object)sb.toString());
                }
                RegExpToolkit regExpToolkit = new RegExpToolkit();
                newPassword = regExpToolkit.generate(null);
            } else {
                newPassword = PwdToolkitUtil.generate(passwordPolicy);
            }
            boolean passwordReset = false;
            if (passwordPolicy.getChangeable() && passwordPolicy.getChangeRequired()) {
                passwordReset = true;
            }
            user.setPassword(PasswordEncryptorUtil.encrypt((String)newPassword));
            user.setPasswordUnencrypted(newPassword);
            user.setPasswordEncrypted(true);
            user.setPasswordReset(passwordReset);
            user.setPasswordModified(true);
            user.setPasswordModifiedDate(new Date());
            this.userPersistence.update((BaseModel)user);
            user.setPasswordModified(false);
        } else {
            newPassword = user.getPassword();
        }
        this.sendPasswordNotification(user, companyId, newPassword, passwordResetURL, fromName, fromAddress, subject, body, serviceContext);
        return company.isSendPassword();
    }

    public boolean sendPasswordByEmailAddress(long companyId, String emailAddress) throws PortalException {
        User user = this.userPersistence.findByC_EA(companyId, emailAddress);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    public boolean sendPasswordByScreenName(long companyId, String screenName) throws PortalException {
        User user = this.userPersistence.findByC_SN(companyId, screenName);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    public boolean sendPasswordByUserId(long userId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.sendPassword(user.getCompanyId(), user.getEmailAddress(), null, null, null, null, ServiceContextThreadLocal.getServiceContext());
    }

    @Override
    public void setRoleUsers(long roleId, long[] userIds) throws PortalException {
        long[] oldUserIds = this.rolePersistence.getUserPrimaryKeys(roleId);
        Set updatedUserIdsSet = SetUtil.symmetricDifference((long[])userIds, (long[])oldUserIds);
        long[] updateUserIds = ArrayUtil.toLongArray((Collection)updatedUserIdsSet);
        this.rolePersistence.setUsers(roleId, userIds);
        this.reindex(updateUserIds);
        PermissionCacheUtil.clearCache(updateUserIds);
    }

    @Override
    public void setUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
            this.userGroupLocalService.copyUserGroupLayouts(userGroupId, userIds);
        }
        long[] oldUserIds = this.userGroupPersistence.getUserPrimaryKeys(userGroupId);
        Set updatedUserIdsSet = SetUtil.symmetricDifference((long[])userIds, (long[])oldUserIds);
        long[] updateUserIds = ArrayUtil.toLongArray((Collection)updatedUserIdsSet);
        this.userGroupPersistence.setUsers(userGroupId, userIds);
        this.reindex(updateUserIds);
        PermissionCacheUtil.clearCache(updateUserIds);
    }

    public void unsetGroupTeamsUsers(long groupId, long[] userIds) throws PortalException {
        List teams = this.teamPersistence.findByGroupId(groupId);
        for (Team team : teams) {
            this.unsetTeamUsers(team.getTeamId(), userIds);
        }
        PermissionCacheUtil.clearCache(userIds);
    }

    public void unsetGroupUsers(final long groupId, final long[] userIds, ServiceContext serviceContext) throws PortalException {
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, groupId, 2);
        this.unsetGroupTeamsUsers(groupId, userIds);
        this.groupPersistence.removeUsers(groupId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("groupId", (Object)groupId);
                message.put("userIds", (Object)userIds);
                MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public void unsetOrganizationUsers(long organizationId, final long[] userIds) throws PortalException {
        Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
        final Group group = organization.getGroup();
        this.userGroupRoleLocalService.deleteUserGroupRoles(userIds, group.getGroupId());
        this.organizationPersistence.removeUsers(organizationId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.put("groupId", (Object)group.getGroupId());
                message.put("userIds", (Object)userIds);
                MessageBusUtil.sendMessage((String)"liferay/subscription_clean_up", (Message)message);
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
    }

    public void unsetPasswordPolicyUsers(long passwordPolicyId, long[] userIds) {
        this.passwordPolicyRelLocalService.deletePasswordPolicyRels(passwordPolicyId, User.class.getName(), userIds);
    }

    public void unsetRoleUsers(long roleId, List<User> users) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        String roleName = role.getName();
        if (roleName.equals("Administrator") && this.getRoleUsersCount(role.getRoleId()) <= 1 || roleName.equals("User")) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, users);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex(users);
        long[] userIds = new long[users.size()];
        for (int i = 0; i < users.size(); ++i) {
            User user = users.get(i);
            userIds[i] = user.getUserId();
        }
        PermissionCacheUtil.clearCache(userIds);
    }

    public void unsetRoleUsers(long roleId, long[] userIds) throws PortalException {
        Role role = this.rolePersistence.findByPrimaryKey(roleId);
        String roleName = role.getName();
        if (roleName.equals("User") || roleName.equals("Administrator") && this.getRoleUsersCount(role.getRoleId()) <= 1) {
            return;
        }
        this.rolePersistence.removeUsers(roleId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    public void unsetTeamUsers(long teamId, long[] userIds) throws PortalException {
        this.teamPersistence.removeUsers(teamId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    public void unsetUserGroupUsers(long userGroupId, long[] userIds) throws PortalException {
        this.userGroupPersistence.removeUsers(userGroupId, userIds);
        this.reindex(userIds);
        PermissionCacheUtil.clearCache(userIds);
    }

    public User updateAgreedToTermsOfUse(long userId, boolean agreedToTermsOfUse) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setAgreedToTermsOfUse(agreedToTermsOfUse);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateAsset(long userId, User user, long[] assetCategoryIds, String[] assetTagNames) throws PortalException {
        User owner = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(owner.getCompanyId());
        Group companyGroup = company.getGroup();
        this.assetEntryLocalService.updateEntry(userId, companyGroup.getGroupId(), user.getCreateDate(), user.getModifiedDate(), User.class.getName(), user.getUserId(), user.getUuid(), 0L, assetCategoryIds, assetTagNames, true, false, null, null, null, null, null, user.getFullName(), null, null, null, null, 0, 0, null);
    }

    public User updateCreateDate(long userId, Date createDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setCreateDate(createDate);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2) throws PortalException {
        emailAddress1 = StringUtil.toLowerCase((String)emailAddress1.trim());
        emailAddress2 = StringUtil.toLowerCase((String)emailAddress2.trim());
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
        this.userPersistence.update((BaseModel)user);
        Contact contact = user.getContact();
        contact.setEmailAddress(user.getEmailAddress());
        this.contactPersistence.update((BaseModel)contact);
        return user;
    }

    public User updateEmailAddress(long userId, String password, String emailAddress1, String emailAddress2, ServiceContext serviceContext) throws PortalException {
        emailAddress1 = StringUtil.toLowerCase((String)emailAddress1.trim());
        emailAddress2 = StringUtil.toLowerCase((String)emailAddress2.trim());
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateEmailAddress(user, emailAddress1, emailAddress2);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        if (company.isStrangersVerify() && !StringUtil.equalsIgnoreCase((String)emailAddress1, (String)user.getEmailAddress())) {
            this.sendEmailAddressVerification(user, emailAddress1, serviceContext);
        } else {
            this.setEmailAddress(user, password, user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress1);
            this.userPersistence.update((BaseModel)user);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this.contactPersistence.update((BaseModel)contact);
        }
        return user;
    }

    public User updateEmailAddressVerified(long userId, boolean emailAddressVerified) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setEmailAddressVerified(emailAddressVerified);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateFacebookId(long userId, long facebookId) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setFacebookId(facebookId);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateGoogleUserId(long userId, String googleUserId) throws PortalException {
        googleUserId = googleUserId.trim();
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validateGoogleUserId(user.getCompanyId(), userId, googleUserId);
        user.setGoogleUserId(googleUserId);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateGroups(long userId, long[] newGroupIds, ServiceContext serviceContext) throws PortalException {
        boolean indexingEnabled = true;
        if (serviceContext != null) {
            indexingEnabled = serviceContext.isIndexingEnabled();
        }
        this.updateGroups(userId, newGroupIds, serviceContext, indexingEnabled);
    }

    public User updateIncompleteUser(long creatorUserId, long companyId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, long facebookId, String openId, Locale locale, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String jobTitle, boolean updateUserInformation, boolean sendEmail, ServiceContext serviceContext) throws PortalException {
        ServiceContext workflowServiceContext;
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        if (user.getStatus() != 6) {
            throw new PortalException("Invalid user status");
        }
        User defaultUser = this.getDefaultUser(companyId);
        if (facebookId > 0L) {
            autoPassword = false;
            if (password1 == null || password2 == null) {
                password2 = password1 = PwdGenerator.getPassword();
            }
            sendEmail = false;
        }
        if (updateUserInformation) {
            autoScreenName = false;
            if (PrefsPropsUtil.getBoolean(companyId, "users.screen.name.always.autogenerate")) {
                autoScreenName = true;
            }
            this.validate(companyId, user.getUserId(), autoPassword, password1, password2, autoScreenName, screenName, emailAddress, openId, firstName, middleName, lastName, null, locale);
            if (!autoPassword && (Validator.isNull((String)password1) || Validator.isNull((String)password2))) {
                throw new UserPasswordException.MustNotBeNull(user.getUserId());
            }
            if (autoScreenName) {
                ScreenNameGenerator screenNameGenerator = ScreenNameGeneratorFactory.getInstance();
                try {
                    screenName = screenNameGenerator.generate(companyId, user.getUserId(), emailAddress);
                }
                catch (Exception e2) {
                    throw new SystemException((Throwable)e2);
                }
            }
            FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
            String fullName = fullNameGenerator.getFullName(firstName, middleName, lastName);
            String greeting = LanguageUtil.format((Locale)locale, (String)"welcome-x", (Object)fullName, (boolean)false);
            if (Validator.isNotNull((String)password1)) {
                user.setPassword(PasswordEncryptorUtil.encrypt((String)password1));
                user.setPasswordUnencrypted(password1);
            }
            user.setPasswordEncrypted(true);
            PasswordPolicy passwordPolicy = defaultUser.getPasswordPolicy();
            if (passwordPolicy != null && passwordPolicy.isChangeable() && passwordPolicy.isChangeRequired()) {
                user.setPasswordReset(true);
            } else {
                user.setPasswordReset(false);
            }
            user.setScreenName(screenName);
            user.setFacebookId(facebookId);
            user.setOpenId(openId);
            user.setLanguageId(locale.toString());
            user.setTimeZoneId(defaultUser.getTimeZoneId());
            user.setGreeting(greeting);
            user.setFirstName(firstName);
            user.setMiddleName(middleName);
            user.setLastName(lastName);
            user.setJobTitle(jobTitle);
            user.setExpandoBridgeAttributes(serviceContext);
            Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
            Contact contact = user.getContact();
            contact.setFirstName(firstName);
            contact.setMiddleName(middleName);
            contact.setLastName(lastName);
            contact.setPrefixId(prefixId);
            contact.setSuffixId(suffixId);
            contact.setMale(male);
            contact.setBirthday(birthday);
            contact.setJobTitle(jobTitle);
            this.contactPersistence.update((BaseModel)contact, serviceContext);
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        user.setStatus(2);
        this.userPersistence.update((BaseModel)user, serviceContext);
        long workflowUserId = creatorUserId;
        if (workflowUserId == user.getUserId()) {
            workflowUserId = defaultUser.getUserId();
        }
        if ((workflowServiceContext = serviceContext) == null) {
            workflowServiceContext = new ServiceContext();
        }
        workflowServiceContext.setAttribute("autoPassword", (Serializable)Boolean.valueOf(autoPassword));
        workflowServiceContext.setAttribute("passwordUnencrypted", (Serializable)((Object)password1));
        workflowServiceContext.setAttribute("sendEmail", (Serializable)Boolean.valueOf(sendEmail));
        WorkflowHandlerRegistryUtil.startWorkflowInstance((long)companyId, (long)workflowUserId, (String)User.class.getName(), (long)user.getUserId(), (Object)user, (ServiceContext)workflowServiceContext);
        return this.getUserByEmailAddress(companyId, emailAddress);
    }

    public User updateJobTitle(long userId, String jobTitle) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setJobTitle(jobTitle);
        this.userPersistence.update((BaseModel)user);
        Contact contact = this.contactPersistence.findByPrimaryKey(user.getContactId());
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact);
        return user;
    }

    public User updateLastLogin(long userId, String loginIP) throws PortalException {
        String lastLoginIP;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date lastLoginDate = user.getLoginDate();
        if (lastLoginDate == null) {
            lastLoginDate = new Date();
        }
        if ((lastLoginIP = user.getLoginIP()) == null) {
            lastLoginIP = loginIP;
        }
        user.setLoginDate(new Date());
        user.setLoginIP(loginIP);
        user.setLastLoginDate(lastLoginDate);
        user.setLastLoginIP(lastLoginIP);
        this.resetFailedLoginAttempts(user, true);
        return user;
    }

    public User updateLockout(User user, boolean lockout) throws PortalException {
        PasswordPolicy passwordPolicy = user.getPasswordPolicy();
        if (passwordPolicy == null || !passwordPolicy.isLockout()) {
            return user;
        }
        Date lockoutDate = null;
        if (lockout) {
            lockoutDate = new Date();
        }
        user.setLockout(lockout);
        user.setLockoutDate(lockoutDate);
        if (!lockout) {
            user.setFailedLoginAttempts(0);
        }
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateLockoutByEmailAddress(long companyId, String emailAddress, boolean lockout) throws PortalException {
        User user = this.getUserByEmailAddress(companyId, emailAddress);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutById(long userId, boolean lockout) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        return this.updateLockout(user, lockout);
    }

    public User updateLockoutByScreenName(long companyId, String screenName, boolean lockout) throws PortalException {
        User user = this.getUserByScreenName(companyId, screenName);
        return this.updateLockout(user, lockout);
    }

    public User updateModifiedDate(long userId, Date modifiedDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setModifiedDate(modifiedDate);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateOpenId(long userId, String openId) throws PortalException {
        openId = openId.trim();
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setOpenId(openId);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public void updateOrganizations(long userId, long[] newOrganizationIds, ServiceContext serviceContext) throws PortalException {
        this.updateOrganizations(userId, newOrganizationIds, serviceContext.isIndexingEnabled());
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset) throws PortalException {
        return this.updatePassword(userId, password1, password2, passwordReset, false);
    }

    public User updatePassword(long userId, String password1, String password2, boolean passwordReset, boolean silentUpdate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!silentUpdate) {
            this.validatePassword(user.getCompanyId(), userId, password1, password2);
        }
        String oldEncPwd = user.getPassword();
        if (!user.isPasswordEncrypted()) {
            oldEncPwd = PasswordEncryptorUtil.encrypt((String)user.getPassword());
        }
        String newEncPwd = PasswordEncryptorUtil.encrypt((String)password1);
        if (user.hasCompanyMx()) {
            this.mailService.updatePassword(user.getCompanyId(), userId, password1);
        }
        user.setPassword(newEncPwd);
        user.setPasswordUnencrypted(password1);
        user.setPasswordEncrypted(true);
        user.setPasswordReset(passwordReset);
        if (!silentUpdate || user.getPasswordModifiedDate() == null) {
            user.setPasswordModifiedDate(new Date());
        }
        user.setDigest("");
        user.setGraceLoginCount(0);
        if (!silentUpdate) {
            user.setPasswordModified(true);
        }
        PasswordModificationThreadLocal.setPasswordModified((boolean)user.getPasswordModified());
        PasswordModificationThreadLocal.setPasswordUnencrypted((String)user.getPasswordUnencrypted());
        try {
            user = (User)this.userPersistence.update((BaseModel)user);
        }
        catch (ModelListenerException mle) {
            String msg = GetterUtil.getString((String)mle.getCause().getMessage());
            if (LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                String[] errorPasswordHistoryKeywords;
                for (String errorPasswordHistoryKeyword : errorPasswordHistoryKeywords = LDAPSettingsUtil.getErrorPasswordHistoryKeywords((long)user.getCompanyId())) {
                    if (!msg.contains(errorPasswordHistoryKeyword)) continue;
                    throw new UserPasswordException.MustNotBeRecentlyUsed(userId);
                }
            }
            throw new UserPasswordException.MustComplyWithModelListeners(userId, mle);
        }
        if (!silentUpdate) {
            user.setPasswordModified(false);
            this.passwordTrackerLocalService.trackPassword(userId, oldEncPwd);
        }
        if (!silentUpdate && PrincipalThreadLocal.getUserId() != userId) {
            this.sendPasswordNotification(user, user.getCompanyId(), password1, null, null, null, null, null, ServiceContextThreadLocal.getServiceContext());
        }
        return user;
    }

    public User updatePasswordManually(long userId, String password, boolean passwordEncrypted, boolean passwordReset, Date passwordModifiedDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPassword(password);
        user.setPasswordEncrypted(passwordEncrypted);
        user.setPasswordReset(passwordReset);
        user.setPasswordModifiedDate(passwordModifiedDate);
        user.setDigest("");
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updatePasswordReset(long userId, boolean passwordReset) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setPasswordReset(passwordReset);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updatePortrait(long userId, byte[] bytes) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        PortalUtil.updateImageId((BaseModel)user, (boolean)true, (byte[])bytes, (String)"portraitId", (long)PrefsPropsUtil.getLong("users.image.max.size"), (int)PropsValues.USERS_IMAGE_MAX_HEIGHT, (int)PropsValues.USERS_IMAGE_MAX_WIDTH);
        return (User)this.userPersistence.update((BaseModel)user);
    }

    public User updateReminderQuery(long userId, String question, String answer) throws PortalException {
        this.validateReminderQuery(question, answer);
        User user = this.userPersistence.findByPrimaryKey(userId);
        user.setReminderQueryQuestion(question);
        user.setReminderQueryAnswer(answer);
        this.userPersistence.update((BaseModel)user);
        return user;
    }

    public User updateScreenName(long userId, String screenName) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        screenName = this.getLogin(screenName);
        this.validateScreenName(user.getCompanyId(), userId, screenName);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            user.setDigest("");
        }
        user.setScreenName(screenName);
        this.userPersistence.update((BaseModel)user);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group);
        return user;
    }

    @Deprecated
    public User updateStatus(long userId, int status) throws PortalException {
        return this.updateStatus(userId, status, new ServiceContext());
    }

    public User updateStatus(long userId, int status, ServiceContext serviceContext) throws PortalException {
        String passwordUnencrypted;
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (status == 0 && user.getStatus() != 0) {
            this.validateCompanyMaxUsers(user.getCompanyId());
        }
        if (Validator.isNotNull((String)(passwordUnencrypted = (String)((Object)serviceContext.getAttribute("passwordUnencrypted"))))) {
            user.setPasswordUnencrypted(passwordUnencrypted);
        }
        user.setStatus(status);
        this.userPersistence.update((BaseModel)user);
        this.reindex(user);
        Group group = user.getGroup();
        if (status == 5) {
            group.setActive(false);
        } else {
            group.setActive(true);
        }
        this.groupLocalService.updateGroup(group);
        return user;
    }

    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, boolean portrait, byte[] portraitBytes, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        String uuid;
        User user = this.userPersistence.findByPrimaryKey(userId);
        Company company = this.companyPersistence.findByPrimaryKey(user.getCompanyId());
        String password = oldPassword;
        screenName = this.getLogin(screenName);
        emailAddress = StringUtil.toLowerCase((String)emailAddress.trim());
        openId = openId.trim();
        String oldFullName = user.getFullName();
        facebookSn = StringUtil.toLowerCase((String)facebookSn.trim());
        jabberSn = StringUtil.toLowerCase((String)jabberSn.trim());
        skypeSn = StringUtil.toLowerCase((String)skypeSn.trim());
        twitterSn = StringUtil.toLowerCase((String)twitterSn.trim());
        EmailAddressGenerator emailAddressGenerator = EmailAddressGeneratorFactory.getInstance();
        if (emailAddressGenerator.isGenerated(emailAddress)) {
            emailAddress = "";
        }
        if (!PropsValues.USERS_EMAIL_ADDRESS_REQUIRED && Validator.isNull((String)emailAddress)) {
            emailAddress = emailAddressGenerator.generate(user.getCompanyId(), userId);
        }
        Locale locale = LocaleUtil.fromLanguageId((String)languageId);
        this.validate(userId, screenName, emailAddress, openId, firstName, middleName, lastName, smsSn, locale);
        if (Validator.isNotNull((String)newPassword1) || Validator.isNotNull((String)newPassword2)) {
            user = this.updatePassword(userId, newPassword1, newPassword2, passwordReset);
            password = newPassword1;
            user.setDigest("");
        }
        if (user.getContactId() <= 0L) {
            user.setContactId(this.counterLocalService.increment());
        }
        user.setPasswordReset(passwordReset);
        if (Validator.isNotNull((String)reminderQueryQuestion) && Validator.isNotNull((String)reminderQueryAnswer)) {
            user.setReminderQueryQuestion(reminderQueryQuestion);
            user.setReminderQueryAnswer(reminderQueryAnswer);
        }
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            user.setScreenName(screenName);
            user.setDigest("");
        }
        boolean sendEmailAddressVerification = false;
        if (company.isStrangersVerify() && !StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            sendEmailAddressVerification = true;
        } else {
            this.setEmailAddress(user, password, firstName, middleName, lastName, emailAddress);
        }
        if (serviceContext != null && Validator.isNotNull((String)(uuid = serviceContext.getUuid()))) {
            user.setUuid(uuid);
        }
        user.setFacebookId(facebookId);
        Long ldapServerId = null;
        if (serviceContext != null) {
            ldapServerId = (Long)serviceContext.getAttribute("ldapServerId");
        }
        if (ldapServerId != null) {
            user.setLdapServerId(ldapServerId.longValue());
        }
        user.setOpenId(openId);
        PortalUtil.updateImageId((BaseModel)user, (boolean)portrait, (byte[])portraitBytes, (String)"portraitId", (long)PrefsPropsUtil.getLong("users.image.max.size"), (int)PropsValues.USERS_IMAGE_MAX_HEIGHT, (int)PropsValues.USERS_IMAGE_MAX_WIDTH);
        user.setLanguageId(languageId);
        user.setTimeZoneId(timeZoneId);
        user.setGreeting(greeting);
        user.setComments(comments);
        user.setFirstName(firstName);
        user.setMiddleName(middleName);
        user.setLastName(lastName);
        user.setJobTitle(jobTitle);
        user.setExpandoBridgeAttributes(serviceContext);
        this.userPersistence.update((BaseModel)user, serviceContext);
        Date birthday = this.getBirthday(birthdayMonth, birthdayDay, birthdayYear);
        long contactId = user.getContactId();
        Contact contact = this.contactPersistence.fetchByPrimaryKey(contactId);
        if (contact == null) {
            contact = this.contactPersistence.create(contactId);
            contact.setCompanyId(user.getCompanyId());
            contact.setUserName("");
            contact.setClassName(User.class.getName());
            contact.setClassPK(user.getUserId());
            contact.setAccountId(company.getAccountId());
            contact.setParentContactId(0L);
        }
        contact.setEmailAddress(user.getEmailAddress());
        contact.setFirstName(firstName);
        contact.setMiddleName(middleName);
        contact.setLastName(lastName);
        contact.setPrefixId(prefixId);
        contact.setSuffixId(suffixId);
        contact.setMale(male);
        contact.setBirthday(birthday);
        contact.setSmsSn(smsSn);
        contact.setFacebookSn(facebookSn);
        contact.setJabberSn(jabberSn);
        contact.setSkypeSn(skypeSn);
        contact.setTwitterSn(twitterSn);
        contact.setJobTitle(jobTitle);
        this.contactPersistence.update((BaseModel)contact, serviceContext);
        Group group = this.groupLocalService.getUserGroup(user.getCompanyId(), userId);
        group.setFriendlyURL("/" + screenName);
        this.groupPersistence.update((BaseModel)group);
        List previousUserGroupRoles = this.userGroupRolePersistence.findByUserId(userId);
        this.updateGroups(userId, groupIds, serviceContext, false);
        this.updateOrganizations(userId, organizationIds, false);
        if (roleIds != null) {
            roleIds = UsersAdminUtil.addRequiredRoles((User)user, (long[])roleIds);
            this.userPersistence.setRoles(userId, roleIds);
        }
        this.updateUserGroupRoles(user, groupIds, organizationIds, userGroupRoles, previousUserGroupRoles);
        if (userGroupIds != null) {
            if (PropsValues.USER_GROUPS_COPY_LAYOUTS_TO_USER_PERSONAL_SITE) {
                this.userGroupLocalService.copyUserGroupLayouts(userGroupIds, userId);
            }
            this.userPersistence.setUserGroups(userId, userGroupIds);
        }
        this.announcementsDeliveryLocalService.getUserDeliveries(user.getUserId());
        if (serviceContext != null) {
            this.updateAsset(userId, user, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames());
        }
        if (GetterUtil.getBoolean((String)("users.update.user.name." + MBMessage.class.getName())) && !oldFullName.equals(user.getFullName())) {
            this.mbMessageLocalService.updateUserName(userId, user.getFullName());
        }
        if (serviceContext == null || serviceContext.isIndexingEnabled()) {
            Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
            indexer.reindex((Object)user);
        }
        if (serviceContext != null && sendEmailAddressVerification) {
            this.sendEmailAddressVerification(user, emailAddress, serviceContext);
        }
        PermissionCacheUtil.clearCache(userId);
        return user;
    }

    @Deprecated
    public User updateUser(long userId, String oldPassword, String newPassword1, String newPassword2, boolean passwordReset, String reminderQueryQuestion, String reminderQueryAnswer, String screenName, String emailAddress, long facebookId, String openId, String languageId, String timeZoneId, String greeting, String comments, String firstName, String middleName, String lastName, long prefixId, long suffixId, boolean male, int birthdayMonth, int birthdayDay, int birthdayYear, String smsSn, String facebookSn, String jabberSn, String skypeSn, String twitterSn, String jobTitle, long[] groupIds, long[] organizationIds, long[] roleIds, List<UserGroupRole> userGroupRoles, long[] userGroupIds, ServiceContext serviceContext) throws PortalException {
        return this.updateUser(userId, oldPassword, newPassword1, newPassword2, passwordReset, reminderQueryQuestion, reminderQueryAnswer, screenName, emailAddress, facebookId, openId, true, null, languageId, timeZoneId, greeting, comments, firstName, middleName, lastName, prefixId, suffixId, male, birthdayMonth, birthdayDay, birthdayYear, smsSn, facebookSn, jabberSn, skypeSn, twitterSn, jobTitle, groupIds, organizationIds, roleIds, userGroupRoles, userGroupIds, serviceContext);
    }

    public void verifyEmailAddress(String ticketKey) throws PortalException {
        Ticket ticket = this.ticketLocalService.getTicket(ticketKey);
        if (ticket.isExpired() || ticket.getType() != 1) {
            throw new NoSuchTicketException("{ticketKey=" + ticketKey + "}");
        }
        User user = this.userPersistence.findByPrimaryKey(ticket.getClassPK());
        String emailAddress = ticket.getExtraInfo();
        if (!(emailAddress = StringUtil.toLowerCase((String)emailAddress).trim()).equals(user.getEmailAddress())) {
            if (this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new UserEmailAddressException.MustNotBeDuplicate(user.getUserId(), emailAddress);
            }
            this.setEmailAddress(user, "", user.getFirstName(), user.getMiddleName(), user.getLastName(), emailAddress);
            Contact contact = user.getContact();
            contact.setEmailAddress(user.getEmailAddress());
            this.contactPersistence.update((BaseModel)contact);
        }
        user.setEmailAddressVerified(true);
        this.userPersistence.update((BaseModel)user);
        this.ticketLocalService.deleteTicket(ticket);
    }

    protected void addDefaultRolesAndTeams(long groupId, long[] userIds) throws PortalException {
        long[] defaultTeamIds;
        long[] defaultSiteRoleIds;
        ArrayList<Role> defaultSiteRoles = new ArrayList<Role>();
        Group group = this.groupLocalService.getGroup(groupId);
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        for (long defaultSiteRoleId : defaultSiteRoleIds = StringUtil.split((String)typeSettingsProperties.getProperty("defaultSiteRoleIds"), (long)0L)) {
            Role defaultSiteRole = this.rolePersistence.fetchByPrimaryKey(defaultSiteRoleId);
            if (defaultSiteRole == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find role " + defaultSiteRoleId));
                continue;
            }
            defaultSiteRoles.add(defaultSiteRole);
        }
        ArrayList<Team> defaultTeams = new ArrayList<Team>();
        for (long defaultTeamId : defaultTeamIds = StringUtil.split((String)typeSettingsProperties.getProperty("defaultTeamIds"), (long)0L)) {
            Team defaultTeam = this.teamPersistence.findByPrimaryKey(defaultTeamId);
            if (defaultTeam == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to find team " + defaultTeamId));
                continue;
            }
            defaultTeams.add(defaultTeam);
        }
        for (long userId : userIds) {
            HashSet<Long> userRoleIdsSet = new HashSet<Long>();
            for (Role role : defaultSiteRoles) {
                userRoleIdsSet.add(role.getRoleId());
            }
            long[] userRoleIds = ArrayUtil.toArray((Long[])userRoleIdsSet.toArray(new Long[userRoleIdsSet.size()]));
            this.userGroupRoleLocalService.addUserGroupRoles(userId, groupId, userRoleIds);
            HashSet<Long> userTeamIdsSet = new HashSet<Long>();
            for (Team team : defaultTeams) {
                userTeamIdsSet.add(team.getTeamId());
            }
            long[] userTeamIds = ArrayUtil.toArray((Long[])userTeamIdsSet.toArray(new Long[userTeamIdsSet.size()]));
            this.userPersistence.addTeams(userId, userTeamIds);
        }
    }

    protected int authenticate(long companyId, String login, String password, String authType, Map<String, String[]> headerMap, Map<String, String[]> parameterMap, Map<String, Object> resultsMap) throws PortalException {
        if (PropsValues.AUTH_LOGIN_DISABLED) {
            return -1;
        }
        login = StringUtil.toLowerCase((String)login.trim());
        long userId = GetterUtil.getLong((String)login);
        if (authType.equals("emailAddress")) {
            if (Validator.isNull((String)login)) {
                throw new UserEmailAddressException.MustNotBeNull();
            }
        } else if (authType.equals("screenName")) {
            if (Validator.isNull((String)login)) {
                throw new UserScreenNameException.MustNotBeNull();
            }
        } else if (authType.equals("userId") && Validator.isNull((String)login)) {
            throw new UserIdException.MustNotBeNull();
        }
        if (Validator.isNull((String)password)) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("screenName")) {
            authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.pre", companyId, login, password, headerMap, parameterMap);
        } else if (authType.equals("userId")) {
            authResult = AuthPipeline.authenticateByUserId("auth.pipeline.pre", companyId, userId, password, headerMap, parameterMap);
        }
        User user = null;
        if (authType.equals("emailAddress")) {
            user = this.fetchUserByEmailAddress(companyId, login);
        } else if (authType.equals("screenName")) {
            user = this.fetchUserByScreenName(companyId, login);
        } else if (authType.equals("userId")) {
            user = this.userPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)login));
        }
        if (user == null) {
            return 0;
        }
        if (!this.isUserAllowedToAuthenticate(user)) {
            return -1;
        }
        if (!user.isPasswordEncrypted()) {
            user.setPassword(PasswordEncryptorUtil.encrypt((String)user.getPassword()));
            user.setPasswordEncrypted(true);
            this.userPersistence.update((BaseModel)user);
        }
        boolean skipLiferayCheck = false;
        if (authResult == 2) {
            authResult = 1;
            skipLiferayCheck = true;
        } else if (authResult == 1 && PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK) {
            boolean authenticated = PwdAuthenticator.authenticate(login, password, user.getPassword());
            authResult = authenticated ? 1 : -1;
        }
        if (authResult == 1) {
            if (authType.equals("emailAddress")) {
                authResult = AuthPipeline.authenticateByEmailAddress("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                authResult = AuthPipeline.authenticateByScreenName("auth.pipeline.post", companyId, login, password, headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                authResult = AuthPipeline.authenticateByUserId("auth.pipeline.post", companyId, userId, password, headerMap, parameterMap);
            }
        }
        if (resultsMap != null) {
            resultsMap.put("userId", user.getUserId());
        }
        if (authResult == 1 && (skipLiferayCheck || !PropsValues.AUTH_PIPELINE_ENABLE_LIFERAY_CHECK || Validator.isNull((String)user.getDigest()))) {
            user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
            String digest = user.getDigest(password);
            user.setDigest(digest);
            this.userPersistence.update((BaseModel)user);
        }
        if (authResult == -1) {
            authResult = this.handleAuthenticationFailure(login, authType, user, headerMap, parameterMap);
        } else {
            this.resetFailedLoginAttempts(user);
        }
        return authResult;
    }

    protected SearchContext buildSearchContext(long companyId, String firstName, String middleName, String lastName, String fullName, String screenName, String emailAddress, String street, String city, String zip, String region, String country, int status, LinkedHashMap<String, Object> params, boolean andSearch, int start, int end, Sort[] sorts) {
        String keywords;
        SearchContext searchContext = new SearchContext();
        searchContext.setAndSearch(andSearch);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("city", city);
        attributes.put("country", country);
        attributes.put("emailAddress", emailAddress);
        attributes.put("firstName", firstName);
        attributes.put("fullName", fullName);
        attributes.put("lastName", lastName);
        attributes.put("middleName", middleName);
        attributes.put("params", params);
        attributes.put("region", region);
        attributes.put("screenName", screenName);
        attributes.put("street", street);
        attributes.put("status", status);
        attributes.put("zip", zip);
        searchContext.setAttributes(attributes);
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        if (params != null && Validator.isNotNull((String)(keywords = (String)params.remove("keywords")))) {
            searchContext.setKeywords(keywords);
        }
        if (sorts != null) {
            searchContext.setSorts(sorts);
        }
        searchContext.setStart(start);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        return searchContext;
    }

    protected Date getBirthday(int birthdayMonth, int birthdayDay, int birthdayYear) throws PortalException {
        Date birthday = PortalUtil.getDate((int)birthdayMonth, (int)birthdayDay, (int)birthdayYear, ContactBirthdayException.class);
        if (birthday.after(new Date())) {
            throw new ContactBirthdayException();
        }
        return birthday;
    }

    protected String getLogin(String login) {
        return StringUtil.lowerCase((String)StringUtil.trim((String)login));
    }

    protected Sort[] getSorts(OrderByComparator<User> obc) {
        if (obc == null) {
            return new Sort[0];
        }
        String[] orderByClauses = StringUtil.split((String)obc.getOrderBy());
        String[] orderByFields = obc.getOrderByFields();
        Sort[] sorts = new Sort[orderByFields.length];
        for (int i = 0; i < orderByFields.length; ++i) {
            boolean reverse = orderByClauses[i].contains("DESC");
            sorts[i] = new Sort(orderByFields[i], reverse);
        }
        return sorts;
    }

    protected int handleAuthenticationFailure(String login, String authType, User user, Map<String, String[]> headerMap, Map<String, String[]> parameterMap) {
        if (user == null) {
            return 0;
        }
        try {
            if (authType.equals("emailAddress")) {
                AuthPipeline.onFailureByEmailAddress("auth.failure", user.getCompanyId(), user.getEmailAddress(), headerMap, parameterMap);
            } else if (authType.equals("screenName")) {
                AuthPipeline.onFailureByScreenName("auth.failure", user.getCompanyId(), user.getScreenName(), headerMap, parameterMap);
            } else if (authType.equals("userId")) {
                AuthPipeline.onFailureByUserId("auth.failure", user.getCompanyId(), user.getUserId(), headerMap, parameterMap);
            }
            user = this.userPersistence.fetchByPrimaryKey(user.getUserId());
            if (user == null) {
                return 0;
            }
            if (!LDAPSettingsUtil.isPasswordPolicyEnabled((long)user.getCompanyId())) {
                int maxFailures;
                PasswordPolicy passwordPolicy = user.getPasswordPolicy();
                int failedLoginAttempts = (user = this.userPersistence.fetchByPrimaryKey(user.getUserId())).getFailedLoginAttempts();
                if (failedLoginAttempts >= (maxFailures = passwordPolicy.getMaxFailure()) && maxFailures != 0) {
                    if (authType.equals("emailAddress")) {
                        AuthPipeline.onMaxFailuresByEmailAddress("auth.max.failures", user.getCompanyId(), user.getEmailAddress(), headerMap, parameterMap);
                    } else if (authType.equals("screenName")) {
                        AuthPipeline.onMaxFailuresByScreenName("auth.max.failures", user.getCompanyId(), user.getScreenName(), headerMap, parameterMap);
                    } else if (authType.equals("userId")) {
                        AuthPipeline.onMaxFailuresByUserId("auth.max.failures", user.getCompanyId(), user.getUserId(), headerMap, parameterMap);
                    }
                }
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return -1;
    }

    protected boolean isUseCustomSQL(LinkedHashMap<String, Object> params) {
        if (MapUtil.isEmpty(params)) {
            return false;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            String key = entry.getKey();
            if (key.equals("inherit")) {
                if (!Boolean.TRUE.equals(entry.getValue())) continue;
                return true;
            }
            if (key.equals("noOrganizations")) {
                if (!Boolean.TRUE.equals(entry.getValue())) {
                    return true;
                }
                Object usersOrgsCount = params.get("usersOrgsCount");
                if (usersOrgsCount != null && GetterUtil.getLong((Object)usersOrgsCount) == 0L) continue;
                return true;
            }
            if (key.equals("usersGroups") || key.equals("usersOrgs") || key.equals("usersOrgsCount") || key.equals("usersRoles") || key.equals("usersTeams") || key.equals("usersUserGroups")) continue;
            return true;
        }
        return false;
    }

    protected boolean isUserAllowedToAuthenticate(User user) throws PortalException {
        if (user.isDefaultUser()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Authentication is disabled for the default user");
            }
            return false;
        }
        if (!user.isActive()) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Authentication is disabled for inactive user " + user.getUserId()));
            }
            return false;
        }
        this.checkLockout(user);
        this.checkPasswordExpired(user);
        return true;
    }

    protected void notifyUser(User user, String password, ServiceContext serviceContext) {
        if (!PrefsPropsUtil.getBoolean(user.getCompanyId(), "admin.email.user.added.enabled")) {
            return;
        }
        String fromName = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.name");
        String fromAddress = PrefsPropsUtil.getString(user.getCompanyId(), "admin.email.from.address");
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(user.getCompanyId(), true);
        Map localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedSubject", (String)"admin.email.user.added.subject");
        Map localizedBodyMap = null;
        localizedBodyMap = Validator.isNotNull((String)password) ? LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedBody", (String)"admin.email.user.added.body") : LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)"adminEmailUserAddedNoPasswordBody", (String)"admin.email.user.added.no.password.body");
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(user.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$USER_ID$]", user.getUserId(), "[$USER_PASSWORD$]", password, "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void reindex(long userId) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        User user = this.userLocalService.fetchUser(userId);
        indexer.reindex((Object)user);
    }

    protected void reindex(long[] userIds) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        ArrayList<User> users = new ArrayList<User>(userIds.length);
        long[] arr$ = userIds;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long userId = arr$[i$];
            User user = this.userLocalService.fetchUser(userId.longValue());
            users.add(user);
        }
        indexer.reindex(users);
    }

    protected void reindex(User user) throws SearchException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        indexer.reindex((Object)user);
    }

    protected void resetFailedLoginAttempts(User user) {
        this.resetFailedLoginAttempts(user, false);
    }

    protected void resetFailedLoginAttempts(User user, boolean forceUpdate) {
        if (forceUpdate || user.getFailedLoginAttempts() > 0) {
            user.setFailedLoginAttempts(0);
            this.userPersistence.update((BaseModel)user);
        }
    }

    protected BaseModelSearchResult<User> searchUsers(SearchContext searchContext) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(User.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List users = UsersAdminUtil.getUsers((Hits)hits);
            if (users == null) continue;
            return new BaseModelSearchResult(users, hits.getLength());
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    protected void sendPasswordNotification(User user, long companyId, String newPassword, String passwordResetURL, String fromName, String fromAddress, String subject, String body, ServiceContext serviceContext) {
        if (Validator.isNull((String)fromName)) {
            fromName = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        if (Validator.isNull((String)fromAddress)) {
            fromAddress = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        String toName = user.getFullName();
        String toAddress = user.getEmailAddress();
        PortletPreferences companyPortletPreferences = PrefsPropsUtil.getPreferences(companyId, true);
        Map localizedSubjectMap = null;
        Map localizedBodyMap = null;
        String bodyProperty = null;
        String prefix = null;
        String subjectProperty = null;
        if (Validator.isNotNull((String)passwordResetURL)) {
            bodyProperty = "admin.email.password.reset.body";
            prefix = "adminEmailPasswordReset";
            subjectProperty = "admin.email.password.reset.subject";
        } else {
            bodyProperty = "admin.email.password.sent.body";
            prefix = "adminEmailPasswordSent";
            subjectProperty = "admin.email.password.sent.subject";
        }
        if (Validator.isNull((String)body)) {
            localizedBodyMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)(prefix + "Body"), (String)bodyProperty);
        }
        if (Validator.isNull((String)subject)) {
            localizedSubjectMap = LocalizationUtil.getLocalizationMap((PortletPreferences)companyPortletPreferences, (String)(prefix + "Subject"), (String)subjectProperty);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(companyId);
        subscriptionSender.setContextAttributes(new Object[]{"[$PASSWORD_RESET_URL$]", passwordResetURL, "[$REMOTE_ADDRESS$]", serviceContext.getRemoteAddr(), "[$REMOTE_HOST$]", serviceContext.getRemoteHost(), "[$USER_ID$]", user.getUserId(), "[$USER_PASSWORD$]", newPassword, "[$USER_SCREENNAME$]", user.getScreenName()});
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("user", new Object[]{user.getUserId()});
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.addRuntimeSubscribers(toAddress, toName);
        subscriptionSender.flushNotificationsAsync();
    }

    protected void setEmailAddress(User user, String password, String firstName, String middleName, String lastName, String emailAddress) throws PortalException {
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)user.getEmailAddress())) {
            return;
        }
        long userId = user.getUserId();
        if (!user.hasCompanyMx() && user.hasCompanyMx(emailAddress) && Validator.isNotNull((String)password)) {
            this.mailService.addUser(user.getCompanyId(), userId, password, firstName, middleName, lastName, emailAddress);
        } else if (user.hasCompanyMx() && user.hasCompanyMx(emailAddress)) {
            this.mailService.updateEmailAddress(user.getCompanyId(), userId, emailAddress);
        } else if (user.hasCompanyMx() && !user.hasCompanyMx(emailAddress)) {
            this.mailService.deleteEmailAddress(user.getCompanyId(), userId);
        }
        user.setEmailAddress(emailAddress);
        user.setDigest("");
    }

    protected void updateGroups(long userId, long[] newGroupIds, ServiceContext serviceContext, boolean indexingEnabled) throws PortalException {
        long[] oldGroupIds;
        if (newGroupIds == null) {
            return;
        }
        for (long oldGroupId : oldGroupIds = this.getGroupPrimaryKeys(userId)) {
            if (ArrayUtil.contains((long[])newGroupIds, (long)oldGroupId)) continue;
            this.userLocalService.unsetGroupUsers(oldGroupId, new long[]{userId}, serviceContext);
        }
        for (long newGroupId : newGroupIds) {
            if (ArrayUtil.contains((long[])oldGroupIds, (long)newGroupId)) continue;
            this.userLocalService.addGroupUsers(newGroupId, new long[]{userId});
        }
        if (indexingEnabled) {
            this.reindex(userId);
        }
        PermissionCacheUtil.clearCache(userId);
    }

    protected void updateOrganizations(long userId, long[] newOrganizationIds, boolean indexingEnabled) throws PortalException {
        long[] oldOrganizationIds;
        if (newOrganizationIds == null) {
            return;
        }
        for (long oldOrganizationId : oldOrganizationIds = this.getOrganizationPrimaryKeys(userId)) {
            if (ArrayUtil.contains((long[])newOrganizationIds, (long)oldOrganizationId)) continue;
            this.unsetOrganizationUsers(oldOrganizationId, new long[]{userId});
        }
        for (long newOrganizationId : newOrganizationIds) {
            if (ArrayUtil.contains((long[])oldOrganizationIds, (long)newOrganizationId)) continue;
            this.addOrganizationUsers(newOrganizationId, new long[]{userId});
        }
        if (indexingEnabled) {
            this.reindex(userId);
        }
        PermissionCacheUtil.clearCache(userId);
    }

    protected void updateUserGroupRoles(User user, long[] groupIds, long[] organizationIds, List<UserGroupRole> userGroupRoles, List<UserGroupRole> previousUserGroupRoles) throws PortalException {
        if (userGroupRoles == null) {
            return;
        }
        userGroupRoles = new ArrayList<UserGroupRole>(userGroupRoles);
        for (UserGroupRole userGroupRole : previousUserGroupRoles) {
            if (userGroupRoles.contains(userGroupRole)) {
                userGroupRoles.remove(userGroupRole);
                continue;
            }
            this.userGroupRoleLocalService.deleteUserGroupRole(userGroupRole);
        }
        if (ListUtil.isEmpty(userGroupRoles)) {
            return;
        }
        long[] validGroupIds = null;
        validGroupIds = groupIds != null ? ArrayUtil.clone((long[])groupIds) : user.getGroupIds();
        if (organizationIds == null) {
            organizationIds = user.getOrganizationIds();
        }
        for (long organizationId : organizationIds) {
            Organization organization = this.organizationPersistence.findByPrimaryKey(organizationId);
            validGroupIds = ArrayUtil.append((long[])validGroupIds, (long)organization.getGroupId());
        }
        Arrays.sort(validGroupIds);
        for (UserGroupRole userGroupRole : userGroupRoles) {
            if (Arrays.binarySearch(validGroupIds, userGroupRole.getGroupId()) < 0) continue;
            this.userGroupRoleLocalService.addUserGroupRole(userGroupRole);
        }
    }

    protected void validate(long companyId, long userId, boolean autoPassword, String password1, String password2, boolean autoScreenName, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, long[] organizationIds, Locale locale) throws PortalException {
        User user;
        this.validateCompanyMaxUsers(companyId);
        if (!autoScreenName) {
            this.validateScreenName(companyId, userId, screenName);
        }
        if (!autoPassword) {
            PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getDefaultPasswordPolicy(companyId);
            PwdToolkitUtil.validate(companyId, 0L, password1, password2, passwordPolicy);
        }
        this.validateEmailAddress(companyId, emailAddress);
        if (Validator.isNotNull((String)emailAddress) && (user = this.userPersistence.fetchByC_EA(companyId, emailAddress)) != null && user.getUserId() != userId) {
            throw new UserEmailAddressException.MustNotBeDuplicate(userId, emailAddress);
        }
        this.validateOpenId(companyId, userId, openId);
        this.validateFullName(companyId, firstName, middleName, lastName, locale);
        if (organizationIds != null) {
            for (long organizationId : organizationIds) {
                Organization organization = this.organizationPersistence.fetchByPrimaryKey(organizationId);
                if (organization != null) continue;
                throw new NoSuchOrganizationException("{organizationId=" + organizationId + "}");
            }
        }
    }

    protected void validate(long userId, String screenName, String emailAddress, String openId, String firstName, String middleName, String lastName, String smsSn, Locale locale) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (!StringUtil.equalsIgnoreCase((String)user.getScreenName(), (String)screenName)) {
            this.validateScreenName(user.getCompanyId(), userId, screenName);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress);
        this.validateOpenId(user.getCompanyId(), userId, openId);
        if (!user.isDefaultUser()) {
            if (Validator.isNotNull((String)emailAddress) && !StringUtil.equalsIgnoreCase((String)user.getEmailAddress(), (String)emailAddress) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress) != null) {
                throw new UserEmailAddressException.MustNotBeDuplicate(userId, emailAddress);
            }
            this.validateFullName(user.getCompanyId(), firstName, middleName, lastName, locale);
        }
        if (Validator.isNotNull((String)smsSn) && !Validator.isEmailAddress((String)smsSn)) {
            throw new UserSmsException.MustBeEmailAddress(smsSn);
        }
    }

    protected void validateCompanyMaxUsers(long companyId) throws PortalException {
        Company company = this.companyPersistence.findByPrimaryKey(companyId);
        if (company.isSystem() || company.getMaxUsers() == 0) {
            return;
        }
        int userCount = this.searchCount(companyId, null, 0, null);
        if (userCount >= company.getMaxUsers()) {
            throw new CompanyMaxUsersException();
        }
    }

    protected void validateEmailAddress(long companyId, String emailAddress) throws PortalException {
        String[] reservedEmailAddresses;
        if (Validator.isNull((String)emailAddress) && !PropsValues.USERS_EMAIL_ADDRESS_REQUIRED) {
            return;
        }
        EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
        if (!emailAddressValidator.validate(companyId, emailAddress)) {
            throw new UserEmailAddressException.MustValidate(emailAddress, emailAddressValidator);
        }
        String pop3User = PrefsPropsUtil.getString("mail.session.mail.pop3.user", PropsValues.MAIL_SESSION_MAIL_POP3_USER);
        if (StringUtil.equalsIgnoreCase((String)emailAddress, (String)pop3User)) {
            throw new UserEmailAddressException.MustNotBePOP3User(emailAddress);
        }
        for (String reservedEmailAddress : reservedEmailAddresses = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.email.addresses", "\n", PropsValues.ADMIN_RESERVED_EMAIL_ADDRESSES)) {
            if (!StringUtil.equalsIgnoreCase((String)emailAddress, (String)reservedEmailAddress)) continue;
            throw new UserEmailAddressException.MustNotBeReserved(emailAddress, reservedEmailAddresses);
        }
    }

    protected void validateEmailAddress(User user, String emailAddress1, String emailAddress2) throws PortalException {
        if (!emailAddress1.equals(emailAddress2)) {
            throw new UserEmailAddressException.MustBeEqual(user, emailAddress1, emailAddress2);
        }
        this.validateEmailAddress(user.getCompanyId(), emailAddress1);
        this.validateEmailAddress(user.getCompanyId(), emailAddress2);
        if (!StringUtil.equalsIgnoreCase((String)emailAddress1, (String)user.getEmailAddress()) && this.userPersistence.fetchByC_EA(user.getCompanyId(), emailAddress1) != null) {
            throw new UserEmailAddressException.MustNotBeDuplicate(user.getUserId(), emailAddress1);
        }
    }

    protected void validateFullName(long companyId, String firstName, String middleName, String lastName, Locale locale) throws PortalException {
        FullNameDefinition fullNameDefinition = FullNameDefinitionFactory.getInstance((Locale)locale);
        if (Validator.isNull((String)firstName)) {
            throw new ContactNameException.MustHaveFirstName();
        }
        if (Validator.isNull((String)middleName) && fullNameDefinition.isFieldRequired("middle-name")) {
            throw new ContactNameException.MustHaveMiddleName();
        }
        if (Validator.isNull((String)lastName) && fullNameDefinition.isFieldRequired("last-name")) {
            throw new ContactNameException.MustHaveLastName();
        }
        FullNameValidator fullNameValidator = FullNameValidatorFactory.getInstance();
        if (!fullNameValidator.validate(companyId, firstName, middleName, lastName)) {
            throw new ContactNameException.MustHaveValidFullName(fullNameValidator);
        }
    }

    protected void validateGoogleUserId(long companyId, long userId, String googleUserId) throws PortalException {
        if (Validator.isNull((String)googleUserId)) {
            return;
        }
        User user = this.userPersistence.fetchByC_GUID(companyId, googleUserId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateGoogleUserIdException("New user " + userId + " conflicts with existing user " + userId + " who is already associated with Google user ID " + googleUserId);
        }
    }

    protected void validateOpenId(long companyId, long userId, String openId) throws PortalException {
        if (Validator.isNull((String)openId)) {
            return;
        }
        User user = this.userPersistence.fetchByC_O(companyId, openId);
        if (user != null && user.getUserId() != userId) {
            throw new DuplicateOpenIdException("{userId=" + userId + "}");
        }
    }

    protected void validatePassword(long companyId, long userId, String password1, String password2) throws PortalException {
        if (Validator.isNull((String)password1) || Validator.isNull((String)password2)) {
            throw new UserPasswordException.MustNotBeNull(userId);
        }
        if (!password1.equals(password2)) {
            throw new UserPasswordException.MustMatch(userId);
        }
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        PwdToolkitUtil.validate(companyId, userId, password1, password2, passwordPolicy);
    }

    protected void validateReminderQuery(String question, String answer) throws PortalException {
        if (!PropsValues.USERS_REMINDER_QUERIES_ENABLED) {
            return;
        }
        if (Validator.isNull((String)question)) {
            throw new UserReminderQueryException("Question is null");
        }
        if (Validator.isNull((String)answer)) {
            throw new UserReminderQueryException("Answer is null");
        }
    }

    protected void validateScreenName(long companyId, long userId, String screenName) throws PortalException {
        String[] reservedScreenNames;
        String[] anonymousNames;
        if (Validator.isNull((String)screenName)) {
            throw new UserScreenNameException.MustNotBeNull(userId);
        }
        ScreenNameValidator screenNameValidator = ScreenNameValidatorFactory.getInstance();
        if (!screenNameValidator.validate(companyId, screenName)) {
            throw new UserScreenNameException.MustValidate(userId, screenName, screenNameValidator);
        }
        if (Validator.isNumber((String)screenName)) {
            Group group;
            if (!PropsValues.USERS_SCREEN_NAME_ALLOW_NUMERIC) {
                throw new UserScreenNameException.MustNotBeNumeric(userId, screenName);
            }
            if (!screenName.equals(String.valueOf(userId)) && (group = this.groupPersistence.fetchByPrimaryKey(GetterUtil.getLong((String)screenName))) != null) {
                throw new UserScreenNameException.MustNotBeUsedByGroup(userId, screenName, group);
            }
        }
        for (String anonymousName : anonymousNames = BaseServiceImpl.ANONYMOUS_NAMES) {
            if (!StringUtil.equalsIgnoreCase((String)screenName, (String)anonymousName)) continue;
            throw new UserScreenNameException.MustNotBeReservedForAnonymous(userId, screenName, anonymousNames);
        }
        User user = this.userPersistence.fetchByC_SN(companyId, screenName);
        if (user != null && user.getUserId() != userId) {
            throw new UserScreenNameException.MustNotBeDuplicate(user.getUserId(), screenName);
        }
        String friendlyURL = "/" + screenName;
        Group group = this.groupPersistence.fetchByC_F(companyId, friendlyURL);
        if (group != null && group.getClassPK() != userId) {
            GroupFriendlyURLException gfurle = new GroupFriendlyURLException(6);
            gfurle.setDuplicateClassPK(group.getGroupId());
            gfurle.setDuplicateClassName(Group.class.getName());
            throw gfurle;
        }
        int exceptionType = LayoutImpl.validateFriendlyURL(friendlyURL);
        if (exceptionType != -1) {
            throw new UserScreenNameException.MustProduceValidFriendlyURL(userId, screenName, exceptionType);
        }
        for (String reservedScreenName : reservedScreenNames = PrefsPropsUtil.getStringArray(companyId, "admin.reserved.screen.names", "\n", PropsValues.ADMIN_RESERVED_SCREEN_NAMES)) {
            if (!StringUtil.equalsIgnoreCase((String)screenName, (String)reservedScreenName)) continue;
            throw new UserScreenNameException.MustNotBeReserved(userId, screenName, reservedScreenNames);
        }
    }
}

