/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.NoSuchReleaseException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.upgrade.OlderVersionException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.ReleaseLocalServiceBaseImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ReleaseLocalServiceImpl
extends ReleaseLocalServiceBaseImpl {
    private static final String _GET_BUILD_NUMBER = "select buildNumber from Release_ where releaseId = ?";
    private static final String _TEST_DATABASE_STRING_CASE_SENSITIVITY = "select count(*) from Release_ where releaseId = ? and testString = ?";
    private static final Log _log = LogFactoryUtil.getLog(ReleaseLocalServiceImpl.class);

    public Release addRelease(String servletContextName, int buildNumber) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date now = new Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setBuildNumber(buildNumber);
        if (servletContextName.equals("portal")) {
            release.setTestString("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        this.releasePersistence.update((BaseModel)release);
        return release;
    }

    public Release addRelease(String servletContextName, String schemaVersion) {
        Release release = null;
        if (servletContextName.equals("portal")) {
            release = this.releasePersistence.create(1L);
        } else {
            long releaseId = this.counterLocalService.increment();
            release = this.releasePersistence.create(releaseId);
        }
        Date now = new Date();
        release.setCreateDate(now);
        release.setModifiedDate(now);
        release.setServletContextName(servletContextName);
        release.setSchemaVersion(schemaVersion);
        if (servletContextName.equals("portal")) {
            release.setTestString("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        this.releasePersistence.update((BaseModel)release);
        return release;
    }

    public void createTablesAndPopulate() {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Create tables and populate with default data");
            }
            DB db = DBManagerUtil.getDB();
            db.runSQLTemplate("portal-tables.sql", false);
            db.runSQLTemplate("portal-data-common.sql", false);
            db.runSQLTemplate("portal-data-counter.sql", false);
            db.runSQLTemplate("portal-data-release.sql", false);
            db.runSQLTemplate("indexes.sql", false);
            db.runSQLTemplate("sequences.sql", false);
            StartupHelperUtil.setDbNew(true);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            throw new SystemException((Throwable)e2);
        }
    }

    public Release fetchRelease(String servletContextName) {
        if (Validator.isNull((String)servletContextName)) {
            throw new IllegalArgumentException("Servlet context name is null");
        }
        Release release = null;
        release = servletContextName.equals("portal") ? this.releasePersistence.fetchByPrimaryKey(1L) : this.releasePersistence.fetchByServletContextName(servletContextName);
        return release;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBuildNumberOrCreate() throws PortalException {
        DB db;
        block13: {
            db = DBManagerUtil.getDB();
            try {
                db.runSQL("alter table Release_ add schemaVersion VARCHAR(75) null");
                this.populateVersion();
            }
            catch (Exception e2) {
                if (!_log.isDebugEnabled()) break block13;
                _log.debug((Object)e2.getMessage());
            }
        }
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_BUILD_NUMBER);
            ps.setLong(1, 1L);
            rs = ps.executeQuery();
            if (rs.next()) {
                int buildNumber;
                block14: {
                    buildNumber = rs.getInt("buildNumber");
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Build number " + buildNumber));
                    }
                    try {
                        db.runSQL("alter table Release_ add state_ INTEGER");
                    }
                    catch (Exception e3) {
                        if (!_log.isDebugEnabled()) break block14;
                        _log.debug((Object)e3.getMessage());
                    }
                }
                this.testSupportsStringCaseSensitiveQuery();
                int n = buildNumber;
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return n;
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        catch (Exception e4) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e4.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("schema.run.enabled"))) {
            this.releaseLocalService.createTablesAndPopulate();
            this.testSupportsStringCaseSensitiveQuery();
            Release release = this.fetchRelease("portal");
            return release.getBuildNumber();
        }
        throw new NoSuchReleaseException("The database needs to be populated");
    }

    public Release updateRelease(long releaseId, String schemaVersion, int buildNumber, Date buildDate, boolean verified) throws PortalException {
        Release release = this.releasePersistence.findByPrimaryKey(releaseId);
        release.setModifiedDate(new Date());
        release.setSchemaVersion(schemaVersion);
        release.setBuildNumber(buildNumber);
        release.setBuildDate(buildDate);
        release.setVerified(verified);
        this.releasePersistence.update((BaseModel)release);
        return release;
    }

    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, int buildNumber, int previousBuildNumber, boolean indexOnUpgrade) throws PortalException {
        if (buildNumber <= 0) {
            _log.error((Object)("Skipping upgrade processes for " + servletContextName + " because \"release.info.build.number\" is not specified"));
            return;
        }
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            release = this.releaseLocalService.addRelease(servletContextName, previousBuildNumber);
        }
        if (buildNumber == release.getBuildNumber()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping upgrade processes for " + servletContextName + " because it is already up to date"));
            }
        } else {
            if (buildNumber < release.getBuildNumber()) {
                throw new OlderVersionException("Skipping upgrade processes for " + servletContextName + " because you are trying to upgrade with an older version");
            }
            UpgradeProcessUtil.upgradeProcess((int)release.getBuildNumber(), upgradeProcesses, (boolean)indexOnUpgrade);
        }
        this.releaseLocalService.updateRelease(release.getReleaseId(), release.getSchemaVersion(), buildNumber, null, true);
    }

    public void updateRelease(String servletContextName, List<UpgradeProcess> upgradeProcesses, Properties unfilteredPortalProperties) throws Exception {
        int buildNumber = GetterUtil.getInteger((String)unfilteredPortalProperties.getProperty("release.info.build.number"));
        int previousBuildNumber = GetterUtil.getInteger((String)unfilteredPortalProperties.getProperty("release.info.previous.build.number"), (int)buildNumber);
        boolean indexOnUpgrade = GetterUtil.getBoolean((String)unfilteredPortalProperties.getProperty("index.on.upgrade"), (boolean)PropsValues.INDEX_ON_UPGRADE);
        this.updateRelease(servletContextName, upgradeProcesses, buildNumber, previousBuildNumber, indexOnUpgrade);
    }

    public void updateRelease(String servletContextName, String schemaVersion, String previousSchemaVersion) {
        String currentSchemaVersion;
        Release release = this.releaseLocalService.fetchRelease(servletContextName);
        if (release == null) {
            if (previousSchemaVersion.equals("0.0.0")) {
                release = this.releaseLocalService.addRelease(servletContextName, previousSchemaVersion);
            } else {
                throw new IllegalStateException("Unable to update release because it does not exist");
            }
        }
        if (Validator.isNull((String)(currentSchemaVersion = release.getSchemaVersion()))) {
            currentSchemaVersion = "0.0.0";
        }
        if (!previousSchemaVersion.equals(currentSchemaVersion)) {
            StringBundler sb = new StringBundler(5);
            sb.append("Unable to update release because the previous schema ");
            sb.append("version ");
            sb.append(previousSchemaVersion);
            sb.append(" does not match the expected schema version ");
            sb.append(currentSchemaVersion);
            throw new IllegalStateException(sb.toString());
        }
        release.setSchemaVersion(schemaVersion);
        this.releasePersistence.update((BaseModel)release);
    }

    protected void populateVersion() {
    }

    protected void testSupportsStringCaseSensitiveQuery() {
        DB db = DBManagerUtil.getDB();
        int count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        if (count == 0) {
            block9: {
                block8: {
                    try {
                        db.runSQL("alter table Release_ add testString VARCHAR(1024) null");
                    }
                    catch (Exception e2) {
                        if (!_log.isDebugEnabled()) break block8;
                        _log.debug((Object)e2.getMessage());
                    }
                }
                try {
                    db.runSQL("update Release_ set testString = 'You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.'");
                }
                catch (Exception e3) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug((Object)e3.getMessage());
                }
            }
            count = this.testSupportsStringCaseSensitiveQuery("You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes.");
        }
        if (count == 0) {
            throw new SystemException("Release_ table was not initialized properly");
        }
        count = this.testSupportsStringCaseSensitiveQuery(StringUtil.toUpperCase((String)"You take the blue pill, the story ends, you wake up in your bed and believe whatever you want to believe. You take the red pill, you stay in Wonderland, and I show you how deep the rabbit hole goes."));
        if (count == 0) {
            db.setSupportsStringCaseSensitiveQuery(true);
        } else {
            db.setSupportsStringCaseSensitiveQuery(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int testSupportsStringCaseSensitiveQuery(String testString) {
        int count = 0;
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_TEST_DATABASE_STRING_CASE_SENSITIVITY);
            ps.setLong(1, 1L);
            ps.setString(2, testString);
            rs = ps.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2.getMessage());
            }
        }
        finally {
            DataAccess.cleanUp((Connection)con, (Statement)ps, rs);
        }
        return count;
    }
}

