/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetPrototype;
import com.liferay.portal.kernel.service.LayoutSetPrototypeLocalServiceUtil;
import com.liferay.portal.kernel.service.persistence.LayoutSetPrototypeUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Date;

public class LayoutSetPrototypeLayoutSetModelListener
extends BaseModelListener<LayoutSet> {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetPrototypeLayoutSetModelListener.class);

    public void onAfterCreate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    public void onAfterRemove(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, new Date());
    }

    public void onAfterUpdate(LayoutSet layoutSet) {
        this.updateLayoutSetPrototype(layoutSet, layoutSet.getModifiedDate());
    }

    protected void updateLayoutSetPrototype(LayoutSet layoutSet, Date modifiedDate) {
        if (layoutSet == null) {
            return;
        }
        Group group = null;
        try {
            group = layoutSet.getGroup();
            if (!group.isLayoutSetPrototype()) {
                return;
            }
        }
        catch (PortalException pe) {
            return;
        }
        try {
            LayoutSetPrototype layoutSetPrototype = LayoutSetPrototypeLocalServiceUtil.getLayoutSetPrototype((long)group.getClassPK());
            layoutSetPrototype.setModifiedDate(modifiedDate);
            UnicodeProperties settingsProperties = layoutSet.getSettingsProperties();
            settingsProperties.remove((Object)"merge-fail-count");
            LayoutSetPrototypeUtil.update((LayoutSetPrototype)layoutSetPrototype);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }
}

