/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutBranchPermissionUtil;
import com.liferay.portal.service.base.LayoutBranchServiceBaseImpl;

public class LayoutBranchServiceImpl
extends LayoutBranchServiceBaseImpl {
    public LayoutBranch addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)serviceContext.getScopeGroupId(), (String)"ADD_LAYOUT_BRANCH");
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutRevision.getLayoutSetBranchId());
        GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)layoutSetBranch.getGroupId(), (String)"ADD_LAYOUT_BRANCH");
        return this.layoutBranchLocalService.addLayoutBranch(layoutRevisionId, name, description, false, serviceContext);
    }

    public void deleteLayoutBranch(long layoutBranchId) throws PortalException {
        LayoutBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutBranchId, (String)"DELETE");
        this.layoutBranchLocalService.deleteLayoutBranch(layoutBranchId);
    }

    public LayoutBranch updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LayoutBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutBranchId, (String)"UPDATE");
        return this.layoutBranchLocalService.updateLayoutBranch(layoutBranchId, name, description, serviceContext);
    }
}

