/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.LayoutBranchNameException;
import com.liferay.portal.kernel.exception.NoSuchLayoutBranchException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.LayoutBranch;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.LayoutBranchLocalServiceBaseImpl;
import java.io.Serializable;
import java.util.List;

public class LayoutBranchLocalServiceImpl
extends LayoutBranchLocalServiceBaseImpl {
    public LayoutBranch addLayoutBranch(long layoutSetBranchId, long plid, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        LayoutSetBranch layoutSetBranch = this.layoutSetBranchPersistence.findByPrimaryKey(layoutSetBranchId);
        this.validate(0L, layoutSetBranchId, plid, name);
        long layoutBranchId = this.counterLocalService.increment();
        LayoutBranch layoutBranch = this.layoutBranchPersistence.create(layoutBranchId);
        layoutBranch.setGroupId(layoutSetBranch.getGroupId());
        layoutBranch.setCompanyId(user.getCompanyId());
        layoutBranch.setUserId(user.getUserId());
        layoutBranch.setUserName(user.getFullName());
        layoutBranch.setLayoutSetBranchId(layoutSetBranchId);
        layoutBranch.setPlid(plid);
        layoutBranch.setName(name);
        layoutBranch.setDescription(description);
        layoutBranch.setMaster(master);
        this.layoutBranchPersistence.update((BaseModel)layoutBranch);
        this.resourceLocalService.addResources(layoutBranch.getCompanyId(), layoutBranch.getGroupId(), layoutBranch.getUserId(), LayoutBranch.class.getName(), layoutBranch.getLayoutBranchId(), false, true, false);
        StagingUtil.setRecentLayoutBranchId((User)user, (long)layoutBranch.getLayoutSetBranchId(), (long)layoutBranch.getPlid(), (long)layoutBranch.getLayoutBranchId());
        return layoutBranch;
    }

    public LayoutBranch addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException {
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.findByPrimaryKey(layoutRevisionId);
        LayoutBranch layoutBranch = this.addLayoutBranch(layoutRevision.getLayoutSetBranchId(), layoutRevision.getPlid(), name, description, master, serviceContext);
        serviceContext.setAttribute("major", (Serializable)((Object)Boolean.TRUE.toString()));
        this.layoutRevisionLocalService.addLayoutRevision(layoutBranch.getUserId(), layoutRevision.getLayoutSetBranchId(), layoutBranch.getLayoutBranchId(), 0L, true, layoutRevision.getPlid(), layoutRevision.getLayoutRevisionId(), layoutRevision.isPrivateLayout(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        return layoutBranch;
    }

    @Override
    public LayoutBranch deleteLayoutBranch(long layoutBranchId) throws PortalException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.findByPrimaryKey(layoutBranchId);
        this.layoutRevisionLocalService.deleteLayoutRevisions(layoutBranch.getLayoutSetBranchId(), layoutBranchId, layoutBranch.getPlid());
        this.recentLayoutBranchLocalService.deleteRecentLayoutBranches(layoutBranch.getLayoutBranchId());
        return this.deleteLayoutBranch(layoutBranch);
    }

    public void deleteLayoutSetBranchLayoutBranches(long layoutSetBranchId) throws PortalException {
        List layoutBranches = this.layoutBranchPersistence.findByLayoutSetBranchId(layoutSetBranchId);
        for (LayoutBranch layoutBranch : layoutBranches) {
            this.deleteLayoutBranch(layoutBranch.getLayoutBranchId());
        }
    }

    public List<LayoutBranch> getLayoutBranches(long layoutSetBranchId, long plid, int start, int end, OrderByComparator<LayoutBranch> orderByComparator) {
        return this.layoutBranchPersistence.findByL_P(layoutSetBranchId, plid, start, end, orderByComparator);
    }

    public List<LayoutBranch> getLayoutSetBranchLayoutBranches(long layoutSetBranchId) {
        return this.layoutBranchPersistence.findByLayoutSetBranchId(layoutSetBranchId);
    }

    public LayoutBranch getMasterLayoutBranch(long layoutSetBranchId, long plid) throws PortalException {
        return this.layoutBranchPersistence.findByL_P_M_First(layoutSetBranchId, plid, true, null);
    }

    public LayoutBranch getMasterLayoutBranch(long layoutSetBranchId, long plid, ServiceContext serviceContext) throws PortalException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.fetchByL_P_M_First(layoutSetBranchId, plid, true, null);
        if (layoutBranch != null) {
            return layoutBranch;
        }
        return this.layoutBranchLocalService.addLayoutBranch(layoutSetBranchId, plid, "main-variation", "", true, serviceContext);
    }

    public LayoutBranch updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LayoutBranch layoutBranch = this.layoutBranchPersistence.findByPrimaryKey(layoutBranchId);
        this.validate(layoutBranch.getLayoutBranchId(), layoutBranch.getLayoutSetBranchId(), layoutBranch.getPlid(), name);
        layoutBranch.setName(name);
        layoutBranch.setDescription(description);
        this.layoutBranchPersistence.update((BaseModel)layoutBranch);
        return layoutBranch;
    }

    protected void validate(long layoutBranchId, long layoutSetBranchId, long plid, String name) throws PortalException {
        if (Validator.isNull((String)name) || name.length() < 4) {
            throw new LayoutBranchNameException(3);
        }
        if (name.length() > 100) {
            throw new LayoutBranchNameException(2);
        }
        try {
            LayoutBranch layoutBranch = this.layoutBranchPersistence.findByL_P_N(layoutSetBranchId, plid, name);
            if (layoutBranch.getLayoutBranchId() != layoutBranchId) {
                throw new LayoutBranchNameException(1);
            }
        }
        catch (NoSuchLayoutBranchException nslbe) {
            // empty catch block
        }
    }
}

