/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.image.HookFactory;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import com.liferay.portal.service.base.ImageLocalServiceBaseImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;

public class ImageLocalServiceImpl
extends ImageLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ImageLocalServiceImpl.class);

    @Override
    public Image deleteImage(long imageId) throws PortalException {
        Image image;
        block4: {
            if (imageId <= 0L) {
                return null;
            }
            image = this.getImage(imageId);
            if (image != null) {
                this.imagePersistence.remove((BaseModel)image);
                Hook hook = HookFactory.getInstance();
                try {
                    hook.deleteImage(image);
                }
                catch (NoSuchImageException nsie) {
                    if (!_log.isWarnEnabled()) break block4;
                    _log.warn((Object)nsie, (Throwable)nsie);
                }
            }
        }
        return image;
    }

    public Image getCompanyLogo(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = ImageToolUtil.getDefaultCompanyLogo();
        }
        return image;
    }

    @Override
    public Image getImage(long imageId) {
        block3: {
            if (imageId > 0L) {
                try {
                    return this.imagePersistence.fetchByPrimaryKey(imageId);
                }
                catch (Exception e2) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to get image " + imageId + ": " + e2.getMessage()));
                }
            }
        }
        return null;
    }

    public Image getImageOrDefault(long imageId) {
        Image image = this.getImage(imageId);
        if (image == null) {
            image = ImageToolUtil.getDefaultSpacer();
        }
        return image;
    }

    public List<Image> getImages() {
        return this.imagePersistence.findAll();
    }

    public List<Image> getImagesBySize(int size) {
        return this.imagePersistence.findByLtSize(size);
    }

    public Image moveImage(long imageId, byte[] bytes) throws PortalException {
        Image image = this.updateImage(this.counterLocalService.increment(), bytes);
        if (imageId > 0L) {
            this.deleteImage(imageId);
        }
        return image;
    }

    public Image updateImage(long imageId, byte[] bytes) throws PortalException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((byte[])bytes);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, byte[] bytes, String type, int height, int width, int size) throws PortalException {
        this.validate(type);
        Image image = this.imagePersistence.fetchByPrimaryKey(imageId);
        if (image == null) {
            image = this.imagePersistence.create(imageId);
        }
        image.setModifiedDate(new Date());
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        Hook hook = HookFactory.getInstance();
        hook.updateImage(image, type, bytes);
        this.imagePersistence.update((BaseModel)image);
        WebServerServletTokenUtil.resetToken((long)imageId);
        return image;
    }

    public Image updateImage(long imageId, File file) throws PortalException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((File)file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is) throws PortalException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((InputStream)is);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    public Image updateImage(long imageId, InputStream is, boolean cleanUpStream) throws PortalException {
        Image image = null;
        try {
            image = ImageToolUtil.getImage((InputStream)is, (boolean)cleanUpStream);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateImage(imageId, image.getTextObj(), image.getType(), image.getHeight(), image.getWidth(), image.getSize());
    }

    protected void validate(String type) throws PortalException {
        if (type == null || type.contains("\\") || type.contains(":") || type.contains(">") || type.contains("<") || type.contains("%") || type.contains(".") || type.contains("|") || type.contains("?") || type.contains("\"") || type.contains("/") || type.contains(" ") || type.contains("*")) {
            throw new ImageTypeException();
        }
    }
}

