/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TeamServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.LinkedHashMap;
import java.util.List;

@ProviderType
public class TeamServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(TeamServiceHttp.class);
    private static final Class<?>[] _addTeamParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _addTeamParameterTypes1 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteTeamParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getGroupTeamsParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getTeamParameterTypes5 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getUserTeamsParameterTypes6 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getUserTeamsParameterTypes7 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _hasUserTeamParameterTypes8 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _searchParameterTypes9 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _searchCountParameterTypes10 = new Class[]{Long.TYPE, String.class, String.class, LinkedHashMap.class};
    private static final Class<?>[] _updateTeamParameterTypes11 = new Class[]{Long.TYPE, String.class, String.class};

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "addTeam", (Class[])_addTeamParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team addTeam(HttpPrincipal httpPrincipal, long groupId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "addTeam", (Class[])_addTeamParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static void deleteTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "deleteTeam", (Class[])_deleteTeamParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getGroupTeams(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getGroupTeams", (Class[])_getGroupTeamsParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team getTeam(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getTeam", (Class[])_getTeamParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> getUserTeams(HttpPrincipal httpPrincipal, long userId, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "getUserTeams", (Class[])_getUserTeamsParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static boolean hasUserTeam(HttpPrincipal httpPrincipal, long userId, long teamId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "hasUserTeam", (Class[])_hasUserTeamParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{userId, teamId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Boolean)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Team> search(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params, int start, int end, OrderByComparator<Team> obc) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "search", (Class[])_searchParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, params, start, end, obc});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int searchCount(HttpPrincipal httpPrincipal, long groupId, String name, String description, LinkedHashMap<String, Object> params) {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "searchCount", (Class[])_searchCountParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name, description, params});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static Team updateTeam(HttpPrincipal httpPrincipal, long teamId, String name, String description) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(TeamServiceUtil.class, "updateTeam", (Class[])_updateTeamParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{teamId, name, description});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Team)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

