/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ContactServiceUtil;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;

@ProviderType
public class ContactServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(ContactServiceHttp.class);
    private static final Class<?>[] _getContactParameterTypes0 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getContactsParameterTypes1 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getContactsCountParameterTypes2 = new Class[]{Long.TYPE, Long.TYPE};

    public static Contact getContact(HttpPrincipal httpPrincipal, long contactId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContact", (Class[])_getContactParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{contactId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Contact)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static List<Contact> getContacts(HttpPrincipal httpPrincipal, long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContacts", (Class[])_getContactsParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, classPK, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (List)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }

    public static int getContactsCount(HttpPrincipal httpPrincipal, long classNameId, long classPK) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(ContactServiceUtil.class, "getContactsCount", (Class[])_getContactsCountParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{classNameId, classPK});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception e2) {
                if (e2 instanceof PortalException) {
                    throw (PortalException)((Object)e2);
                }
                throw new SystemException((Throwable)e2);
            }
            return (Integer)returnObj;
        }
        catch (SystemException se) {
            _log.error((Object)se, (Throwable)se);
            throw se;
        }
    }
}

