/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.permission;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.admin.util.OmniadminUtil;
import java.util.Collections;
import java.util.List;

public abstract class BasePermissionChecker
implements PermissionChecker {
    protected boolean checkGuest = PropsValues.PERMISSIONS_CHECK_GUEST_ENABLED;
    protected long defaultUserId;
    protected Boolean omniadmin;
    protected Role ownerRole;
    protected boolean signedIn;
    protected User user;
    private static final Log _log = LogFactoryUtil.getLog(BasePermissionChecker.class);

    public abstract PermissionChecker clone();

    public long getCompanyId() {
        return this.user.getCompanyId();
    }

    public List<Long> getOwnerResourceBlockIds(long companyId, long groupId, String name, String actionId) {
        return Collections.emptyList();
    }

    public long getOwnerRoleId() {
        return this.ownerRole.getRoleId();
    }

    public List<Long> getResourceBlockIds(long companyId, long groupId, long userId, String name, String actionId) {
        return Collections.emptyList();
    }

    public long[] getRoleIds(long userId, long groupId) {
        return PermissionChecker.DEFAULT_ROLE_IDS;
    }

    public User getUser() {
        return this.user;
    }

    public long getUserId() {
        return this.user.getUserId();
    }

    public boolean hasOwnerPermission(long companyId, String name, long primKey, long ownerId, String actionId) {
        return this.hasOwnerPermission(companyId, name, String.valueOf(primKey), ownerId, actionId);
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this.hasPermission(groupId, name, String.valueOf(primKey), actionId);
    }

    public void init(User user) {
        this.user = user;
        if (user.isDefaultUser()) {
            this.defaultUserId = user.getUserId();
            this.signedIn = false;
        } else {
            try {
                this.defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)user.getCompanyId());
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            this.signedIn = true;
        }
        try {
            this.ownerRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"Owner");
        }
        catch (Exception e3) {
            _log.error((Object)e3, (Throwable)e3);
        }
    }

    public boolean isCheckGuest() {
        return this.checkGuest;
    }

    public boolean isOmniadmin() {
        if (this.omniadmin == null) {
            this.omniadmin = OmniadminUtil.isOmniadmin(this.getUser());
        }
        return this.omniadmin;
    }

    public boolean isSignedIn() {
        return this.signedIn;
    }
}

