/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.lang;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.AggregateClassLoader;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.security.lang.DoPrivilegedBean;
import com.liferay.portal.security.lang.DoPrivilegedHandler;
import com.liferay.portal.security.lang.SecurityManagerUtil;
import java.lang.reflect.InvocationHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DoPrivilegedFactory
extends InstantiationAwareBeanPostProcessorAdapter
implements ApplicationContextAware {
    private static final String _BEAN_NAME_SUFFIX_FINDER = "Finder";
    private static final String _BEAN_NAME_SUFFIX_PERSISTENCE = "Persistence";
    private static final Log _log = LogFactoryUtil.getLog(DoPrivilegedFactory.class);
    private static ClassLoader _classLoader = DoPrivilegedFactory.class.getClassLoader();
    private static final Set<String> _earlyBeanReferenceNames = new HashSet<String>();

    public static boolean isEarlyBeanReference(String beanName) {
        return _earlyBeanReferenceNames.contains(beanName);
    }

    public static <T> T wrap(T bean) {
        String packageName;
        Class<?> clazz = bean.getClass();
        if (clazz.isPrimitive()) {
            return bean;
        }
        Package pkg = clazz.getPackage();
        if (pkg != null && (packageName = pkg.getName()).startsWith("java.")) {
            return bean;
        }
        Class[] interfaces = ReflectionUtil.getInterfaces(bean);
        if (interfaces.length <= 0) {
            return bean;
        }
        return AccessController.doPrivileged(new BeanPrivilegedAction<T>(bean, interfaces));
    }

    public Object getEarlyBeanReference(Object bean, String beanName) throws BeansException {
        if (this._isWrap(bean, beanName)) {
            _earlyBeanReferenceNames.add(beanName);
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!SecurityManagerUtil.ENABLED) {
            return bean;
        }
        if (!this._isWrap(bean, beanName)) {
            return bean;
        }
        if (DoPrivilegedFactory.isEarlyBeanReference(beanName)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Postpone wrapping early reference of " + beanName));
            }
            return bean;
        }
        if (_log.isDebugEnabled()) {
            Class<?> clazz = bean.getClass();
            _log.debug((Object)("Wrapping calls to bean " + beanName + " of type " + clazz + " with access controller checking"));
        }
        return DoPrivilegedFactory.wrap(bean);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        _classLoader = AggregateClassLoader.getAggregateClassLoader((ClassLoader)PortalClassLoaderUtil.getClassLoader(), (ClassLoader[])new ClassLoader[]{applicationContext.getClassLoader()});
    }

    private boolean _isDoPrivileged(Class<?> beanClass) {
        DoPrivileged doPrivileged = beanClass.getAnnotation(DoPrivileged.class);
        while (doPrivileged == null && (beanClass = beanClass.getSuperclass()) != null) {
            doPrivileged = beanClass.getAnnotation(DoPrivileged.class);
        }
        return doPrivileged != null;
    }

    private boolean _isFinderOrPersistence(String beanName) {
        return beanName.endsWith(_BEAN_NAME_SUFFIX_FINDER) || beanName.endsWith(_BEAN_NAME_SUFFIX_PERSISTENCE);
    }

    private boolean _isWrap(Object bean, String beanName) {
        Class<?> clazz = bean.getClass();
        return this._isDoPrivileged(clazz) || this._isFinderOrPersistence(beanName);
    }

    private static class BeanPrivilegedAction<T>
    implements PrivilegedAction<T> {
        private final T _bean;
        private final Class<?>[] _interfaces;

        public BeanPrivilegedAction(T bean, Class<?>[] interfaces) {
            this._bean = bean;
            this._interfaces = (Class[])ArrayUtil.append((Object[])interfaces, DoPrivilegedBean.class);
        }

        @Override
        public T run() {
            try {
                return (T)ProxyUtil.newProxyInstance((ClassLoader)_classLoader, (Class[])this._interfaces, (InvocationHandler)new DoPrivilegedHandler(this._bean));
            }
            catch (Exception e2) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)e2, (Throwable)e2);
                }
                return this._bean;
            }
        }
    }
}

