/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.jaas;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class PortalLoginModule
implements LoginModule {
    private static final Log _log = LogFactoryUtil.getLog(PortalLoginModule.class);
    private final LoginModule _loginModule;

    public PortalLoginModule() {
        LoginModule loginModule = null;
        if (Validator.isNotNull((String)PropsValues.PORTAL_JAAS_IMPL)) {
            try {
                loginModule = (LoginModule)InstanceFactory.newInstance((String)PropsValues.PORTAL_JAAS_IMPL);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        if (loginModule == null) {
            if (ServerDetector.isJBoss()) {
                loginModule = new com.liferay.portal.security.jaas.ext.jboss.PortalLoginModule();
            } else if (ServerDetector.isJetty()) {
                loginModule = new com.liferay.portal.security.jaas.ext.jetty.PortalLoginModule();
            } else if (ServerDetector.isJOnAS()) {
                loginModule = new com.liferay.portal.security.jaas.ext.jonas.PortalLoginModule();
            } else if (ServerDetector.isResin()) {
                loginModule = new com.liferay.portal.security.jaas.ext.resin.PortalLoginModule();
            } else if (ServerDetector.isTomcat()) {
                loginModule = new com.liferay.portal.security.jaas.ext.tomcat.PortalLoginModule();
            } else if (ServerDetector.isWebLogic()) {
                loginModule = new com.liferay.portal.security.jaas.ext.weblogic.PortalLoginModule();
            }
        }
        if (_log.isDebugEnabled()) {
            Class<?> clazz = loginModule.getClass();
            _log.debug((Object)clazz.getName());
        }
        this._loginModule = loginModule;
    }

    @Override
    public boolean abort() throws LoginException {
        return this._loginModule.abort();
    }

    @Override
    public boolean commit() throws LoginException {
        return this._loginModule.commit();
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this._loginModule.initialize(subject, callbackHandler, sharedState, options);
    }

    @Override
    public boolean login() throws LoginException {
        return this._loginModule.login();
    }

    @Override
    public boolean logout() throws LoginException {
        return this._loginModule.logout();
    }
}

