/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.search.BaseOpenSearchImpl;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.Date;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class PortalOpenSearchImpl
extends BaseOpenSearchImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortalOpenSearchImpl.class);

    public PortalOpenSearchImpl(String openSearchURL, String openSearchDescriptionURL) {
        super(openSearchURL, openSearchDescriptionURL);
    }

    public String search(HttpServletRequest request, long groupId, long userId, String keywords, int startPage, int itemsPerPage, String format) throws SearchException {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            int start = startPage * itemsPerPage - itemsPerPage;
            int end = startPage * itemsPerPage;
            Hits results = CompanyLocalServiceUtil.search((long)themeDisplay.getCompanyId(), (long)userId, (String)keywords, (int)start, (int)end);
            String[] queryTerms = results.getQueryTerms();
            int total = results.getLength();
            Object[] values = this.addSearchResults(queryTerms, keywords, startPage, itemsPerPage, total, start, "Liferay Portal Search: " + keywords, "", format, themeDisplay);
            com.liferay.portal.kernel.xml.Document doc = (com.liferay.portal.kernel.xml.Document)values[0];
            Element root = (Element)values[1];
            for (int i = 0; i < results.getDocs().length; ++i) {
                Document result = results.doc(i);
                String className = result.get("entryClassName");
                String portletId = PortletProviderUtil.getPortletId((String)className, (PortletProvider.Action)PortletProvider.Action.VIEW);
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)themeDisplay.getCompanyId(), (String)portletId);
                if (portlet == null) continue;
                String portletTitle = PortalUtil.getPortletTitle((String)portletId, (User)themeDisplay.getUser());
                long resultGroupId = GetterUtil.getLong((String)result.get("groupId"));
                long resultScopeGroupId = GetterUtil.getLong((String)result.get("scopeGroupId"));
                if (resultScopeGroupId == 0L) {
                    resultScopeGroupId = themeDisplay.getScopeGroupId();
                }
                String entryClassName = GetterUtil.getString((String)result.get("entryClassName"));
                long entryClassPK = GetterUtil.getLong((String)result.get("entryClassPK"));
                String title = "";
                PortletURL portletURL = this.getPortletURL(request, portletId, resultScopeGroupId);
                String url = portletURL.toString();
                Date modifiedDate = result.getDate("modified");
                String content = "";
                Indexer indexer = IndexerRegistryUtil.getIndexer((String)entryClassName);
                if (indexer != null) {
                    String snippet = result.get("snippet");
                    Summary summary = indexer.getSummary(result, snippet, null, null);
                    if (summary == null) continue;
                    title = summary.getTitle();
                    url = portletURL.toString();
                    content = summary.getContent();
                }
                double score = results.score(i);
                this.addSearchResult(root, resultGroupId, resultScopeGroupId, entryClassName, entryClassPK, portletTitle + " " + '\u00bb' + " " + title, url, modifiedDate, content, score, format);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Return\n" + doc.asXML()));
            }
            return doc.asXML();
        }
        catch (Exception e2) {
            throw new SearchException((Throwable)e2);
        }
    }
}

