/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.service;

import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ServiceMethodProcessCallable
implements Externalizable,
ProcessCallable<Serializable> {
    private MethodHandler _methodHandler;
    private long _userId;

    public ServiceMethodProcessCallable() {
    }

    public ServiceMethodProcessCallable(MethodHandler methodHandler) {
        this._methodHandler = methodHandler;
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker != null) {
            this._userId = permissionChecker.getUserId();
        }
    }

    public Serializable call() throws ProcessException {
        String oldName = PrincipalThreadLocal.getName();
        PermissionChecker oldPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        try {
            Serializable user;
            if (this._userId != 0L) {
                PrincipalThreadLocal.setName((long)this._userId);
                user = UserLocalServiceUtil.fetchUser((long)this._userId);
                if (user != null) {
                    PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                    PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                }
            }
            user = (Serializable)this._methodHandler.invoke();
            return user;
        }
        catch (Exception e2) {
            throw new ProcessException((Throwable)e2);
        }
        finally {
            PrincipalThreadLocal.setName((String)oldName);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)oldPermissionChecker);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        this._methodHandler = (MethodHandler)objectInput.readObject();
        this._userId = objectInput.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this._methodHandler);
        objectOutput.writeLong(this._userId);
    }
}

