/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository.model;

import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayModel;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class LiferayFileVersion
extends LiferayModel
implements FileVersion {
    private static final Log _log = LogFactoryUtil.getLog(LiferayFileVersion.class);
    private final DLFileVersion _dlFileVersion;
    private final boolean _escapedModel;

    public LiferayFileVersion(DLFileVersion dlFileVersion) {
        this(dlFileVersion, dlFileVersion.isEscapedModel());
    }

    public LiferayFileVersion(DLFileVersion dlFileVersion, boolean escapedModel) {
        this._dlFileVersion = dlFileVersion;
        this._escapedModel = escapedModel;
    }

    public Object clone() {
        return new LiferayFileVersion(this._dlFileVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiferayFileVersion)) {
            return false;
        }
        LiferayFileVersion liferayFileVersion = (LiferayFileVersion)obj;
        return Objects.equals(this._dlFileVersion, liferayFileVersion._dlFileVersion);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((FileVersion)this);
    }

    public Map<String, Serializable> getAttributes() {
        ExpandoBridge expandoBridge = this._dlFileVersion.getExpandoBridge();
        return expandoBridge.getAttributes();
    }

    public String getChangeLog() {
        return this._dlFileVersion.getChangeLog();
    }

    @Override
    public long getCompanyId() {
        return this._dlFileVersion.getCompanyId();
    }

    public InputStream getContentStream(boolean incrementCounter) throws PortalException {
        InputStream inputStream = this._dlFileVersion.getContentStream(incrementCounter);
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this.getFileEntry(), (boolean)incrementCounter);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return inputStream;
    }

    public Date getCreateDate() {
        return this._dlFileVersion.getCreateDate();
    }

    public String getDescription() {
        return this._dlFileVersion.getDescription();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._dlFileVersion.getExpandoBridge();
    }

    public String getExtension() {
        return this._dlFileVersion.getExtension();
    }

    public String getExtraSettings() {
        return this._dlFileVersion.getExtraSettings();
    }

    public File getFile(boolean incrementCounter) throws PortalException {
        return DLFileEntryLocalServiceUtil.getFile((long)this._dlFileVersion.getFileEntryId(), (String)this._dlFileVersion.getVersion(), (boolean)incrementCounter);
    }

    public FileEntry getFileEntry() throws PortalException {
        return new LiferayFileEntry(this._dlFileVersion.getFileEntry());
    }

    public long getFileEntryId() {
        return this._dlFileVersion.getFileEntryId();
    }

    public String getFileName() {
        return this._dlFileVersion.getFileName();
    }

    public long getFileVersionId() {
        return this._dlFileVersion.getFileVersionId();
    }

    public long getGroupId() {
        return this._dlFileVersion.getGroupId();
    }

    public String getIcon() {
        return this._dlFileVersion.getIcon();
    }

    public Date getLastPublishDate() {
        return this._dlFileVersion.getLastPublishDate();
    }

    public String getMimeType() {
        return this._dlFileVersion.getMimeType();
    }

    public Object getModel() {
        return this._dlFileVersion;
    }

    public Class<?> getModelClass() {
        return LiferayFileVersion.class;
    }

    @Override
    public String getModelClassName() {
        return LiferayFileVersion.class.getName();
    }

    public Date getModifiedDate() {
        return this._dlFileVersion.getModifiedDate();
    }

    @Override
    public long getPrimaryKey() {
        return this._dlFileVersion.getPrimaryKey();
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._dlFileVersion.getRepositoryId();
    }

    public long getSize() {
        return this._dlFileVersion.getSize();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(FileVersion.class);
    }

    public int getStatus() {
        return this._dlFileVersion.getStatus();
    }

    public long getStatusByUserId() {
        return this._dlFileVersion.getStatusByUserId();
    }

    public String getStatusByUserName() {
        return this._dlFileVersion.getStatusByUserName();
    }

    public String getStatusByUserUuid() {
        return this._dlFileVersion.getStatusByUserUuid();
    }

    public Date getStatusDate() {
        return this._dlFileVersion.getStatusDate();
    }

    public String getTitle() {
        return this._dlFileVersion.getTitle();
    }

    public long getUserId() {
        return this._dlFileVersion.getUserId();
    }

    public String getUserName() {
        return this._dlFileVersion.getUserName();
    }

    public String getUserUuid() {
        return this._dlFileVersion.getUserUuid();
    }

    public String getUuid() {
        return this._dlFileVersion.getUuid();
    }

    public String getVersion() {
        return this._dlFileVersion.getVersion();
    }

    public int hashCode() {
        return this._dlFileVersion.hashCode();
    }

    public boolean isApproved() {
        return this._dlFileVersion.isApproved();
    }

    public boolean isDefaultRepository() {
        return this._dlFileVersion.getGroupId() == this._dlFileVersion.getRepositoryId();
    }

    public boolean isDraft() {
        return this._dlFileVersion.isDraft();
    }

    public boolean isEscapedModel() {
        return this._escapedModel;
    }

    public boolean isExpired() {
        return this._dlFileVersion.isExpired();
    }

    public boolean isPending() {
        return this._dlFileVersion.isPending();
    }

    public void setCompanyId(long companyId) {
        this._dlFileVersion.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
        this._dlFileVersion.setCreateDate(createDate);
    }

    public void setGroupId(long groupId) {
        this._dlFileVersion.setGroupId(groupId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
        this._dlFileVersion.setLastPublishDate(lastPublishDate);
    }

    public void setModifiedDate(Date modifiedDate) {
    }

    public void setPrimaryKey(long primaryKey) {
        this._dlFileVersion.setPrimaryKey(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public void setUserId(long userId) {
        this._dlFileVersion.setUserId(userId);
    }

    public void setUserName(String userName) {
        this._dlFileVersion.setUserName(userName);
    }

    public void setUserUuid(String userUuid) {
        this._dlFileVersion.setUserUuid(userUuid);
    }

    public void setUuid(String uuid) {
        this._dlFileVersion.setUuid(uuid);
    }

    public FileVersion toEscapedModel() {
        if (this.isEscapedModel()) {
            return this;
        }
        return new LiferayFileVersion(this._dlFileVersion.toEscapedModel(), true);
    }

    public String toString() {
        return this._dlFileVersion.toString();
    }

    public FileVersion toUnescapedModel() {
        if (this.isEscapedModel()) {
            return new LiferayFileVersion(this._dlFileVersion.toUnescapedModel(), true);
        }
        return this;
    }
}

