/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalServiceUtil;
import com.liferay.portal.kernel.service.RepositoryService;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;

public class RepositoryServiceAdapter {
    private final RepositoryLocalService _repositoryLocalService;
    private final RepositoryService _repositoryService;

    public static RepositoryServiceAdapter create(DocumentRepository documentRepository) {
        if (documentRepository instanceof LocalRepository) {
            return new RepositoryServiceAdapter(RepositoryLocalServiceUtil.getService());
        }
        return new RepositoryServiceAdapter(RepositoryLocalServiceUtil.getService(), RepositoryServiceUtil.getService());
    }

    public RepositoryServiceAdapter(RepositoryLocalService repositoryLocalService) {
        this(repositoryLocalService, null);
    }

    public RepositoryServiceAdapter(RepositoryLocalService repositoryLocalService, RepositoryService repositoryService) {
        this._repositoryLocalService = repositoryLocalService;
        this._repositoryService = repositoryService;
    }

    public Repository fetchRepository(long repositoryId) throws PortalException {
        Repository repository = null;
        if (this._repositoryService != null) {
            repository = this._repositoryLocalService.fetchRepository(repositoryId);
            if (repository != null) {
                repository = this._repositoryService.getRepository(repositoryId);
            }
        } else {
            repository = this._repositoryLocalService.fetchRepository(repositoryId);
        }
        return repository;
    }

    public Repository getRepository(long repositoryId) throws PortalException {
        Repository repository = null;
        repository = this._repositoryService != null ? this._repositoryService.getRepository(repositoryId) : this._repositoryLocalService.getRepository(repositoryId);
        return repository;
    }

    public Repository updateRepository(Repository repository) throws PrincipalException {
        if (this._repositoryService != null) {
            throw new PrincipalException("Repository service is not null");
        }
        return this._repositoryLocalService.updateRepository(repository);
    }
}

