/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesScope;
import com.liferay.portal.kernel.repository.model.BaseRepositoryModelOperation;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TemporaryFileEntriesCapabilityImpl
implements TemporaryFileEntriesCapability {
    private static final String _FOLDER_NAME_TEMP = "temp";
    private static final String _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT = "temporaryFilesTimeout";
    private static final long _TEMPORARY_FILE_ENTRIES_TIMEOUT_DEFAULT = 43200000L;
    private final DocumentRepository _documentRepository;

    public TemporaryFileEntriesCapabilityImpl(DocumentRepository documentRepository) {
        this._documentRepository = documentRepository;
    }

    public FileEntry addTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName, String mimeType, InputStream inputStream) throws PortalException {
        FileEntry fileEntry;
        Folder folder = this.addTempFolder(temporaryFileEntriesScope);
        File file = null;
        try {
            if (inputStream == null) {
                inputStream = new UnsyncByteArrayInputStream(new byte[0]);
            }
            file = FileUtil.createTempFile((InputStream)inputStream);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            fileEntry = this._documentRepository.addFileEntry(temporaryFileEntriesScope.getUserId(), folder.getFolderId(), fileName, mimeType, fileName, "", "", file, serviceContext);
        }
        catch (IOException ioe) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public void deleteExpiredTemporaryFileEntries() throws PortalException {
        BulkOperationCapability bulkOperationCapability = (BulkOperationCapability)this._documentRepository.getCapability(BulkOperationCapability.class);
        BulkOperationCapability.Filter bulkFilter = new BulkOperationCapability.Filter(BulkOperationCapability.Field.CreateDate.class, BulkOperationCapability.Operator.LT, (Object)new Date(System.currentTimeMillis() - this.getTemporaryFileEntriesTimeout()));
        bulkOperationCapability.execute(bulkFilter, (RepositoryModelOperation)new DeleteExpiredTemporaryFilesRepositoryModelOperation());
    }

    public void deleteTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName) throws PortalException {
        try {
            FileEntry fileEntry = this.getTemporaryFileEntry(temporaryFileEntriesScope, fileName);
            this._documentRepository.deleteFileEntry(fileEntry.getFileEntryId());
        }
        catch (NoSuchModelException noSuchModelException) {
            // empty catch block
        }
    }

    public List<FileEntry> getTemporaryFileEntries(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        try {
            Folder folder = this.addTempFolder(temporaryFileEntriesScope);
            return this._documentRepository.getRepositoryFileEntries(temporaryFileEntriesScope.getUserId(), folder.getFolderId(), -1, -1, null);
        }
        catch (NoSuchModelException nsme) {
            return Collections.emptyList();
        }
    }

    public long getTemporaryFileEntriesTimeout() {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._documentRepository.getCapability(ConfigurationCapability.class);
        String temporaryFileEntriesTimeout = configurationCapability.getProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT);
        if (temporaryFileEntriesTimeout == null) {
            return 43200000L;
        }
        return GetterUtil.getLong((String)temporaryFileEntriesTimeout);
    }

    public FileEntry getTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName) throws PortalException {
        Folder folder = this.getTempFolder(temporaryFileEntriesScope);
        return this._documentRepository.getFileEntry(folder.getFolderId(), fileName);
    }

    public void setTemporaryFileEntriesTimeout(long temporaryFileEntriesTimeout) {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._documentRepository.getCapability(ConfigurationCapability.class);
        configurationCapability.setProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT, String.valueOf(temporaryFileEntriesTimeout));
    }

    protected Folder addFolder(long userId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        try {
            return this._documentRepository.getFolder(parentFolderId, folderName);
        }
        catch (NoSuchFolderException nsfe) {
            return this._documentRepository.addFolder(userId, parentFolderId, folderName, "", serviceContext);
        }
    }

    protected Folder addFolders(long userId, long folderId, String folderPath, ServiceContext serviceContext) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this.addFolder(userId, folderId, folderName, serviceContext);
            folderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder addTempFolder(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this.addFolders(temporaryFileEntriesScope.getUserId(), 0L, this._getFolderPath(temporaryFileEntriesScope), serviceContext);
    }

    protected Folder getDeepestFolder(long parentFolderId, String folderPath) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this._documentRepository.getFolder(parentFolderId, folderName);
            parentFolderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder getTempFolder(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this.getDeepestFolder(0L, this._getFolderPath(temporaryFileEntriesScope));
    }

    private String _getFolderPath(TemporaryFileEntriesScope temporaryFileEntriesScope) {
        StringBundler sb = new StringBundler(7);
        sb.append(_FOLDER_NAME_TEMP);
        sb.append("/");
        sb.append((Object)temporaryFileEntriesScope.getCallerUuid());
        sb.append("/");
        sb.append(temporaryFileEntriesScope.getUserId());
        sb.append("/");
        sb.append(temporaryFileEntriesScope.getFolderPath());
        return sb.toString();
    }

    private class DeleteExpiredTemporaryFilesRepositoryModelOperation
    extends BaseRepositoryModelOperation {
        private DeleteExpiredTemporaryFilesRepositoryModelOperation() {
        }

        public void execute(FileEntry fileEntry) throws PortalException {
            Folder folder = fileEntry.getFolder();
            TemporaryFileEntriesCapabilityImpl.this._documentRepository.deleteFileEntry(fileEntry.getFileEntryId());
            Folder mountFolder = TemporaryFileEntriesCapabilityImpl.this._documentRepository.getFolder(0L);
            while (folder.getFolderId() != mountFolder.getFolderId() && TemporaryFileEntriesCapabilityImpl.this._documentRepository.getFileEntriesCount(folder.getFolderId(), -1) == 0) {
                long folderId = folder.getFolderId();
                folder = folder.getParentFolder();
                TemporaryFileEntriesCapabilityImpl.this._documentRepository.deleteFolder(folderId);
            }
        }
    }
}

