/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.poller;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.poller.PollerHeader;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.poller.PollerRequestHandlerUtil;
import com.liferay.portal.poller.SynchronousPollerChannelListener;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PollerServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(PollerServlet.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            String content = this.getContent(request);
            if (content == null) {
                PortalUtil.sendError((int)404, (Exception)new NoSuchLayoutException(), (HttpServletRequest)request, (HttpServletResponse)response);
            } else {
                response.setContentType("text/plain; charset=UTF-8");
                ServletResponseUtil.write((HttpServletResponse)response, (byte[])content.getBytes("UTF-8"));
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2.getMessage());
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getContent(HttpServletRequest request) throws Exception {
        long companyId = PortalUtil.getCompanyId((HttpServletRequest)request);
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        if (userId == 0L) {
            return "";
        }
        String pollerRequestString = ParamUtil.getString((HttpServletRequest)request, (String)"pollerRequest");
        PollerHeader pollerHeader = PollerRequestHandlerUtil.getPollerHeader(pollerRequestString);
        if (pollerHeader == null) {
            return "";
        }
        if (userId != pollerHeader.getUserId()) {
            return "";
        }
        SynchronousPollerChannelListener synchronousPollerChannelListener = new SynchronousPollerChannelListener();
        ChannelHubManagerUtil.getChannel((long)companyId, (long)userId, (boolean)true);
        ChannelHubManagerUtil.registerChannelListener((long)companyId, (long)userId, (ChannelListener)synchronousPollerChannelListener);
        try {
            JSONObject pollerResponseHeaderJSONObject = PollerRequestHandlerUtil.processRequest(request, pollerRequestString);
            if (pollerResponseHeaderJSONObject == null) {
                String string = "";
                return string;
            }
            String string = synchronousPollerChannelListener.getNotificationEvents(companyId, userId, pollerResponseHeaderJSONObject, PropsValues.POLLER_REQUEST_TIMEOUT);
            return string;
        }
        finally {
            ChannelHubManagerUtil.unregisterChannelListener((long)companyId, (long)userId, (ChannelListener)synchronousPollerChannelListener);
        }
    }
}

