/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.patcher;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.patcher.PatchInconsistencyException;
import com.liferay.portal.kernel.patcher.Patcher;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;

@DoPrivileged
public class PatcherImpl
implements Patcher {
    private static final Log _log = LogFactoryUtil.getLog(PatcherImpl.class);
    private boolean _configured;
    private String[] _fixedIssueKeys;
    private boolean _inconsistentPatchLevels;
    private String[] _installedPatchNames;
    private File _patchDirectory;
    private int _patchingToolVersion;
    private String _patchingToolVersionDisplayName;
    private String[] _patchLevels;
    private Properties _properties;

    public boolean applyPatch(File patchFile) {
        File patchDirectory = this.getPatchDirectory();
        if (patchDirectory == null) {
            return false;
        }
        try {
            FileUtil.copyFile((File)patchFile, (File)new File(patchDirectory + "/" + patchFile.getName()));
            return true;
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to copy " + patchFile.getAbsolutePath() + " to " + patchDirectory.getAbsolutePath()));
            return false;
        }
    }

    public String[] getFixedIssues() {
        if (this._fixedIssueKeys != null) {
            return this._fixedIssueKeys;
        }
        Properties properties = this.getProperties();
        this._fixedIssueKeys = StringUtil.split((String)properties.getProperty("fixed.issues"));
        return this._fixedIssueKeys;
    }

    public String[] getInstalledPatches() {
        if (this._installedPatchNames != null) {
            return this._installedPatchNames;
        }
        return this._getInstalledPatches(null);
    }

    public File getPatchDirectory() {
        if (this._patchDirectory != null) {
            return this._patchDirectory;
        }
        Properties properties = this.getProperties();
        String patchDirectoryName = properties.getProperty("patch.directory");
        if (Validator.isNotNull((String)patchDirectoryName)) {
            this._patchDirectory = new File(patchDirectoryName);
            if (!this._patchDirectory.exists()) {
                _log.error((Object)"The patch directory does not exist");
            }
        } else {
            _log.error((Object)"The patch directory is not specified");
        }
        return this._patchDirectory;
    }

    public int getPatchingToolVersion() {
        if (this._patchingToolVersion != 0) {
            return this._patchingToolVersion;
        }
        Properties properties = this.getProperties();
        if (properties.containsKey("patching.tool.version")) {
            this._patchingToolVersion = GetterUtil.getInteger((String)properties.getProperty("patching.tool.version"));
        }
        return this._patchingToolVersion;
    }

    public String getPatchingToolVersionDisplayName() {
        if (this._patchingToolVersionDisplayName != null) {
            return this._patchingToolVersionDisplayName;
        }
        Properties properties = this.getProperties();
        this._patchingToolVersionDisplayName = properties.containsKey("patching.tool.version.display.name") ? properties.getProperty("patching.tool.version.display.name") : "1.0." + this.getPatchingToolVersion();
        return this._patchingToolVersionDisplayName;
    }

    public String[] getPatchLevels() {
        if (this._patchLevels != null) {
            return this._patchLevels;
        }
        Properties properties = this.getProperties();
        this._patchLevels = StringUtil.split((String)properties.getProperty("patch.levels"));
        return this._patchLevels;
    }

    public Properties getProperties() {
        if (this._properties != null) {
            return this._properties;
        }
        return this._getProperties("patcher.properties");
    }

    public boolean hasInconsistentPatchLevels() {
        return this._inconsistentPatchLevels;
    }

    public boolean isConfigured() {
        return this._configured;
    }

    public void verifyPatchLevels() throws PatchInconsistencyException {
        Properties portalImplJARProperties = this._getProperties("patcher.properties");
        Object[] portalImplJARPatches = this._getInstalledPatches(portalImplJARProperties);
        Arrays.sort(portalImplJARPatches);
        Properties portalServiceJARProperties = this._getProperties("patcher-service.properties");
        Object[] serviceJARPatches = this._getInstalledPatches(portalServiceJARProperties);
        Arrays.sort(serviceJARPatches);
        if (!Arrays.equals(portalImplJARPatches, serviceJARPatches)) {
            _log.error((Object)"Inconsistent patch level detected");
            if (_log.isWarnEnabled()) {
                if (ArrayUtil.isEmpty((Object[])portalImplJARPatches)) {
                    _log.warn((Object)"There are no patches installed on portal-impl.jar");
                } else {
                    _log.warn((Object)("Patch level on portal-impl.jar: " + Arrays.toString(portalImplJARPatches)));
                }
                if (ArrayUtil.isEmpty((Object[])serviceJARPatches)) {
                    _log.warn((Object)"There are no patches installed on portal-kernel.jar");
                } else {
                    _log.warn((Object)("Patch level on portal-kernel.jar: " + Arrays.toString(serviceJARPatches)));
                }
            }
            this._inconsistentPatchLevels = true;
            throw new PatchInconsistencyException();
        }
    }

    private String[] _getInstalledPatches(Properties properties) {
        if (properties == null) {
            properties = this.getProperties();
        }
        this._installedPatchNames = StringUtil.split((String)properties.getProperty("installed.patches"));
        return this._installedPatchNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Properties _getProperties(String fileName) {
        Properties properties;
        block9: {
            ClassLoader classLoader;
            InputStream inputStream;
            if (Validator.isNull((String)fileName)) {
                fileName = "patcher.properties";
            }
            properties = new Properties();
            Class<?> clazz = this.getClass();
            if (Objects.equals(fileName, "patcher-service.properties")) {
                clazz = clazz.getInterfaces()[0];
            }
            if ((inputStream = (classLoader = clazz.getClassLoader()).getResourceAsStream(fileName)) == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to load " + fileName));
                }
            } else {
                properties.load(inputStream);
                this._configured = true;
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
            break block9;
            catch (IOException ioe) {
                try {
                    _log.error((Object)ioe, (Throwable)ioe);
                }
                catch (Throwable throwable) {
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    throw throwable;
                }
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            }
        }
        this._properties = properties;
        return this._properties;
    }
}

