/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.notifications;

import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.notifications.Channel;
import com.liferay.portal.kernel.notifications.ChannelException;
import com.liferay.portal.kernel.notifications.ChannelHub;
import com.liferay.portal.kernel.notifications.ChannelHubManager;
import com.liferay.portal.kernel.notifications.ChannelHubManagerUtil;
import com.liferay.portal.kernel.notifications.ChannelListener;
import com.liferay.portal.kernel.notifications.DuplicateChannelHubException;
import com.liferay.portal.kernel.notifications.NotificationEvent;
import com.liferay.portal.kernel.notifications.UnknownChannelHubException;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.notifications.ChannelHubImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@DoPrivileged
public class ChannelHubManagerImpl
implements ChannelHubManager {
    private static final Log _log = LogFactoryUtil.getLog(ChannelHubManagerImpl.class);
    private static final MethodKey _destroyChannelMethodKey = new MethodKey(ChannelHubManagerUtil.class, "destroyChannel", new Class[]{Long.TYPE, Long.TYPE});
    private static final MethodKey _storeNotificationEventMethodKey = new MethodKey(ChannelHubManagerUtil.class, "storeNotificationEvent", new Class[]{Long.TYPE, Long.TYPE, NotificationEvent.class});
    private final ConcurrentMap<Long, ChannelHub> _channelHubs = new ConcurrentHashMap<Long, ChannelHub>();

    public void confirmDelivery(long companyId, long userId, Collection<String> notificationEventUuids) throws ChannelException {
        this.confirmDelivery(companyId, userId, notificationEventUuids, false);
    }

    public void confirmDelivery(long companyId, long userId, Collection<String> notificationEventUuids, boolean archive) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.confirmDelivery(userId, notificationEventUuids, archive);
    }

    public void confirmDelivery(long companyId, long userId, String notificationEventUuid) throws ChannelException {
        this.confirmDelivery(companyId, userId, notificationEventUuid, false);
    }

    public void confirmDelivery(long companyId, long userId, String notificationEventUuid, boolean archive) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.confirmDelivery(userId, notificationEventUuid, archive);
    }

    public Channel createChannel(long companyId, long userId) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        return channelHub.createChannel(userId);
    }

    public ChannelHub createChannelHub(long companyId) throws ChannelException {
        ChannelHubImpl channelHub = new ChannelHubImpl(companyId);
        if (this._channelHubs.putIfAbsent(companyId, channelHub) != null) {
            throw new DuplicateChannelHubException("Channel already exists with company id " + companyId);
        }
        return channelHub;
    }

    public void deleteUserNotificiationEvent(long companyId, long userId, String notificationEventUuid) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.deleteUserNotificiationEvent(userId, notificationEventUuid);
    }

    public void deleteUserNotificiationEvents(long companyId, long userId, Collection<String> notificationEventUuids) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.deleteUserNotificiationEvents(userId, notificationEventUuids);
    }

    public void destroyChannel(long companyId, long userId) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.destroyChannel(userId);
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        MethodHandler methodHandler = new MethodHandler(_destroyChannelMethodKey, new Object[]{companyId, userId});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
        try {
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
        catch (Exception e2) {
            throw new ChannelException("Unable to destroy channel across cluster", (Throwable)e2);
        }
    }

    public void destroyChannelHub(long companyId) throws ChannelException {
        ChannelHub channelHub = (ChannelHub)this._channelHubs.remove(companyId);
        if (channelHub != null) {
            channelHub.destroy();
        }
    }

    public ChannelHub fetchChannelHub(long companyId) throws ChannelException {
        return this.fetchChannelHub(companyId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelHub fetchChannelHub(long companyId, boolean createIfAbsent) throws ChannelException {
        ChannelHub channelHub = (ChannelHub)this._channelHubs.get(companyId);
        if (channelHub == null) {
            ConcurrentMap<Long, ChannelHub> concurrentMap = this._channelHubs;
            synchronized (concurrentMap) {
                channelHub = (ChannelHub)this._channelHubs.get(companyId);
                if (channelHub == null && createIfAbsent) {
                    channelHub = this.createChannelHub(companyId);
                }
            }
        }
        return channelHub;
    }

    public List<NotificationEvent> fetchNotificationEvents(long companyId, long userId, boolean flush) throws ChannelException {
        ChannelHub channelHub = this.fetchChannelHub(companyId);
        if (channelHub == null) {
            return Collections.emptyList();
        }
        return channelHub.fetchNotificationEvents(userId, flush);
    }

    public void flush() throws ChannelException {
        for (ChannelHub channelHub : this._channelHubs.values()) {
            channelHub.flush();
        }
    }

    public void flush(long companyId) throws ChannelException {
        ChannelHub channelHub = this.fetchChannelHub(companyId);
        if (channelHub != null) {
            channelHub.flush();
        }
    }

    public void flush(long companyId, long userId, long timestamp) throws ChannelException {
        ChannelHub channelHub = this.fetchChannelHub(companyId);
        if (channelHub != null) {
            channelHub.flush(userId, timestamp);
        }
    }

    public Channel getChannel(long companyId, long userId) throws ChannelException {
        return this.getChannel(companyId, userId, false);
    }

    public Channel getChannel(long companyId, long userId, boolean createIfAbsent) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId, createIfAbsent);
        return channelHub.getChannel(userId, createIfAbsent);
    }

    public ChannelHub getChannelHub(long companyId) throws ChannelException {
        return this.getChannelHub(companyId, false);
    }

    public ChannelHub getChannelHub(long companyId, boolean createIfAbsent) throws ChannelException {
        ChannelHub channelHub = this.fetchChannelHub(companyId, createIfAbsent);
        if (channelHub == null) {
            throw new UnknownChannelHubException("No channel exists with company id " + companyId);
        }
        return channelHub;
    }

    public List<NotificationEvent> getNotificationEvents(long companyId, long userId) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        return channelHub.getNotificationEvents(userId);
    }

    public List<NotificationEvent> getNotificationEvents(long companyId, long userId, boolean flush) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        return channelHub.getNotificationEvents(userId, flush);
    }

    public Collection<Long> getUserIds(long companyId) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        return channelHub.getUserIds();
    }

    public void registerChannelListener(long companyId, long userId, ChannelListener channelListener) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.registerChannelListener(userId, channelListener);
    }

    public void removeTransientNotificationEvents(long companyId, long userId, Collection<NotificationEvent> notificationEvents) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.removeTransientNotificationEvents(userId, notificationEvents);
    }

    public void removeTransientNotificationEventsByUuid(long companyId, long userId, Collection<String> notificationEventUuids) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.removeTransientNotificationEventsByUuid(userId, notificationEventUuids);
    }

    public void sendNotificationEvent(long companyId, long userId, NotificationEvent notificationEvent) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.sendNotificationEvent(userId, notificationEvent);
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        MethodHandler methodHandler = new MethodHandler(_storeNotificationEventMethodKey, new Object[]{companyId, userId, notificationEvent});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
        try {
            ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        }
        catch (Exception e2) {
            throw new ChannelException("Unable to notify cluster of event", (Throwable)e2);
        }
    }

    public void sendNotificationEvents(long companyId, long userId, Collection<NotificationEvent> notificationEvents) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.sendNotificationEvents(userId, notificationEvents);
    }

    public void storeNotificationEvent(long companyId, long userId, NotificationEvent notificationEvent) throws ChannelException {
        ChannelHub channelHub = this.fetchChannelHub(companyId);
        if (channelHub != null) {
            channelHub.storeNotificationEvent(userId, notificationEvent);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("No channel hub exists for company " + companyId));
        }
    }

    public void unregisterChannelListener(long companyId, long userId, ChannelListener channelListener) throws ChannelException {
        ChannelHub channelHub = this.getChannelHub(companyId);
        channelHub.unregisterChannelListener(userId, channelListener);
    }
}

