/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.nio.intraband.proxy;

import com.liferay.portal.asm.ASMUtil;
import com.liferay.portal.asm.MethodNodeGenerator;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.proxy.ExceptionHandler;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxySkeleton;
import com.liferay.portal.kernel.nio.intraband.proxy.TargetLocator;
import com.liferay.portal.kernel.nio.intraband.proxy.annotation.Id;
import com.liferay.portal.kernel.nio.intraband.proxy.annotation.Proxy;
import com.liferay.portal.kernel.nio.intraband.rpc.RPCResponse;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.TableSwitchGenerator;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class IntrabandProxyUtil {
    public static final String SKELETON_POSTFIX = "__IntrabandProxy__Skeleton";
    public static final String STUB_POSTFIX = "__IntrabandProxy__Stub";
    private static final Type _DATAGRAM_TYPE = Type.getType(Datagram.class);
    private static final Type _DESERIALIZER_TYPE = Type.getType(Deserializer.class);
    private static final File _DUMP_DIR = new File(SystemProperties.get((String)"java.io.tmpdir"), PropsValues.INTRABAND_PROXY_DUMP_CLASSES_DIR);
    private static final Type _EXCEPTION_HANDLER_TYPE = Type.getType(ExceptionHandler.class);
    private static final Type _OBJECT_TYPE = Type.getType(Object.class);
    private static final String _PROXY_METHOD_SIGNATURES_FIELD_NAME = "PROXY_METHOD_SIGNATURES";
    private static final String _PROXY_METHODS_MAPPING_FIELD_NAME = "_PROXY_METHODS_MAPPING";
    private static final Type _REGISTRATION_REFERENCE_TYPE = Type.getType(RegistrationReference.class);
    private static final Type _RPC_RESPONSE_TYPE = Type.getType(RPCResponse.class);
    private static final Type _SERIALIZABLE_TYPE = Type.getType(Serializable.class);
    private static final Type _SERIALIZER_TYPE = Type.getType(Serializer.class);
    private static final Type _STRING_ARRAY_TYPE = Type.getType(String[].class);
    private static final Type _STRING_TYPE = Type.getType(String.class);
    private static final Type _TARGET_LOCATOR_TYPE = Type.getType(TargetLocator.class);
    private static final Log _log = LogFactoryUtil.getLog(IntrabandProxyUtil.class);
    private static final Set<String> _annotationDescriptors = new HashSet<String>(Arrays.asList(Type.getDescriptor(Id.class), Type.getDescriptor(Proxy.class)));
    private static final Method _defineClassMethod;
    private static final Comparator<Method> _methodComparator;

    public static String[] getProxyMethodSignatures(Class<?> clazz) {
        try {
            Field field = clazz.getField(_PROXY_METHOD_SIGNATURES_FIELD_NAME);
            return (String[])field.get(null);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Class<?> getStubClass(Class<?> clazz, String skeletonId) {
        return IntrabandProxyUtil.getStubClass(clazz.getClassLoader(), clazz, skeletonId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> getStubClass(ClassLoader classLoader, Class<?> clazz, String skeletonId) {
        Class<?> stubClass = IntrabandProxyUtil.loadClass(classLoader, clazz, STUB_POSTFIX);
        if (stubClass != null) {
            return stubClass;
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            stubClass = IntrabandProxyUtil.loadClass(classLoader, clazz, STUB_POSTFIX);
            if (stubClass != null) {
                return stubClass;
            }
            IntrabandProxyUtil.validate(classLoader, clazz, false);
            stubClass = IntrabandProxyUtil.generateStubClass(classLoader, clazz, skeletonId);
        }
        return stubClass;
    }

    public static <T> T newStubInstance(Class<? extends T> stubClass, String id, RegistrationReference registrationReference, ExceptionHandler exceptionHandler) {
        try {
            Constructor<T> constructor = stubClass.getConstructor(String.class, RegistrationReference.class, ExceptionHandler.class);
            return constructor.newInstance(id, registrationReference, exceptionHandler);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected static void checkField(Field[] fields, String name, Class<?> clazz, boolean isStatic) {
        for (Field field : fields) {
            if (!name.equals(field.getName())) continue;
            if (field.getType() == clazz && Modifier.isStatic(field.getModifiers()) == isStatic) break;
            throw new IllegalArgumentException("Field " + field + " is expected to be of type " + clazz + " and " + (!isStatic ? "not " : "") + "static");
        }
    }

    protected static MethodNode createProxyMethodNode(Method method, int index, String skeletonId, Type stubType) {
        MethodNodeGenerator methodNodeGenerator = new MethodNodeGenerator(method);
        methodNodeGenerator.newInstance(_SERIALIZER_TYPE);
        methodNodeGenerator.dup();
        methodNodeGenerator.invokeSpecial(_SERIALIZER_TYPE.getInternalName(), "<init>", Type.VOID_TYPE, new Type[0]);
        int serializerIndex = methodNodeGenerator.newLocal(_SERIALIZER_TYPE);
        methodNodeGenerator.storeLocal(serializerIndex);
        methodNodeGenerator.loadLocal(serializerIndex);
        methodNodeGenerator.push(skeletonId);
        IntrabandProxyUtil.serializerWrite(methodNodeGenerator, _STRING_TYPE);
        methodNodeGenerator.loadLocal(serializerIndex);
        methodNodeGenerator.loadThis();
        methodNodeGenerator.getField(stubType, "_id", _STRING_TYPE);
        IntrabandProxyUtil.serializerWrite(methodNodeGenerator, _STRING_TYPE);
        methodNodeGenerator.loadLocal(serializerIndex);
        methodNodeGenerator.push(index);
        IntrabandProxyUtil.serializerWrite(methodNodeGenerator, Type.INT_TYPE);
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            methodNodeGenerator.loadLocal(serializerIndex);
            methodNodeGenerator.loadArg(i);
            IntrabandProxyUtil.serializerWrite(methodNodeGenerator, Type.getType(parameterTypes[i]));
        }
        methodNodeGenerator.loadThis();
        methodNodeGenerator.loadLocal(serializerIndex);
        Class<?> returnClass = method.getReturnType();
        if (returnClass == Void.TYPE) {
            methodNodeGenerator.invokeSpecial(stubType.getInternalName(), "_send", Type.VOID_TYPE, _SERIALIZER_TYPE);
            methodNodeGenerator.returnValue();
        } else {
            methodNodeGenerator.invokeSpecial(stubType.getInternalName(), "_syncSend", _SERIALIZABLE_TYPE, _SERIALIZER_TYPE);
            Type returnType = Type.getType(returnClass);
            if (returnClass.isPrimitive()) {
                int returnValueIndex = methodNodeGenerator.newLocal(_OBJECT_TYPE);
                methodNodeGenerator.storeLocal(returnValueIndex);
                methodNodeGenerator.loadLocal(returnValueIndex);
                Label nullCheckLabel = new Label();
                methodNodeGenerator.ifNull(nullCheckLabel);
                methodNodeGenerator.loadLocal(returnValueIndex);
                methodNodeGenerator.unbox(returnType);
                methodNodeGenerator.returnValue();
                methodNodeGenerator.visitLabel(nullCheckLabel);
                ASMUtil.addDefaultReturnInsns((MethodVisitor)methodNodeGenerator, returnType);
            } else {
                if (returnClass != Object.class) {
                    methodNodeGenerator.checkCast(returnType);
                }
                methodNodeGenerator.returnValue();
            }
        }
        methodNodeGenerator.endMethod();
        return methodNodeGenerator.getMethodNode();
    }

    protected static void deserializerRead(MethodNodeGenerator methodNodeGenerator, Type type) {
        String owner = _DESERIALIZER_TYPE.getInternalName();
        if (type.getSort() <= 8) {
            String name = TextFormatter.format((String)type.getClassName(), (int)6);
            methodNodeGenerator.invokeVirtual(owner, "read".concat(name), type, new Type[0]);
        } else if (type.equals((Object)_STRING_TYPE)) {
            methodNodeGenerator.invokeVirtual(owner, "readString", _STRING_TYPE, new Type[0]);
        } else {
            methodNodeGenerator.invokeVirtual(owner, "readObject", _SERIALIZABLE_TYPE, new Type[0]);
        }
    }

    protected static MethodsBag extractMethods(Class<?> clazz) {
        ArrayList<Method> idMethods = new ArrayList<Method>();
        ArrayList<Method> proxyMethods = new ArrayList<Method>();
        ArrayList<Method> emptyMethods = new ArrayList<Method>();
        for (Method method : ReflectionUtil.getVisibleMethods(clazz)) {
            Id id = method.getAnnotation(Id.class);
            if (id != null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException("The @Id annotated method " + method + " must not be static");
                }
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length > 0) {
                    throw new IllegalArgumentException("The @Id annotated method " + method + " must not have parameters");
                }
                if (method.getReturnType() != String.class) {
                    throw new IllegalArgumentException("The @Id annotated method " + method + " must not return String");
                }
                idMethods.add(method);
                continue;
            }
            Proxy proxy = method.getAnnotation(Proxy.class);
            if (proxy != null) {
                if (Modifier.isStatic(method.getModifiers())) {
                    throw new IllegalArgumentException("Static proxy method violation for " + method);
                }
                proxyMethods.add(method);
                continue;
            }
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            emptyMethods.add(method);
        }
        return new MethodsBag(idMethods, proxyMethods, emptyMethods);
    }

    protected static Class<? extends IntrabandProxySkeleton> generateSkeletonClass(ClassLoader classLoader, Class<?> clazz) {
        Type targetType = Type.getType(clazz);
        String internalName = targetType.getInternalName();
        ClassNode classNode = ASMUtil.loadAndRename(TemplateSkeleton.class, internalName.concat(SKELETON_POSTFIX));
        classNode.access &= 0xFFFFFBFF;
        classNode.access |= 1;
        FieldNode proxyMethodsMappingFieldNode = ASMUtil.findFieldNode(classNode.fields, _PROXY_METHODS_MAPPING_FIELD_NAME);
        proxyMethodsMappingFieldNode.access |= 0x10;
        FieldNode targetLocatorFieldNode = ASMUtil.findFieldNode(classNode.fields, "_targetLocator");
        targetLocatorFieldNode.access |= 0x10;
        MethodNode doDispatchMethodNode = ASMUtil.findMethodNode(classNode.methods, "doDispatch", Type.VOID_TYPE, _REGISTRATION_REFERENCE_TYPE, _DATAGRAM_TYPE, _DESERIALIZER_TYPE);
        doDispatchMethodNode.access &= 0xFFFFFBFF;
        MethodNodeGenerator methodNodeGenerator = new MethodNodeGenerator(doDispatchMethodNode);
        methodNodeGenerator.loadThis();
        methodNodeGenerator.getField(Type.getObjectType((String)classNode.name), "_targetLocator", _TARGET_LOCATOR_TYPE);
        methodNodeGenerator.loadArg(2);
        IntrabandProxyUtil.deserializerRead(methodNodeGenerator, _STRING_TYPE);
        methodNodeGenerator.invokeInterface(_TARGET_LOCATOR_TYPE.getInternalName(), "getTarget", _OBJECT_TYPE, _STRING_TYPE);
        methodNodeGenerator.checkCast(targetType);
        int typedTargetIndex = methodNodeGenerator.newLocal(targetType);
        methodNodeGenerator.storeLocal(typedTargetIndex);
        methodNodeGenerator.loadArg(2);
        IntrabandProxyUtil.deserializerRead(methodNodeGenerator, Type.INT_TYPE);
        methodNodeGenerator.dup();
        int indexIndex = methodNodeGenerator.newLocal(Type.INT_TYPE);
        methodNodeGenerator.storeLocal(indexIndex);
        MethodsBag methodsBag = IntrabandProxyUtil.extractMethods(clazz);
        List<Method> proxyMethods = methodsBag.proxyMethods;
        int[] keys = new int[proxyMethods.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = i;
        }
        methodNodeGenerator.tableSwitch(keys, new SkeletonDispatchTableSwitchGenerator(methodNodeGenerator, proxyMethods, classNode.name, typedTargetIndex, indexIndex), true);
        methodNodeGenerator.returnValue();
        methodNodeGenerator.endMethod();
        IntrabandProxyUtil.rewriteGetProxyMethodSignaturesMethodNode(classNode, methodsBag.proxyMethodSignatures);
        return IntrabandProxyUtil.toClass(classNode, classLoader);
    }

    protected static Class<?> generateStubClass(ClassLoader classLoader, Class<?> clazz, String skeletonId) {
        MethodNode defaultClinitMethodNode;
        String internalName = Type.getInternalName(clazz);
        ClassNode classNode = ASMUtil.loadAndRename(clazz, internalName.concat(STUB_POSTFIX));
        classNode.access &= 0xFFFFF9FF;
        classNode.access |= 1;
        if (clazz.isInterface()) {
            List interfaces = classNode.interfaces;
            interfaces.clear();
            interfaces.add(internalName);
        }
        List methodNodes = classNode.methods;
        MethodNode defaultInitMethodNode = ASMUtil.removeMethodNode(methodNodes, "<init>", Type.VOID_TYPE, new Type[0]);
        ASMUtil.removeMethodNodes((List<MethodNode>)methodNodes, "<init>");
        ASMUtil.removeMethodNodes((List<MethodNode>)methodNodes, 1024);
        ASMUtil.removeMethodNodes((List<MethodNode>)methodNodes, _annotationDescriptors);
        ClassNode templateClassNode = ASMUtil.loadAndRename(TemplateStub.class, classNode.name);
        List templateFieldNodes = templateClassNode.fields;
        FieldNode idFieldNode = ASMUtil.findFieldNode(templateFieldNodes, "_id");
        idFieldNode.access |= 0x10;
        FieldNode intrabandFieldNode = ASMUtil.findFieldNode(templateFieldNodes, "_intraband");
        intrabandFieldNode.access |= 0x10;
        FieldNode registrationReferenceFieldNode = ASMUtil.findFieldNode(templateFieldNodes, "_registrationReference");
        registrationReferenceFieldNode.access |= 0x10;
        ASMUtil.addFieldNodes(classNode.fields, templateFieldNodes);
        List templateMethodNodes = templateClassNode.methods;
        MethodNode templateInitMethodNode = ASMUtil.findMethodNode(templateMethodNodes, "<init>", Type.VOID_TYPE, _STRING_TYPE, _REGISTRATION_REFERENCE_TYPE, _EXCEPTION_HANDLER_TYPE);
        if (defaultInitMethodNode != null) {
            ASMUtil.mergeMethods(templateInitMethodNode, defaultInitMethodNode, templateInitMethodNode);
        }
        if ((defaultClinitMethodNode = ASMUtil.removeMethodNode(methodNodes, "<clinit>", Type.VOID_TYPE, new Type[0])) != null) {
            MethodNode templateClinitMethodNode = ASMUtil.findMethodNode(templateMethodNodes, "<clinit>", Type.VOID_TYPE, new Type[0]);
            ASMUtil.mergeMethods(templateClinitMethodNode, defaultClinitMethodNode, templateClinitMethodNode);
        }
        methodNodes.addAll(templateMethodNodes);
        Type stubType = Type.getType((String)classNode.name);
        MethodsBag methodsBag = IntrabandProxyUtil.extractMethods(clazz);
        for (Method idMethod : methodsBag.idMethods) {
            MethodNodeGenerator methodNodeGenerator = new MethodNodeGenerator(idMethod);
            methodNodeGenerator.loadThis();
            methodNodeGenerator.getField(stubType, "_id", _STRING_TYPE);
            methodNodeGenerator.returnValue();
            methodNodeGenerator.endMethod();
            methodNodes.add(methodNodeGenerator.getMethodNode());
        }
        List<Method> proxyMethods = methodsBag.proxyMethods;
        for (int i = 0; i < proxyMethods.size(); ++i) {
            methodNodes.add(IntrabandProxyUtil.createProxyMethodNode(proxyMethods.get(i), i, skeletonId, stubType));
        }
        for (Method emptyMethod : methodsBag.emptyMethods) {
            MethodNodeGenerator methodNodeGenerator = new MethodNodeGenerator(emptyMethod);
            ASMUtil.addDefaultReturnInsns((MethodVisitor)methodNodeGenerator, Type.getType(emptyMethod.getReturnType()));
            methodNodeGenerator.endMethod();
            methodNodes.add(methodNodeGenerator.getMethodNode());
        }
        IntrabandProxyUtil.rewriteGetProxyMethodSignaturesMethodNode(classNode, methodsBag.proxyMethodSignatures);
        return IntrabandProxyUtil.toClass(classNode, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class<?> getSkeletonClass(ClassLoader classLoader, Class<?> clazz) throws Exception {
        Class<Object> skeletonClass = IntrabandProxyUtil.loadClass(classLoader, clazz, SKELETON_POSTFIX);
        if (skeletonClass != null) {
            return skeletonClass;
        }
        ClassLoader classLoader2 = classLoader;
        synchronized (classLoader2) {
            skeletonClass = IntrabandProxyUtil.loadClass(classLoader, clazz, SKELETON_POSTFIX);
            if (skeletonClass != null) {
                return skeletonClass;
            }
            IntrabandProxyUtil.validate(classLoader, clazz, true);
            skeletonClass = IntrabandProxyUtil.generateSkeletonClass(classLoader, clazz);
        }
        return skeletonClass;
    }

    protected static Class<?> loadClass(ClassLoader classLoader, Class<?> clazz, String postfix) {
        String className = clazz.getName();
        try {
            return Class.forName(className.concat(postfix), false, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    protected static void rewriteGetProxyMethodSignaturesMethodNode(ClassNode classNode, String[] proxyMethodSignatures) {
        MethodNode methodNode = ASMUtil.findMethodNode(classNode.methods, "_getProxyMethodSignatures", _STRING_ARRAY_TYPE, new Type[0]);
        InsnList insnList = methodNode.instructions;
        insnList.clear();
        MethodNodeGenerator methodNodeGenerator = new MethodNodeGenerator(methodNode);
        methodNodeGenerator.push(proxyMethodSignatures.length);
        methodNodeGenerator.newArray(_STRING_TYPE);
        for (int i = 0; i < proxyMethodSignatures.length; ++i) {
            methodNodeGenerator.dup();
            methodNodeGenerator.push(i);
            methodNodeGenerator.push(proxyMethodSignatures[i]);
            methodNodeGenerator.arrayStore(_STRING_TYPE);
        }
        methodNodeGenerator.returnValue();
        methodNodeGenerator.endMethod();
    }

    protected static void serializerWrite(MethodNodeGenerator methodNodeGenerator, Type type) {
        String owner = _SERIALIZER_TYPE.getInternalName();
        if (type.getSort() <= 8) {
            String name = TextFormatter.format((String)type.getClassName(), (int)6);
            methodNodeGenerator.invokeVirtual(owner, "write".concat(name), Type.VOID_TYPE, type);
        } else if (type.equals((Object)_STRING_TYPE)) {
            methodNodeGenerator.invokeVirtual(owner, "writeString", Type.VOID_TYPE, _STRING_TYPE);
        } else {
            methodNodeGenerator.invokeVirtual(owner, "writeObject", Type.VOID_TYPE, _SERIALIZABLE_TYPE);
        }
    }

    protected static Class<?> toClass(ClassNode classNode, ClassLoader classLoader) {
        ClassWriter classWriter = new ClassWriter(2);
        classNode.accept((ClassVisitor)classWriter);
        byte[] data = classWriter.toByteArray();
        try {
            if (PropsValues.INTRABAND_PROXY_DUMP_CLASSES_ENABLED) {
                File classFile = new File(_DUMP_DIR, classNode.name.concat(".class"));
                FileUtil.write((File)classFile, (byte[])data);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Dumpped class " + classFile.getAbsolutePath()));
                }
            }
            return (Class)_defineClassMethod.invoke((Object)classLoader, StringUtil.replace((String)classNode.name, (char)'/', (char)'.'), data, 0, data.length);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    protected static void validate(ClassLoader classLoader, Class<?> clazz, boolean skeletonOrStub) {
        if (clazz.isAnnotation()) {
            throw new IllegalArgumentException(clazz + " is an annotation");
        }
        if (clazz.isArray()) {
            throw new IllegalArgumentException(clazz + " is an array");
        }
        if (clazz.isEnum()) {
            throw new IllegalArgumentException(clazz + " is an enum");
        }
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException(clazz + " is a primitive");
        }
        Class<?> reloadedClass = null;
        try {
            reloadedClass = Class.forName(clazz.getName(), false, classLoader);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (reloadedClass != clazz) {
            throw new IllegalArgumentException(clazz + " is not visible from class loader " + classLoader);
        }
        Field[] fields = clazz.getDeclaredFields();
        IntrabandProxyUtil.checkField(fields, _PROXY_METHOD_SIGNATURES_FIELD_NAME, String[].class, true);
        if (skeletonOrStub) {
            IntrabandProxyUtil.checkField(fields, _PROXY_METHODS_MAPPING_FIELD_NAME, String.class, true);
            IntrabandProxyUtil.checkField(fields, "_log", Log.class, true);
            IntrabandProxyUtil.checkField(fields, "_targetLocator", TargetLocator.class, false);
        } else {
            IntrabandProxyUtil.checkField(fields, "_exceptionHandler", ExceptionHandler.class, false);
            IntrabandProxyUtil.checkField(fields, "_id", String.class, false);
            IntrabandProxyUtil.checkField(fields, "_intraband", Intraband.class, false);
            IntrabandProxyUtil.checkField(fields, "_proxyType", Byte.TYPE, true);
            IntrabandProxyUtil.checkField(fields, "_registrationReference", RegistrationReference.class, false);
        }
    }

    static {
        _methodComparator = new MethodComparator();
        try {
            _defineClassMethod = ReflectionUtil.getDeclaredMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }

    private static class SkeletonDispatchTableSwitchGenerator
    implements TableSwitchGenerator {
        private final int _indexIndex;
        private final MethodNodeGenerator _methodNodeGenerator;
        private final String _owner;
        private final List<Method> _proxyMethods;
        private final int _typedTargetIndex;

        public SkeletonDispatchTableSwitchGenerator(MethodNodeGenerator methodNodeGenerator, List<Method> proxyMethods, String owner, int typedTargetIndex, int indexIndex) {
            this._methodNodeGenerator = methodNodeGenerator;
            this._proxyMethods = proxyMethods;
            this._owner = owner;
            this._typedTargetIndex = typedTargetIndex;
            this._indexIndex = indexIndex;
        }

        public void generateCase(int key, Label end) {
            Method proxyMethod = this._proxyMethods.get(key);
            Class<?> returnClass = proxyMethod.getReturnType();
            if (returnClass != Void.TYPE) {
                this._methodNodeGenerator.loadThis();
                this._methodNodeGenerator.loadArg(0);
                this._methodNodeGenerator.loadArg(1);
                this._methodNodeGenerator.newInstance(_RPC_RESPONSE_TYPE);
                this._methodNodeGenerator.dup();
            }
            this._methodNodeGenerator.loadLocal(this._typedTargetIndex);
            for (Class<?> parameterClass : proxyMethod.getParameterTypes()) {
                this._methodNodeGenerator.loadArg(2);
                Type parameterType = Type.getType(parameterClass);
                IntrabandProxyUtil.deserializerRead(this._methodNodeGenerator, parameterType);
                if (parameterClass.isPrimitive() || parameterClass == Object.class || parameterClass == String.class) continue;
                this._methodNodeGenerator.checkCast(parameterType);
            }
            Class<?> declaringClass = proxyMethod.getDeclaringClass();
            if (declaringClass.isInterface()) {
                this._methodNodeGenerator.invokeInterface(Type.getInternalName(declaringClass), proxyMethod);
            } else {
                this._methodNodeGenerator.invokeVirtual(Type.getInternalName(declaringClass), proxyMethod);
            }
            if (returnClass != Void.TYPE) {
                if (returnClass.isPrimitive()) {
                    this._methodNodeGenerator.box(Type.getType(returnClass));
                } else if (Serializable.class.isAssignableFrom(returnClass)) {
                    this._methodNodeGenerator.checkCast(_SERIALIZABLE_TYPE);
                }
                this._methodNodeGenerator.invokeSpecial(_RPC_RESPONSE_TYPE.getInternalName(), "<init>", Type.VOID_TYPE, _SERIALIZABLE_TYPE);
                this._methodNodeGenerator.invokeSpecial(this._owner, "_sendResponse", Type.VOID_TYPE, _REGISTRATION_REFERENCE_TYPE, _DATAGRAM_TYPE, _RPC_RESPONSE_TYPE);
            }
            this._methodNodeGenerator.goTo(end);
        }

        public void generateDefault() {
            this._methodNodeGenerator.loadThis();
            this._methodNodeGenerator.loadLocal(this._indexIndex);
            this._methodNodeGenerator.invokeSpecial(this._owner, "_unknownMethodIndex", Type.VOID_TYPE, Type.INT_TYPE);
        }
    }

    protected static class TemplateStub {
        public static final String[] PROXY_METHOD_SIGNATURES = TemplateStub._getProxyMethodSignatures();
        private static final byte _PROXY_TYPE = SystemDataType.PROXY.getValue();
        private final ExceptionHandler _exceptionHandler;
        private String _id;
        private final Intraband _intraband;
        private final RegistrationReference _registrationReference;

        public TemplateStub(String id, RegistrationReference registrationReference, ExceptionHandler exceptionHandler) {
            if (id == null) {
                throw new NullPointerException("Id is null");
            }
            if (registrationReference == null) {
                throw new NullPointerException("Registration reference is null");
            }
            this._id = id;
            this._registrationReference = registrationReference;
            this._exceptionHandler = exceptionHandler;
            this._intraband = registrationReference.getIntraband();
        }

        private static String[] _getProxyMethodSignatures() {
            return new String[0];
        }

        private void _send(Serializer serializer) {
            this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram((byte)_PROXY_TYPE, (ByteBuffer)serializer.toByteBuffer()));
        }

        private <T extends Serializable> T _syncSend(Serializer serializer) {
            try {
                Datagram responseDatagram = this._intraband.sendSyncDatagram(this._registrationReference, Datagram.createRequestDatagram((byte)_PROXY_TYPE, (ByteBuffer)serializer.toByteBuffer()));
                Deserializer deserializer = new Deserializer(responseDatagram.getDataByteBuffer());
                RPCResponse rpcResponse = (RPCResponse)deserializer.readObject();
                Exception e2 = rpcResponse.getException();
                if (e2 != null) {
                    throw e2;
                }
                return (T)rpcResponse.getResult();
            }
            catch (Exception e3) {
                if (this._exceptionHandler != null) {
                    this._exceptionHandler.onException(e3);
                }
                return null;
            }
        }
    }

    protected static abstract class TemplateSkeleton
    implements IntrabandProxySkeleton {
        public static final String[] PROXY_METHOD_SIGNATURES = TemplateSkeleton._getProxyMethodSignatures();
        private static final String _PROXY_METHODS_MAPPING = TemplateSkeleton._getProxyMethodsMapping(PROXY_METHOD_SIGNATURES);
        private static final Log _log = LogFactoryUtil.getLog(TemplateSkeleton.class);
        private TargetLocator _targetLocator;

        public TemplateSkeleton(TargetLocator targetLocator) {
            if (targetLocator == null) {
                throw new NullPointerException("Target locator is null");
            }
            this._targetLocator = targetLocator;
        }

        public void dispatch(RegistrationReference registrationReference, Datagram datagram, Deserializer deserializer) {
            try {
                this.doDispatch(registrationReference, datagram, deserializer);
            }
            catch (Exception e2) {
                _log.error((Object)"Unable to dispatch", (Throwable)e2);
                this._sendResponse(registrationReference, datagram, new RPCResponse(e2));
            }
        }

        protected abstract void doDispatch(RegistrationReference var1, Datagram var2, Deserializer var3) throws Exception;

        private static String[] _getProxyMethodSignatures() {
            return new String[0];
        }

        private static String _getProxyMethodsMapping(String[] proxyMethodsSignatures) {
            StringBundler sb = new StringBundler(proxyMethodsSignatures.length * 4 + 1);
            sb.append("{");
            for (int i = 0; i < proxyMethodsSignatures.length; ++i) {
                sb.append(i);
                sb.append(" -> ");
                sb.append(proxyMethodsSignatures[i]);
                sb.append(", ");
            }
            if (proxyMethodsSignatures.length > 0) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append("}");
            return sb.toString();
        }

        private void _sendResponse(RegistrationReference registrationReference, Datagram datagram, RPCResponse rpcResponse) {
            Serializer serializer = new Serializer();
            serializer.writeObject((Serializable)rpcResponse);
            Intraband intraband = registrationReference.getIntraband();
            intraband.sendDatagram(registrationReference, Datagram.createResponseDatagram((Datagram)datagram, (ByteBuffer)serializer.toByteBuffer()));
        }

        private void _unknownMethodIndex(int methodIndex) {
            throw new IllegalArgumentException("Unknow method index " + methodIndex + " for proxy methods mappings " + _PROXY_METHODS_MAPPING);
        }
    }

    protected static class MethodsBag {
        protected List<Method> emptyMethods;
        protected List<Method> idMethods;
        protected List<Method> proxyMethods;
        protected String[] proxyMethodSignatures;

        public MethodsBag(List<Method> idMethods, List<Method> proxyMethods, List<Method> emptyMethods) {
            this.idMethods = idMethods;
            this.proxyMethods = proxyMethods;
            this.emptyMethods = emptyMethods;
            Collections.sort(proxyMethods, _methodComparator);
            this.proxyMethodSignatures = new String[proxyMethods.size()];
            for (int i = 0; i < proxyMethods.size(); ++i) {
                Method proxyMethod = proxyMethods.get(i);
                String name = proxyMethod.getName();
                this.proxyMethodSignatures[i] = name.concat("-").concat(Type.getMethodDescriptor((Method)proxyMethod));
            }
        }
    }

    protected static class MethodComparator
    implements Comparator<Method> {
        protected MethodComparator() {
        }

        @Override
        public int compare(Method method1, Method method2) {
            String methodId1 = MethodComparator._getMethodId(method1);
            String methodId2 = MethodComparator._getMethodId(method2);
            return methodId1.compareTo(methodId2);
        }

        private static String _getMethodId(Method method) {
            Proxy proxy = method.getAnnotation(Proxy.class);
            String methodName = proxy.name();
            if (methodName.isEmpty()) {
                methodName = method.getName();
            }
            return methodName.concat("-").concat(Type.getMethodDescriptor((Method)method));
        }
    }
}

