/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.nio.intraband.proxy;

import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxySkeleton;
import com.liferay.portal.kernel.nio.intraband.proxy.IntrabandProxySkeletonRegistryUtil;
import com.liferay.portal.kernel.nio.intraband.proxy.TargetLocator;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.process.ProcessException;
import com.liferay.portal.kernel.util.ClassLoaderPool;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyUtil;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.concurrent.Future;

public class IntrabandProxyInstallationUtil {
    public static void checkProxyMethodSignatures(String[] skeletonProxyMethodSignatures, String[] stubProxyMethodSignatures) {
        if (Arrays.equals(skeletonProxyMethodSignatures, stubProxyMethodSignatures)) {
            return;
        }
        String skeletonProxyMethodSignaturesString = Arrays.toString(skeletonProxyMethodSignatures);
        String stubProxyMethodSignaturesString = Arrays.toString(stubProxyMethodSignatures);
        throw new IllegalStateException("Skeleton and stub proxy method signatures do not match. Skeleton is " + skeletonProxyMethodSignaturesString + ". Stub is " + stubProxyMethodSignaturesString + ".");
    }

    public static String[] installSkeleton(Class<?> clazz, TargetLocator targetLocator) {
        return IntrabandProxyInstallationUtil.installSkeleton(clazz.getClassLoader(), clazz, targetLocator);
    }

    public static String[] installSkeleton(ClassLoader classLoader, Class<?> clazz, TargetLocator targetLocator) {
        try {
            Class<?> proxySkeletonClass = IntrabandProxyUtil.getSkeletonClass(classLoader, clazz);
            Constructor<?> constructor = proxySkeletonClass.getConstructor(TargetLocator.class);
            IntrabandProxySkeletonRegistryUtil.register((String)clazz.getName(), (IntrabandProxySkeleton)((IntrabandProxySkeleton)constructor.newInstance(targetLocator)));
            return IntrabandProxyUtil.getProxyMethodSignatures(proxySkeletonClass);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static Future<String[]> installSkeleton(RegistrationReference registrationReference, Class<?> clazz, TargetLocator targetLocator) {
        return IntrabandProxyInstallationUtil.installSkeleton(registrationReference, clazz.getClassLoader(), clazz, targetLocator);
    }

    public static Future<String[]> installSkeleton(RegistrationReference registrationReference, ClassLoader classLoader, Class<?> clazz, TargetLocator targetLocator) {
        return IntrabandRPCUtil.execute((RegistrationReference)registrationReference, (ProcessCallable)new InstallSkeletonProcessCallable(classLoader, clazz, targetLocator));
    }

    protected static class InstallSkeletonProcessCallable
    implements ProcessCallable<String[]> {
        private static final long serialVersionUID = 1L;
        private final String _servletContextName;
        private final String _skeletonId;
        private final TargetLocator _targetLocator;

        public String[] call() throws ProcessException {
            ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)this._servletContextName);
            try {
                return IntrabandProxyInstallationUtil.installSkeleton(classLoader, classLoader.loadClass(this._skeletonId), this._targetLocator);
            }
            catch (Exception e2) {
                throw new ProcessException((Throwable)e2);
            }
        }

        protected InstallSkeletonProcessCallable(ClassLoader classLoader, Class<?> clazz, TargetLocator targetLocator) {
            this._servletContextName = ClassLoaderPool.getContextName((ClassLoader)classLoader);
            this._skeletonId = clazz.getName();
            this._targetLocator = targetLocator;
        }
    }
}

