/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.module.framework;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ModuleFrameworkClassLoader
extends URLClassLoader {
    public ModuleFrameworkClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> urls = new ArrayList<URL>();
        urls.addAll(this._buildURLs(null));
        Enumeration<URL> localURLs = this.findResources(name);
        urls.addAll(this._buildURLs(localURLs));
        Enumeration<URL> parentURLs = null;
        ClassLoader parentClassLoader = this.getParent();
        if (parentClassLoader != null) {
            parentURLs = parentClassLoader.getResources(name);
        }
        urls.addAll(this._buildURLs(parentURLs));
        return new Enumeration<URL>(){
            final Iterator<URL> iterator;
            {
                this.iterator = urls.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.iterator.next();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object lock;
        Object object = lock = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = super.loadClass(name, resolve);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }

    private List<URL> _buildURLs(Enumeration<URL> url) {
        if (url == null) {
            return new ArrayList<URL>();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        while (url.hasMoreElements()) {
            urls.add(url.nextElement());
        }
        return urls;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

