/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.jsonwebservice.DefaultJSONWebServiceRegistrator;
import com.liferay.portal.jsonwebservice.JSONRPCRequest;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionConfig;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionImpl;
import com.liferay.portal.jsonwebservice.JSONWebServiceActionParameters;
import com.liferay.portal.kernel.bean.BeanLocator;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceAction;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionMapping;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceActionsManager;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceNaming;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceRegistrator;
import com.liferay.portal.kernel.jsonwebservice.NoSuchJSONWebServiceException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.util.PropsValues;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class JSONWebServiceActionsManagerImpl
implements JSONWebServiceActionsManager {
    private static final Log _log = LogFactoryUtil.getLog(JSONWebServiceActionsManagerImpl.class);
    private final Map<String, List<JSONWebServiceActionConfig>> _contextNameIndexedJSONWebServiceActionConfigs = new ConcurrentHashMap<String, List<JSONWebServiceActionConfig>>();
    private final JSONWebServiceNaming _jsonWebServiceNaming = new JSONWebServiceNaming();
    private final Map<String, List<JSONWebServiceActionConfig>> _pathIndexedJSONWebServiceActionConfigs = new ConcurrentHashMap<String, List<JSONWebServiceActionConfig>>();
    private final ConcurrentMap<String, JSONWebServiceActionConfig> _signatureIndexedJSONWebServiceActionConfigs = new ConcurrentHashMap<String, JSONWebServiceActionConfig>();

    public Set<String> getContextNames() {
        return new TreeSet<String>(this._contextNameIndexedJSONWebServiceActionConfigs.keySet());
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request) throws NoSuchJSONWebServiceException {
        String path = GetterUtil.getString((String)request.getPathInfo());
        String method = GetterUtil.getString((String)request.getMethod());
        String parameterPath = null;
        JSONRPCRequest jsonRPCRequest = null;
        int parameterPathIndex = this._getParameterPathIndex(path);
        if (parameterPathIndex != -1) {
            parameterPath = path.substring(parameterPathIndex);
            path = path.substring(0, parameterPathIndex);
        } else if (method.equals("POST") && !PortalUtil.isMultipartRequest((HttpServletRequest)request) && (jsonRPCRequest = JSONRPCRequest.detectJSONRPCRequest(request)) != null) {
            path = path + "/" + jsonRPCRequest.getMethod();
            method = null;
        }
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, parameterPath, jsonRPCRequest, null);
        if (jsonWebServiceActionParameters.getServiceContext() != null) {
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)jsonWebServiceActionParameters.getServiceContext());
        }
        JSONWebServiceActionConfig jsonWebServiceActionConfig = this._findJSONWebServiceAction(request, path, method, jsonWebServiceActionParameters);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters, this._jsonWebServiceNaming);
    }

    public JSONWebServiceAction getJSONWebServiceAction(HttpServletRequest request, String path, String method, Map<String, Object> parameterMap) throws NoSuchJSONWebServiceException {
        JSONWebServiceActionParameters jsonWebServiceActionParameters = new JSONWebServiceActionParameters();
        jsonWebServiceActionParameters.collectAll(request, null, null, parameterMap);
        JSONWebServiceActionConfig jsonWebServiceActionConfig = this._findJSONWebServiceAction(request, path, method, jsonWebServiceActionParameters);
        return new JSONWebServiceActionImpl(jsonWebServiceActionConfig, jsonWebServiceActionParameters, this._jsonWebServiceNaming);
    }

    public JSONWebServiceActionMapping getJSONWebServiceActionMapping(String signature) {
        return (JSONWebServiceActionMapping)this._signatureIndexedJSONWebServiceActionConfigs.get(signature);
    }

    public List<JSONWebServiceActionMapping> getJSONWebServiceActionMappings(String contextName) {
        List<JSONWebServiceActionConfig> jsonWebServiceActionConfigs = this._contextNameIndexedJSONWebServiceActionConfigs.get(contextName);
        if (jsonWebServiceActionConfigs == null) {
            return Collections.emptyList();
        }
        return new ArrayList<JSONWebServiceActionMapping>(jsonWebServiceActionConfigs);
    }

    public int getJSONWebServiceActionsCount(String contextName) {
        List<JSONWebServiceActionConfig> jsonWebServiceActionConfigs = this._contextNameIndexedJSONWebServiceActionConfigs.get(contextName);
        if (jsonWebServiceActionConfigs == null) {
            return 0;
        }
        return jsonWebServiceActionConfigs.size();
    }

    public JSONWebServiceNaming getJSONWebServiceNaming() {
        return this._jsonWebServiceNaming;
    }

    public synchronized void registerJSONWebServiceAction(String contextName, String contextPath, Class<?> actionClass, Method actionMethod, String path, String method) {
        block3: {
            try {
                if (!this._addJSONWebServiceActionConfig(new JSONWebServiceActionConfig(contextName, contextPath, actionClass, actionMethod, path, method)) && _log.isDebugEnabled()) {
                    _log.debug((Object)("A JSON web service action is already registered at " + path));
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                StringBundler sb = new StringBundler(14);
                sb.append("Unable to register service method {actionClass=");
                sb.append(actionClass);
                sb.append(", actionMethod=");
                sb.append((Object)actionMethod);
                sb.append(", contextName=");
                sb.append(contextName);
                sb.append(", contextPath=");
                sb.append(contextPath);
                sb.append(", method=");
                sb.append(method);
                sb.append(", path=");
                sb.append(path);
                sb.append("} due to ");
                sb.append(e2.getMessage());
                _log.warn((Object)sb.toString());
            }
        }
    }

    public synchronized void registerJSONWebServiceAction(String contextName, String contextPath, Object actionObject, Class<?> actionClass, Method actionMethod, String path, String method) {
        try {
            if (!this._addJSONWebServiceActionConfig(new JSONWebServiceActionConfig(contextName, contextPath, actionObject, actionClass, actionMethod, path, method)) && _log.isWarnEnabled()) {
                _log.warn((Object)("A JSON web service action is already registered at " + path));
            }
        }
        catch (Exception e2) {
            StringBundler sb = new StringBundler(17);
            sb.append("Something went wrong attempting to register service ");
            sb.append("method {contextName=");
            sb.append(contextName);
            sb.append(",contextPath=");
            sb.append(contextPath);
            sb.append(",actionObject=");
            sb.append(actionObject);
            sb.append(",actionClass=");
            sb.append(actionClass);
            sb.append(",actionMethod=");
            sb.append((Object)actionMethod);
            sb.append(",path=");
            sb.append(path);
            sb.append(",method=");
            sb.append(method);
            sb.append("} due to ");
            sb.append(e2.getMessage());
            _log.warn((Object)sb.toString());
        }
    }

    public int registerService(String contextPath, Object service) {
        return this.registerService("", contextPath, service);
    }

    public int registerService(String contextName, String contextPath, Object service) {
        DefaultJSONWebServiceRegistrator jsonWebServiceRegistrator = new DefaultJSONWebServiceRegistrator();
        return this.registerService(contextName, contextPath, service, jsonWebServiceRegistrator);
    }

    public int registerService(String contextName, String contextPath, Object service, JSONWebServiceRegistrator jsonWebServiceRegistrator) {
        jsonWebServiceRegistrator.processBean(contextName, contextPath, service);
        int count = this.getJSONWebServiceActionsCount(contextPath);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Configured " + count + " actions for " + contextPath));
        }
        return count;
    }

    public int registerServletContext(ServletContext servletContext) {
        BeanLocator beanLocator = null;
        String contextName = servletContext.getServletContextName();
        String contextPath = servletContext.getContextPath();
        beanLocator = contextPath.equals(PortalContextLoaderListener.getPortalServletContextPath()) || contextPath.isEmpty() ? PortalBeanLocatorUtil.getBeanLocator() : PortletBeanLocatorUtil.getBeanLocator((String)contextName);
        if (beanLocator == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Bean locator not available for " + contextPath));
            }
            return -1;
        }
        DefaultJSONWebServiceRegistrator defaultJSONWebServiceRegistrator = new DefaultJSONWebServiceRegistrator();
        defaultJSONWebServiceRegistrator.processAllBeans(contextName, contextPath, beanLocator);
        int count = this.getJSONWebServiceActionsCount(contextPath);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Configured " + count + " actions for " + contextPath));
        }
        return count;
    }

    public synchronized int unregisterJSONWebServiceActions(Object actionObject) {
        int count = 0;
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._signatureIndexedJSONWebServiceActionConfigs.values()) {
            if (!actionObject.equals(jsonWebServiceActionConfig.getActionObject()) || !this._removeJSONWebServiceActionConfig(jsonWebServiceActionConfig)) continue;
            ++count;
        }
        return count;
    }

    public synchronized int unregisterJSONWebServiceActions(String contextPath) {
        int count = 0;
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : this._signatureIndexedJSONWebServiceActionConfigs.values()) {
            if (!contextPath.equals(jsonWebServiceActionConfig.getContextPath()) || !this._removeJSONWebServiceActionConfig(jsonWebServiceActionConfig)) continue;
            ++count;
        }
        return count;
    }

    public int unregisterServletContext(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        return this.unregisterJSONWebServiceActions(contextPath);
    }

    private boolean _addJSONWebServiceActionConfig(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        JSONWebServiceActionConfig oldJSONWebServiceActionConfig = this._signatureIndexedJSONWebServiceActionConfigs.putIfAbsent(jsonWebServiceActionConfig.getSignature(), jsonWebServiceActionConfig);
        if (oldJSONWebServiceActionConfig != null) {
            return false;
        }
        String contextName = jsonWebServiceActionConfig.getContextName();
        List<JSONWebServiceActionConfig> jsonWebServiceActionConfigs = this._contextNameIndexedJSONWebServiceActionConfigs.get(contextName);
        if (jsonWebServiceActionConfigs == null) {
            jsonWebServiceActionConfigs = new CopyOnWriteArrayList<JSONWebServiceActionConfig>();
            this._contextNameIndexedJSONWebServiceActionConfigs.put(contextName, jsonWebServiceActionConfigs);
        }
        jsonWebServiceActionConfigs.add(jsonWebServiceActionConfig);
        jsonWebServiceActionConfigs = this._pathIndexedJSONWebServiceActionConfigs.get(jsonWebServiceActionConfig.getPath());
        if (jsonWebServiceActionConfigs == null) {
            jsonWebServiceActionConfigs = new CopyOnWriteArrayList<JSONWebServiceActionConfig>();
            this._pathIndexedJSONWebServiceActionConfigs.put(jsonWebServiceActionConfig.getPath(), jsonWebServiceActionConfigs);
        }
        jsonWebServiceActionConfigs.add(jsonWebServiceActionConfig);
        return true;
    }

    private int _countMatchedParameters(String[] parameterNames, MethodParameter[] methodParameters) {
        int matched = 0;
        for (MethodParameter methodParameter : methodParameters) {
            String methodParameterName = methodParameter.getName();
            methodParameterName = StringUtil.toLowerCase((String)methodParameterName);
            for (String parameterName : parameterNames) {
                if (!StringUtil.equalsIgnoreCase((String)parameterName, (String)methodParameterName)) continue;
                ++matched;
            }
        }
        return matched;
    }

    private JSONWebServiceActionConfig _findJSONWebServiceAction(HttpServletRequest request, String path, String method, JSONWebServiceActionParameters jsonWebServiceActionParameters) throws NoSuchJSONWebServiceException {
        String[] parameterNames;
        JSONWebServiceActionConfig jsonWebServiceActionConfig;
        String[] paths = this._resolvePaths(request, path);
        String contextName = paths[0];
        path = paths[1];
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Request JSON web service action with path " + path + " and method " + method + " for " + contextName));
        }
        if ((jsonWebServiceActionConfig = this._getJSONWebServiceActionConfig(contextName, path, method, parameterNames = jsonWebServiceActionParameters.getParameterNames())) == null && jsonWebServiceActionParameters.includeDefaultParameters()) {
            parameterNames = jsonWebServiceActionParameters.getParameterNames();
            jsonWebServiceActionConfig = this._getJSONWebServiceActionConfig(contextName, path, method, parameterNames);
        }
        if (jsonWebServiceActionConfig == null) {
            throw new NoSuchJSONWebServiceException("No JSON web service action with path " + path + " and method " + method + " for " + contextName);
        }
        return jsonWebServiceActionConfig;
    }

    private JSONWebServiceActionConfig _getJSONWebServiceActionConfig(String contextName, String path, String method, String[] parameterNames) {
        List<JSONWebServiceActionConfig> jsonWebServiceActionConfigs;
        int dotIndex;
        String pathPrefix;
        int hint = -1;
        int offset = 0;
        if (Validator.isNotNull((String)contextName) && path.startsWith(pathPrefix = "/".concat(contextName).concat("."))) {
            offset = pathPrefix.length();
        }
        if ((dotIndex = path.indexOf(46, offset)) != -1 && (hint = GetterUtil.getInteger((String)path.substring(dotIndex + 1), (int)-1)) != -1) {
            path = path.substring(0, dotIndex);
        }
        if ((jsonWebServiceActionConfigs = this._pathIndexedJSONWebServiceActionConfigs.get(path)) == null || jsonWebServiceActionConfigs.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to find JSON web service actions with path " + path + " for " + contextName));
            }
            return null;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Found " + jsonWebServiceActionConfigs.size() + " JSON web service actions with path " + path + " for " + contextName));
        }
        jsonWebServiceActionConfigs = new ArrayList<JSONWebServiceActionConfig>(jsonWebServiceActionConfigs);
        Collections.sort(jsonWebServiceActionConfigs);
        int max = -1;
        JSONWebServiceActionConfig matchedJSONWebServiceActionConfig = null;
        for (JSONWebServiceActionConfig jsonWebServiceActionConfig : jsonWebServiceActionConfigs) {
            int count;
            String jsonWebServiceActionConfigMethod = jsonWebServiceActionConfig.getMethod();
            if (PropsValues.JSONWS_WEB_SERVICE_STRICT_HTTP_METHOD && method != null && jsonWebServiceActionConfigMethod != null && !jsonWebServiceActionConfigMethod.equals(method)) continue;
            MethodParameter[] jsonWebServiceActionConfigMethodParameters = jsonWebServiceActionConfig.getMethodParameters();
            int methodParametersCount = jsonWebServiceActionConfigMethodParameters.length;
            if (hint != -1 && methodParametersCount != hint || (count = this._countMatchedParameters(parameterNames, jsonWebServiceActionConfigMethodParameters)) <= max || hint == -1 && count < methodParametersCount) continue;
            max = count;
            matchedJSONWebServiceActionConfig = jsonWebServiceActionConfig;
        }
        if (_log.isDebugEnabled()) {
            if (matchedJSONWebServiceActionConfig == null) {
                _log.debug((Object)("Unable to match parameters to a JSON web service action with path " + path + " for " + contextName));
            } else {
                _log.debug((Object)("Matched parameters to a JSON web service action with path " + path + " for " + contextName));
            }
        }
        return matchedJSONWebServiceActionConfig;
    }

    private int _getParameterPathIndex(String path) {
        int index = path.indexOf(47, 1);
        if (index != -1) {
            index = path.indexOf(47, index + 1);
        }
        return index;
    }

    private boolean _removeJSONWebServiceActionConfig(JSONWebServiceActionConfig jsonWebServiceActionConfig) {
        if (!this._signatureIndexedJSONWebServiceActionConfigs.remove(jsonWebServiceActionConfig.getSignature(), jsonWebServiceActionConfig)) {
            return false;
        }
        String contextName = jsonWebServiceActionConfig.getContextName();
        List<JSONWebServiceActionConfig> jsonWebServiceActionConfigs = this._contextNameIndexedJSONWebServiceActionConfigs.get(contextName);
        jsonWebServiceActionConfigs.remove(jsonWebServiceActionConfig);
        if (jsonWebServiceActionConfigs.isEmpty()) {
            this._contextNameIndexedJSONWebServiceActionConfigs.remove(contextName);
        }
        jsonWebServiceActionConfigs = this._pathIndexedJSONWebServiceActionConfigs.get(jsonWebServiceActionConfig.getPath());
        jsonWebServiceActionConfigs.remove(jsonWebServiceActionConfig);
        if (jsonWebServiceActionConfigs.isEmpty()) {
            this._pathIndexedJSONWebServiceActionConfigs.remove(jsonWebServiceActionConfig.getPath());
        }
        return true;
    }

    private String[] _resolvePaths(HttpServletRequest request, String path) {
        ServletContext servletContext;
        String contextName = null;
        int index = path.indexOf(47, 1);
        if (index != -1 && (index = path.lastIndexOf(46, index)) != -1) {
            contextName = path.substring(1, index);
        }
        if (contextName == null && Validator.isNotNull((String)(contextName = (servletContext = request.getServletContext()).getServletContextName()))) {
            path = "/".concat(contextName).concat(".").concat(path.substring(1));
        }
        return new String[]{contextName, path};
    }
}

