/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONValidator;

public class JSONValidatorImpl
implements JSONValidator {
    private final JsonSchema _jsonSchema;

    public JSONValidatorImpl(String json) throws JSONException {
        try {
            JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.byDefault();
            JsonNode jsonNode = JsonLoader.fromString((String)json);
            this._jsonSchema = jsonSchemaFactory.getJsonSchema(jsonNode);
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }

    public boolean isValid(String json) throws JSONException {
        try {
            JsonNode jsonNode = JsonLoader.fromString((String)json);
            ProcessingReport processingReport = this._jsonSchema.validate(jsonNode);
            return processingReport.isSuccess();
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }
}

