/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json;

import com.liferay.portal.json.JSONArrayImpl;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Writer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class JSONObjectImpl
implements JSONObject {
    private static final String _NULL_JSON = "{}";
    private static final Log _log = LogFactoryUtil.getLog(JSONObjectImpl.class);
    private org.json.JSONObject _jsonObject;

    public JSONObjectImpl() {
        this._jsonObject = new org.json.JSONObject();
    }

    public JSONObjectImpl(JSONObject jsonObject, String[] names) throws JSONException {
        try {
            JSONObjectImpl jsonObjectImpl = (JSONObjectImpl)jsonObject;
            this._jsonObject = new org.json.JSONObject(jsonObjectImpl.getJSONObject(), names);
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }

    public JSONObjectImpl(Map<?, ?> map) {
        this._jsonObject = new org.json.JSONObject(map);
    }

    public JSONObjectImpl(Object bean) {
        this._jsonObject = new org.json.JSONObject(bean);
    }

    public JSONObjectImpl(Object obj, String[] names) {
        this._jsonObject = new org.json.JSONObject(obj, names);
    }

    public JSONObjectImpl(org.json.JSONObject jsonObject) {
        this._jsonObject = jsonObject;
    }

    public JSONObjectImpl(String json) throws JSONException {
        try {
            if (Validator.isNull((String)json)) {
                json = _NULL_JSON;
            }
            this._jsonObject = new org.json.JSONObject(json);
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }

    public Object get(String key) {
        return this._jsonObject.opt(key);
    }

    public boolean getBoolean(String key) {
        return this._jsonObject.optBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this._jsonObject.optBoolean(key, defaultValue);
    }

    public double getDouble(String key) {
        return this._jsonObject.optDouble(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this._jsonObject.optDouble(key, defaultValue);
    }

    public int getInt(String key) {
        return this._jsonObject.optInt(key);
    }

    public int getInt(String key, int defaultValue) {
        return this._jsonObject.optInt(key, defaultValue);
    }

    public JSONArray getJSONArray(String key) {
        org.json.JSONArray jsonArray = this._jsonObject.optJSONArray(key);
        if (jsonArray == null) {
            return null;
        }
        return new JSONArrayImpl(jsonArray);
    }

    public org.json.JSONObject getJSONObject() {
        return this._jsonObject;
    }

    public JSONObject getJSONObject(String key) {
        org.json.JSONObject jsonObject = this._jsonObject.optJSONObject(key);
        if (jsonObject == null) {
            return null;
        }
        return new JSONObjectImpl(jsonObject);
    }

    public long getLong(String key) {
        return this._jsonObject.optLong(key);
    }

    public long getLong(String key, long defaultValue) {
        return this._jsonObject.optLong(key, defaultValue);
    }

    public String getString(String key) {
        return this._jsonObject.optString(key);
    }

    public String getString(String key, String defaultValue) {
        return this._jsonObject.optString(key, defaultValue);
    }

    public boolean has(String key) {
        return this._jsonObject.has(key);
    }

    public boolean isNull(String key) {
        return this._jsonObject.isNull(key);
    }

    public Iterator<String> keys() {
        return this._jsonObject.keys();
    }

    public int length() {
        return this._jsonObject.length();
    }

    public JSONArray names() {
        return new JSONArrayImpl(this._jsonObject.names());
    }

    public JSONObject put(String key, boolean value) {
        block2: {
            try {
                this._jsonObject.put(key, value);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, Date value) {
        block2: {
            try {
                this._jsonObject.put(key, (Object)value);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, double value) {
        block2: {
            try {
                this._jsonObject.put(key, value);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, int value) {
        block2: {
            try {
                this._jsonObject.put(key, value);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, JSONArray value) {
        block2: {
            try {
                this._jsonObject.put(key, (Object)((JSONArrayImpl)value).getJSONArray());
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, JSONObject value) {
        block2: {
            try {
                this._jsonObject.put(key, (Object)((JSONObjectImpl)value).getJSONObject());
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, long value) {
        block2: {
            try {
                this._jsonObject.put(key, (Object)String.valueOf(value));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, Object value) {
        block6: {
            try {
                if (value instanceof JSONArray) {
                    this.put(key, (JSONArray)value);
                } else if (value instanceof JSONObject) {
                    this.put(key, (JSONObject)value);
                } else {
                    this._jsonObject.put(key, value);
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject put(String key, String value) {
        block2: {
            try {
                this._jsonObject.put(key, (Object)value);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public JSONObject putException(Exception exception) {
        block2: {
            try {
                this._jsonObject.put("exception", (Object)(exception.getClass() + ":" + exception.getMessage()));
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2, (Throwable)e2);
            }
        }
        return this;
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        try {
            this._jsonObject = new org.json.JSONObject(objectInput.readUTF());
        }
        catch (Exception e2) {
            throw new IOException(e2);
        }
    }

    public Object remove(String key) {
        return this._jsonObject.remove(key);
    }

    public String toJSONString() {
        return this.toString();
    }

    public String toString() {
        return this._jsonObject.toString();
    }

    public String toString(int indentFactor) throws JSONException {
        try {
            return this._jsonObject.toString(indentFactor);
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }

    public Writer write(Writer writer) throws JSONException {
        try {
            return this._jsonObject.write(writer);
        }
        catch (Exception e2) {
            throw new JSONException((Throwable)e2);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.toString());
    }
}

