/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.image;

import com.liferay.portal.image.ImageMagickImpl;
import com.liferay.portal.kernel.concurrent.FutureConverter;
import com.liferay.portal.kernel.exception.ImageResolutionException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageMagick;
import com.liferay.portal.kernel.image.ImageTool;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import net.jmge.gif.Gif89Encoder;
import org.im4java.core.IMOperation;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;

@DoPrivileged
public class ImageToolImpl
implements ImageTool {
    private static final Log _log = LogFactoryUtil.getLog(ImageToolImpl.class);
    private static final ImageTool _instance = new ImageToolImpl();
    private static final FileImpl _fileUtil = FileImpl.getInstance();
    private static ImageMagick _imageMagick;
    private com.liferay.portal.kernel.model.Image _defaultCompanyLogo;
    private com.liferay.portal.kernel.model.Image _defaultOrganizationLogo;
    private com.liferay.portal.kernel.model.Image _defaultSpacer;
    private com.liferay.portal.kernel.model.Image _defaultUserFemalePortrait;
    private com.liferay.portal.kernel.model.Image _defaultUserMalePortrait;

    public static ImageTool getInstance() {
        return _instance;
    }

    public void afterPropertiesSet() {
        InputStream is;
        InputStream inputStream;
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try {
            inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.spacer"));
            if (inputStream == null) {
                _log.error((Object)"Default spacer is not available");
            }
            this._defaultSpacer = this.getImage(inputStream);
        }
        catch (Exception e2) {
            _log.error((Object)("Unable to configure the default spacer: " + e2.getMessage()));
        }
        try {
            inputStream = null;
            String imageDefaultCompanyLogo = PropsUtil.get("image.default.company.logo");
            int index = imageDefaultCompanyLogo.indexOf(59);
            if (index == -1) {
                inputStream = classLoader.getResourceAsStream(PropsUtil.get("image.default.company.logo"));
            } else {
                String bundleIdString = imageDefaultCompanyLogo.substring(0, index);
                int bundleId = GetterUtil.getInteger((String)bundleIdString, (int)-1);
                String name = imageDefaultCompanyLogo.substring(index + 1);
                if (bundleId < 0) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Fallback to portal class loader because of invalid bundle ID " + bundleIdString));
                    }
                    inputStream = classLoader.getResourceAsStream(name);
                } else {
                    URL url = ModuleFrameworkUtilAdapter.getBundleResource(bundleId, name);
                    inputStream = url.openStream();
                }
            }
            if (inputStream == null) {
                _log.error((Object)"Default company logo is not available");
            }
            this._defaultCompanyLogo = this.getImage(inputStream);
        }
        catch (Exception e3) {
            _log.error((Object)("Unable to configure the default company logo: " + e3.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.organization.logo"));
            if (is == null) {
                _log.error((Object)"Default organization logo is not available");
            }
            this._defaultOrganizationLogo = this.getImage(is);
        }
        catch (Exception e4) {
            _log.error((Object)("Unable to configure the default organization logo: " + e4.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.female.portrait"));
            if (is == null) {
                _log.error((Object)"Default user female portrait is not available");
            }
            this._defaultUserFemalePortrait = this.getImage(is);
        }
        catch (Exception e5) {
            _log.error((Object)("Unable to configure the default user female portrait: " + e5.getMessage()));
        }
        try {
            is = classLoader.getResourceAsStream(PropsUtil.get("image.default.user.male.portrait"));
            if (is == null) {
                _log.error((Object)"Default user male portrait is not available");
            }
            this._defaultUserMalePortrait = this.getImage(is);
        }
        catch (Exception e6) {
            _log.error((Object)("Unable to configure the default user male portrait: " + e6.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<RenderedImage> convertCMYKtoRGB(byte[] bytes, final String type) {
        ImageMagick imageMagick = this.getImageMagick();
        if (!imageMagick.isEnabled()) {
            return null;
        }
        File inputFile = _fileUtil.createTempFile(type);
        final File outputFile = _fileUtil.createTempFile(type);
        try {
            _fileUtil.write(inputFile, bytes);
            IMOperation imOperation = new IMOperation();
            imOperation.addRawArgs(new String[]{"-format", "%[colorspace]"});
            imOperation.addImage(new String[]{inputFile.getPath()});
            String[] output = imageMagick.identify((List)imOperation.getCmdArgs());
            if (output.length == 1 && StringUtil.equalsIgnoreCase((String)output[0], (String)"CMYK")) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The image is in the CMYK colorspace");
                }
                imOperation = new IMOperation();
                imOperation.addRawArgs(new String[]{"-colorspace", "RGB"});
                imOperation.addImage(new String[]{inputFile.getPath()});
                imOperation.addImage(new String[]{outputFile.getPath()});
                Future future = imageMagick.convert((List)imOperation.getCmdArgs());
                FutureConverter<RenderedImage, Object> futureConverter = new FutureConverter<RenderedImage, Object>(future){

                    protected RenderedImage convert(Object obj) {
                        RenderedImage renderedImage;
                        block2: {
                            renderedImage = null;
                            try {
                                ImageBag imageBag = ImageToolImpl.this.read(_fileUtil.getBytes(outputFile));
                                renderedImage = imageBag.getRenderedImage();
                            }
                            catch (ImageResolutionException | IOException e2) {
                                if (!_log.isDebugEnabled()) break block2;
                                _log.debug((Object)("Unable to convert " + type), e2);
                            }
                        }
                        return renderedImage;
                    }
                };
                return futureConverter;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        finally {
            _fileUtil.delete(inputFile);
            _fileUtil.delete(outputFile);
        }
        return null;
    }

    public BufferedImage convertImageType(BufferedImage sourceImage, int type) {
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), type);
        Graphics2D graphics = targetImage.createGraphics();
        graphics.drawRenderedImage(sourceImage, null);
        graphics.dispose();
        return targetImage;
    }

    public RenderedImage crop(RenderedImage renderedImage, int height, int width, int x, int y) {
        Rectangle rectangle = new Rectangle(x, y, width, height);
        Rectangle croppedRectangle = rectangle.intersection(new Rectangle(renderedImage.getWidth(), renderedImage.getHeight()));
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        return bufferedImage.getSubimage(croppedRectangle.x, croppedRectangle.y, croppedRectangle.width, croppedRectangle.height);
    }

    public void encodeGIF(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        if (!(bufferedImage.getColorModel() instanceof IndexColorModel)) {
            bufferedImage = this.convertImageType(bufferedImage, 13);
        }
        Gif89Encoder encoder = new Gif89Encoder((Image)bufferedImage);
        encoder.encode(os);
    }

    public void encodeWBMP(RenderedImage renderedImage, OutputStream os) throws IOException {
        BufferedImage bufferedImage = this.getBufferedImage(renderedImage);
        SampleModel sampleModel = bufferedImage.getSampleModel();
        int type = sampleModel.getDataType();
        if (bufferedImage.getType() != 12 || type < 0 || type > 3 || sampleModel.getNumBands() != 1 || sampleModel.getSampleSize(0) != 1) {
            BufferedImage binaryImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
            Graphics graphics = binaryImage.getGraphics();
            graphics.drawImage(bufferedImage, 0, 0, null);
            renderedImage = binaryImage;
        }
        if (!ImageIO.write(renderedImage, "wbmp", os)) {
            os.write(0);
            os.write(0);
            os.write(this.toMultiByte(bufferedImage.getWidth()));
            os.write(this.toMultiByte(bufferedImage.getHeight()));
            DataBuffer dataBuffer = bufferedImage.getData().getDataBuffer();
            int size = dataBuffer.getSize();
            for (int i = 0; i < size; ++i) {
                os.write((byte)dataBuffer.getElem(i));
            }
        }
    }

    public BufferedImage getBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        Hashtable<Object, Object> properties = new Hashtable<Object, Object>();
        Object[] keys = renderedImage.getPropertyNames();
        if (!ArrayUtil.isEmpty((Object[])keys)) {
            for (Object key : keys) {
                properties.put(key, renderedImage.getProperty((String)key));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), properties);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public byte[] getBytes(RenderedImage renderedImage, String contentType) throws IOException {
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        this.write(renderedImage, contentType, (OutputStream)baos);
        return baos.toByteArray();
    }

    public com.liferay.portal.kernel.model.Image getDefaultCompanyLogo() {
        return this._defaultCompanyLogo;
    }

    public com.liferay.portal.kernel.model.Image getDefaultOrganizationLogo() {
        return this._defaultOrganizationLogo;
    }

    public com.liferay.portal.kernel.model.Image getDefaultSpacer() {
        return this._defaultSpacer;
    }

    public com.liferay.portal.kernel.model.Image getDefaultUserFemalePortrait() {
        return this._defaultUserFemalePortrait;
    }

    public com.liferay.portal.kernel.model.Image getDefaultUserMalePortrait() {
        return this._defaultUserMalePortrait;
    }

    public com.liferay.portal.kernel.model.Image getImage(byte[] bytes) throws ImageResolutionException, IOException {
        if (bytes == null) {
            return null;
        }
        ImageBag imageBag = this.read(bytes);
        RenderedImage renderedImage = imageBag.getRenderedImage();
        if (renderedImage == null) {
            throw new IOException("Unable to decode image");
        }
        String type = imageBag.getType();
        int height = renderedImage.getHeight();
        int width = renderedImage.getWidth();
        int size = bytes.length;
        ImageImpl image = new ImageImpl();
        image.setTextObj(bytes);
        image.setType(type);
        image.setHeight(height);
        image.setWidth(width);
        image.setSize(size);
        return image;
    }

    public com.liferay.portal.kernel.model.Image getImage(File file) throws ImageResolutionException, IOException {
        byte[] bytes = _fileUtil.getBytes(file);
        return this.getImage(bytes);
    }

    public com.liferay.portal.kernel.model.Image getImage(InputStream is) throws ImageResolutionException, IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, true);
        return this.getImage(bytes);
    }

    public com.liferay.portal.kernel.model.Image getImage(InputStream is, boolean cleanUpStream) throws ImageResolutionException, IOException {
        byte[] bytes = _fileUtil.getBytes(is, -1, cleanUpStream);
        return this.getImage(bytes);
    }

    public boolean isNullOrDefaultSpacer(byte[] bytes) {
        return ArrayUtil.isEmpty((byte[])bytes) || Arrays.equals(bytes, this.getDefaultSpacer().getTextObj());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageBag read(byte[] bytes) throws ImageResolutionException, IOException {
        String formatName = null;
        ImageInputStream imageInputStream = null;
        LinkedList<ImageReader> imageReaders = new LinkedList<ImageReader>();
        BufferedImage renderedImage = null;
        try {
            imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            while (renderedImage == null && iterator.hasNext()) {
                ImageReader imageReader = iterator.next();
                imageReaders.offer(imageReader);
                try {
                    imageReader.setInput(imageInputStream);
                    int height = imageReader.getHeight(0);
                    int width = imageReader.getWidth(0);
                    if ((long)height > PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT || (long)width > PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH) {
                        StringBundler sb = new StringBundler(9);
                        sb.append("Image's dimensions (");
                        sb.append(height);
                        sb.append(" px high and ");
                        sb.append(width);
                        sb.append(" px wide) exceed max dimensions (");
                        sb.append(PropsValues.IMAGE_TOOL_IMAGE_MAX_HEIGHT);
                        sb.append(" px high and ");
                        sb.append(PropsValues.IMAGE_TOOL_IMAGE_MAX_WIDTH);
                        sb.append(" px wide)");
                        throw new ImageResolutionException(sb.toString());
                    }
                    renderedImage = imageReader.read(0);
                }
                catch (IOException ioe) {
                    continue;
                }
                formatName = StringUtil.toLowerCase((String)imageReader.getFormatName());
            }
            if (renderedImage == null) {
                throw new IOException("Unsupported image type");
            }
        }
        finally {
            while (!imageReaders.isEmpty()) {
                ImageReader imageReader = (ImageReader)imageReaders.poll();
                imageReader.dispose();
            }
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        String type = "jpg";
        if (formatName.contains("bmp")) {
            type = "bmp";
        } else if (formatName.contains("gif")) {
            type = "gif";
        } else if (formatName.contains("jpeg") || StringUtil.equalsIgnoreCase((String)type, (String)"jpeg")) {
            type = "jpg";
        } else if (formatName.contains("png")) {
            type = "png";
        } else if (formatName.contains("tiff")) {
            type = "tiff";
        } else {
            throw new IllegalArgumentException(type + " is not supported");
        }
        return new ImageBag(renderedImage, type);
    }

    public ImageBag read(File file) throws ImageResolutionException, IOException {
        return this.read(_fileUtil.getBytes(file));
    }

    public ImageBag read(InputStream inputStream) throws ImageResolutionException, IOException {
        return this.read(_fileUtil.getBytes(inputStream));
    }

    public RenderedImage scale(RenderedImage renderedImage, int width) {
        if (width <= 0) {
            return renderedImage;
        }
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        double factor = (double)width / (double)imageWidth;
        int scaledHeight = (int)Math.round(factor * (double)imageHeight);
        int scaledWidth = width;
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public RenderedImage scale(RenderedImage renderedImage, int maxHeight, int maxWidth) {
        int imageHeight = renderedImage.getHeight();
        int imageWidth = renderedImage.getWidth();
        if (maxHeight == 0) {
            maxHeight = imageHeight;
        }
        if (maxWidth == 0) {
            maxWidth = imageWidth;
        }
        if (imageHeight <= maxHeight && imageWidth <= maxWidth) {
            return renderedImage;
        }
        double factor = Math.min((double)maxHeight / (double)imageHeight, (double)maxWidth / (double)imageWidth);
        int scaledHeight = Math.max(1, (int)Math.round(factor * (double)imageHeight));
        int scaledWidth = Math.max(1, (int)Math.round(factor * (double)imageWidth));
        return this.doScale(renderedImage, scaledHeight, scaledWidth);
    }

    public void write(RenderedImage renderedImage, String contentType, OutputStream os) throws IOException {
        if (contentType.contains("bmp")) {
            ImageIO.write(renderedImage, "bmp", os);
        } else if (contentType.contains("gif")) {
            this.encodeGIF(renderedImage, os);
        } else if (contentType.contains("jpg") || contentType.contains("jpeg")) {
            ImageIO.write(renderedImage, "jpeg", os);
        } else if (contentType.contains("png")) {
            ImageIO.write(renderedImage, "png", os);
        } else if (contentType.contains("tiff") || contentType.contains("tif")) {
            ImageIO.write(renderedImage, "tiff", os);
        }
    }

    protected RenderedImage doScale(RenderedImage renderedImage, int scaledHeight, int scaledWidth) {
        BufferedImage originalBufferedImage = this.getBufferedImage(renderedImage);
        ColorModel originalColorModel = originalBufferedImage.getColorModel();
        ColorSpace colorSpace = originalColorModel.getColorSpace();
        BufferedImage scaledBufferedImage = new BufferedImage(scaledWidth, scaledHeight, colorSpace.getType());
        Graphics2D scaledGraphics2D = scaledBufferedImage.createGraphics();
        if (originalColorModel.hasAlpha()) {
            scaledGraphics2D.setComposite(AlphaComposite.Src);
        }
        scaledGraphics2D.drawImage(originalBufferedImage, 0, 0, scaledWidth, scaledHeight, null);
        scaledGraphics2D.dispose();
        return scaledBufferedImage;
    }

    protected ImageMagick getImageMagick() {
        if (_imageMagick == null) {
            _imageMagick = ImageMagickImpl.getInstance();
            _imageMagick.reset();
        }
        return _imageMagick;
    }

    protected void orderImageReaderSpis() {
        IIORegistry defaultIIORegistry = IIORegistry.getDefaultInstance();
        ImageReaderSpi firstImageReaderSpi = null;
        ImageReaderSpi secondImageReaderSpi = null;
        Iterator<ImageReaderSpi> imageReaderSpis = defaultIIORegistry.getServiceProviders(ImageReaderSpi.class, true);
        while (imageReaderSpis.hasNext()) {
            ImageReaderSpi imageReaderSpi = imageReaderSpis.next();
            if (imageReaderSpi instanceof CMYKJPEGImageReaderSpi) {
                secondImageReaderSpi = imageReaderSpi;
                continue;
            }
            String[] formatNames = imageReaderSpi.getFormatNames();
            if (!ArrayUtil.contains((String[])formatNames, (String)"jpg", (boolean)true) && !ArrayUtil.contains((String[])formatNames, (String)"jpeg", (boolean)true)) continue;
            firstImageReaderSpi = imageReaderSpi;
        }
        if (firstImageReaderSpi != null && secondImageReaderSpi != null) {
            defaultIIORegistry.setOrdering(ImageReaderSpi.class, firstImageReaderSpi, secondImageReaderSpi);
        }
    }

    protected byte[] toMultiByte(int intValue) {
        int numBits = 32;
        for (int mask = Integer.MIN_VALUE; mask != 0 && (intValue & mask) == 0; mask >>>= 1) {
            --numBits;
        }
        int numBitsLeft = numBits;
        byte[] multiBytes = new byte[(numBitsLeft + 6) / 7];
        int maxIndex = multiBytes.length - 1;
        for (int b2 = 0; b2 <= maxIndex; ++b2) {
            multiBytes[b2] = (byte)(intValue >>> (maxIndex - b2) * 7 & 0x7F);
            if (b2 == maxIndex) continue;
            int n = b2;
            multiBytes[n] = (byte)(multiBytes[n] | 0xFFFFFF80);
        }
        return multiBytes;
    }

    private ImageToolImpl() {
        ImageIO.setUseCache(PropsValues.IMAGE_IO_USE_DISK_CACHE);
        this.orderImageReaderSpis();
    }
}

