/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecureRequestAction
extends Action {
    private static final boolean _REQUIRES_SECURE = true;
    private static final Log _log = LogFactoryUtil.getLog(SecureRequestAction.class);

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            if (request.isSecure()) {
                return;
            }
            if (!this.isRequiresSecure(request)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
            String redirect = this.getRedirect(request);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Redirect " + redirect));
            }
            if (redirect != null) {
                response.sendRedirect(redirect);
            }
        }
        catch (Exception e2) {
            throw new ActionException((Throwable)e2);
        }
    }

    protected String getRedirect(HttpServletRequest request) {
        String unsecureCompleteURL = PortalUtil.getCurrentCompleteURL((HttpServletRequest)request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Unsecure URL " + unsecureCompleteURL));
        }
        String secureCompleteURL = StringUtil.replaceFirst((String)unsecureCompleteURL, (String)"http://", (String)"https://");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Secure URL " + secureCompleteURL));
        }
        if (unsecureCompleteURL.equals(secureCompleteURL)) {
            return null;
        }
        return secureCompleteURL;
    }

    protected boolean isRequiresSecure(HttpServletRequest request) {
        return true;
    }
}

