/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy.hot;

import com.liferay.portal.deploy.hot.ServiceBag;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManagerUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.lang.reflect.Method;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;

public class ServiceWrapperRegistry {
    private static final Log _log = LogFactoryUtil.getLog(ServiceWrapperRegistry.class);
    private final ServiceTracker<ServiceWrapper<?>, ServiceBag<?>> _serviceTracker;

    public ServiceWrapperRegistry() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(ServiceWrapper.class.getName(), (ServiceTrackerCustomizer)new ServiceWrapperServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void close() {
        this._serviceTracker.close();
    }

    private static class ServiceWrapperServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ServiceWrapper<?>, ServiceBag<?>> {
        private ServiceWrapperServiceTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceBag<?> addingService(ServiceReference<ServiceWrapper<?>> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            ServiceWrapper serviceWrapper = (ServiceWrapper)registry.getService(serviceReference);
            try {
                ServiceBag<?> serviceBag = this._getServiceBag(serviceWrapper);
                return serviceBag;
            }
            catch (Throwable t) {
                _log.error((Object)t, t);
            }
            finally {
                ServiceBeanAopCacheManagerUtil.reset();
            }
            return null;
        }

        public void modifiedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceHolder) {
        }

        public void removedService(ServiceReference<ServiceWrapper<?>> serviceReference, ServiceBag<?> serviceBag) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            try {
                serviceBag.replace();
                ServiceBeanAopCacheManagerUtil.reset();
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }

        protected Object getServiceProxy(Class<?> serviceTypeClass) {
            Object service = null;
            try {
                service = PortalBeanLocatorUtil.locate((String)serviceTypeClass.getName());
            }
            catch (BeanLocatorException ble) {
                Registry registry = RegistryUtil.getRegistry();
                service = registry.getService(serviceTypeClass);
            }
            return service;
        }

        private <T> ServiceBag<?> _getServiceBag(ServiceWrapper<T> serviceWrapper) throws Throwable {
            Class<?> clazz = serviceWrapper.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            Method method = clazz.getMethod("getWrappedService", new Class[0]);
            Class<?> serviceTypeClass = method.getReturnType();
            Object serviceProxy = this.getServiceProxy(serviceTypeClass);
            if (!ProxyUtil.isProxyClass(serviceProxy.getClass())) {
                _log.error((Object)"Service hooks require Spring to be configured to use JdkDynamicProxy and will not work with CGLIB");
                return null;
            }
            AdvisedSupport advisedSupport = ServiceBeanAopProxy.getAdvisedSupport(serviceProxy);
            TargetSource targetSource = advisedSupport.getTargetSource();
            serviceWrapper.setWrappedService(targetSource.getTarget());
            return new ServiceBag<T>(classLoader, advisedSupport, serviceTypeClass, serviceWrapper);
        }
    }
}

