/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.deploy;

import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.events.GlobalStartupAction;
import com.liferay.portal.kernel.deploy.DeployManager;
import com.liferay.portal.kernel.deploy.auto.AutoDeployDir;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.RequiredPluginPackageException;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@DoPrivileged
public class DeployManagerImpl
implements DeployManager {
    private static final Log _log = LogFactoryUtil.getLog(DeployManagerImpl.class);
    private final List<String[]> _levelsRequiredDeploymentContexts = new ArrayList<String[]>();
    private final List<String[]> _levelsRequiredDeploymentWARFileNames = new ArrayList<String[]>();

    public DeployManagerImpl() {
        for (int i = 1; i < 9; ++i) {
            String levelRequiredDeploymentWARFileNamesString = "";
            try {
                Class<?> clazz = this.getClass();
                InputStream inputStream = clazz.getResourceAsStream("dependencies/plugins" + i + "/wars.txt");
                if (inputStream == null) {
                    return;
                }
                levelRequiredDeploymentWARFileNamesString = StringUtil.read((InputStream)inputStream);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Level " + i + " required deployment WAR file names " + levelRequiredDeploymentWARFileNamesString));
            }
            String[] levelRequiredDeploymentWARFileNames = StringUtil.split((String)levelRequiredDeploymentWARFileNamesString);
            this._levelsRequiredDeploymentWARFileNames.add(levelRequiredDeploymentWARFileNames);
            Object[] levelRequiredDeploymentContexts = new String[levelRequiredDeploymentWARFileNames.length];
            this._levelsRequiredDeploymentContexts.add((String[])levelRequiredDeploymentContexts);
            for (int j = 0; j < levelRequiredDeploymentWARFileNames.length; ++j) {
                String warFileName = levelRequiredDeploymentWARFileNames[j];
                Version version = Version.getInstance((String)ReleaseInfo.getVersion());
                StringBundler sb = new StringBundler(4);
                sb.append("-");
                sb.append(version.getMajor());
                sb.append(".");
                sb.append(version.getMinor());
                int index = warFileName.indexOf(sb.toString());
                levelRequiredDeploymentContexts[j] = warFileName.substring(0, index);
            }
            if (!_log.isDebugEnabled()) continue;
            _log.debug((Object)("Level " + i + " required deployment contexts " + StringUtil.merge((Object[])levelRequiredDeploymentContexts)));
        }
    }

    public void deploy(AutoDeploymentContext autoDeploymentContext) throws Exception {
        AutoDeployDir.deploy((AutoDeploymentContext)autoDeploymentContext, GlobalStartupAction.getAutoDeployListeners(false));
    }

    public String getDeployDir() throws Exception {
        return DeployUtil.getAutoDeployDestDir();
    }

    public String getInstalledDir() throws Exception {
        if (ServerDetector.isGlassfish()) {
            File file = new File(System.getProperty("com.sun.aas.instanceRoot"), "autodeploy");
            return file.getAbsolutePath();
        }
        return DeployUtil.getAutoDeployDestDir();
    }

    public PluginPackage getInstalledPluginPackage(String context) {
        return PluginPackageUtil.getInstalledPluginPackage(context);
    }

    public List<PluginPackage> getInstalledPluginPackages() {
        return PluginPackageUtil.getInstalledPluginPackages();
    }

    public List<String[]> getLevelsRequiredDeploymentContexts() {
        return this._levelsRequiredDeploymentContexts;
    }

    public List<String[]> getLevelsRequiredDeploymentWARFileNames() {
        return this._levelsRequiredDeploymentWARFileNames;
    }

    public boolean isDeployed(String context) {
        return PluginPackageUtil.isInstalled(context);
    }

    public boolean isRequiredDeploymentContext(String context) {
        for (Object[] objectArray : this._levelsRequiredDeploymentContexts) {
            if (!ArrayUtil.contains((Object[])objectArray, (Object)context)) continue;
            return true;
        }
        return false;
    }

    public PluginPackage readPluginPackageProperties(String displayName, Properties properties) {
        return PluginPackageUtil.readPluginPackageProperties(displayName, properties);
    }

    public PluginPackage readPluginPackageXml(String xml) throws Exception {
        return PluginPackageUtil.readPluginPackageXml(xml);
    }

    public void redeploy(String context) throws Exception {
        if (ServerDetector.isJetty()) {
            DeployUtil.redeployJetty(context);
        } else if (ServerDetector.isTomcat()) {
            DeployUtil.redeployTomcat(context);
        }
    }

    public void undeploy(String context) throws Exception {
        if (this.isRequiredDeploymentContext(context)) {
            RequiredPluginPackageException rppe = new RequiredPluginPackageException();
            rppe.setContext(context);
            throw rppe;
        }
        File deployDir = new File(this.getDeployDir(), context);
        DeployUtil.undeploy(ServerDetector.getServerId(), deployDir);
    }
}

