/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.util.HashSet;

public class SQLQueryTableNamesUtil {
    private static final PortalCache<String, String[]> _portalCache = SingleVMPoolUtil.getPortalCache((String)SQLQueryTableNamesUtil.class.getName());

    public static String[] getTableNames(String sql) {
        int[] indexes;
        String[] tableNames = (String[])_portalCache.get((Serializable)((Object)sql));
        if (tableNames != null) {
            return tableNames;
        }
        String lowerCaseSQL = StringUtil.toLowerCase((String)sql);
        HashSet<String> tableNameSet = new HashSet<String>();
        int index = 0;
        while ((index = lowerCaseSQL.indexOf(" from ", index)) != -1) {
            indexes = SQLQueryTableNamesUtil._getTableNameIndexes(lowerCaseSQL, index += 6);
            if (indexes == null) continue;
            tableNameSet.add(sql.substring(indexes[0], indexes[1]));
        }
        index = 0;
        while ((index = lowerCaseSQL.indexOf(" join ", index)) != -1) {
            indexes = SQLQueryTableNamesUtil._getTableNameIndexes(lowerCaseSQL, index += 6);
            if (indexes == null) continue;
            tableNameSet.add(sql.substring(indexes[0], indexes[1]));
        }
        tableNames = tableNameSet.toArray(new String[tableNameSet.size()]);
        _portalCache.put((Serializable)((Object)sql), (Object)tableNames);
        return tableNames;
    }

    private static int[] _getTableNameIndexes(String sql, int index) {
        char c2;
        int start = -1;
        int end = sql.length();
        for (int i = index; i < sql.length() && (c2 = sql.charAt(i)) != '('; ++i) {
            if (c2 == ' ' || c2 == ')') {
                if (start == -1) continue;
                end = i;
                break;
            }
            if (start != -1) continue;
            start = i;
        }
        if (start == -1) {
            return null;
        }
        return new int[]{start, end};
    }
}

