/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate;

import com.liferay.portal.dao.orm.hibernate.SessionFactoryImpl;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.lang.DoPrivilegedUtil;
import com.liferay.portal.spring.hibernate.PortletHibernateConfiguration;
import com.liferay.portal.util.PropsValues;
import java.sql.Connection;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.impl.SessionImpl;

public class PortletSessionFactoryImpl
extends SessionFactoryImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletSessionFactoryImpl.class);
    private DataSource _dataSource;

    @Override
    public void closeSession(Session session) throws ORMException {
        if (session != null) {
            session.flush();
            if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) {
                session.close();
            }
        }
    }

    @Override
    public Session openSession() throws ORMException {
        Connection connection;
        SessionFactory sessionFactory = this.getSessionFactory();
        org.hibernate.classic.Session session = null;
        session = PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED ? ((connection = CurrentConnectionUtil.getConnection((DataSource)this.getDataSource())) == null ? sessionFactory.getCurrentSession() : sessionFactory.openSession(connection)) : sessionFactory.openSession();
        if (_log.isDebugEnabled()) {
            SessionImpl sessionImpl = (SessionImpl)session;
            _log.debug((Object)("Session is using connection release mode " + sessionImpl.getConnectionReleaseMode()));
        }
        return this.wrapSession((org.hibernate.Session)session);
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    protected SessionFactory createSessionFactory(DataSource dataSource) {
        PortletHibernateConfiguration portletHibernateConfiguration = new PortletHibernateConfiguration(this.getSessionFactoryClassLoader(), dataSource);
        portletHibernateConfiguration.setDataSource(dataSource);
        SessionFactory sessionFactory = null;
        try {
            sessionFactory = portletHibernateConfiguration.buildSessionFactory();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            return null;
        }
        return sessionFactory;
    }

    protected DataSource getDataSource() {
        return this._dataSource;
    }

    protected SessionFactory getSessionFactory() {
        return this.getSessionFactoryImplementor();
    }

    @Override
    protected Session wrapSession(org.hibernate.Session session) {
        return DoPrivilegedUtil.wrapWhenActive(super.wrapSession(session));
    }
}

