/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.db;

import com.liferay.portal.dao.db.BaseDB;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.db.Index;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class MySQLDB
extends BaseDB {
    private static final String[] _MYSQL = new String[]{"##", "1", "0", "'1970-01-01'", "now()", " longblob", " longblob", " tinyint", " datetime", " double", " integer", " bigint", " longtext", " longtext", " varchar", "  auto_increment", "commit"};
    private static final boolean _SUPPORTS_UPDATE_WITH_INNER_JOIN = true;

    public MySQLDB(int majorVersion, int minorVersion) {
        super(DBType.MYSQL, majorVersion, minorVersion);
    }

    @Override
    public String buildSQL(String template) throws IOException {
        template = this.convertTimestamp(template);
        template = this.replaceTemplate(template, this.getTemplate());
        template = this.reword(template);
        template = StringUtil.replace((String)template, (String)"\\'", (String)"''");
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Index> getIndexes(Connection con) throws SQLException {
        ArrayList<Index> indexes = new ArrayList<Index>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            StringBundler sb = new StringBundler(4);
            sb.append("select distinct(index_name), table_name, non_unique ");
            sb.append("from information_schema.statistics where ");
            sb.append("index_schema = database() and (index_name like ");
            sb.append("'LIFERAY_%' or index_name like 'IX_%')");
            String sql = sb.toString();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            while (rs.next()) {
                String indexName = rs.getString("index_name");
                String tableName = rs.getString("table_name");
                boolean unique = !rs.getBoolean("non_unique");
                indexes.add(new Index(indexName, tableName, unique));
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps, (ResultSet)rs);
        return indexes;
    }

    @Override
    public boolean isSupportsUpdateWithInnerJoin() {
        return true;
    }

    @Override
    protected String buildCreateFileContent(String sqlDir, String databaseName, int population) throws IOException {
        StringBundler sb = new StringBundler(14);
        sb.append("drop database if exists ");
        sb.append(databaseName);
        sb.append(";\n");
        sb.append("create database ");
        sb.append(databaseName);
        sb.append(" character set utf8;\n");
        if (population != 0) {
            sb.append("use ");
            sb.append(databaseName);
            sb.append(";\n\n");
            String suffix = this.getSuffix(population);
            sb.append(this.getCreateTablesContent(sqlDir, suffix));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/indexes/indexes-mysql.sql"));
            sb.append("\n\n");
            sb.append(this.readFile(sqlDir + "/sequences/sequences-mysql.sql"));
        }
        return sb.toString();
    }

    @Override
    protected String getServerName() {
        return "mysql";
    }

    @Override
    protected String[] getTemplate() {
        if (GetterUtil.getFloat((String)this.getVersionString()) >= 5.6f) {
            MySQLDB._MYSQL[8] = " datetime(6)";
        }
        return _MYSQL;
    }

    @Override
    protected String reword(String data) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new UnsyncStringReader(data));){
            StringBundler sb = new StringBundler();
            boolean createTable = false;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (StringUtil.startsWith((String)line, (String)"create table")) {
                    createTable = true;
                } else if (line.startsWith("alter_column_name ")) {
                    String[] template = this.buildColumnNameTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ change column @old-column@ @new-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_column_type ")) {
                    String[] template = this.buildColumnTypeTokens(line);
                    line = StringUtil.replace((String)"alter table @table@ modify @old-column@ @type@;", (String[])REWORD_TEMPLATE, (String[])template);
                } else if (line.startsWith("alter_table_name ")) {
                    String[] template = this.buildTableNameTokens(line);
                    line = StringUtil.replace((String)"rename table @old-table@ to @new-table@;", (String[])RENAME_TABLE_TEMPLATE, (String[])template);
                }
                int pos = line.indexOf(";");
                if (createTable && pos != -1) {
                    createTable = false;
                    line = line.substring(0, pos) + " engine " + PropsValues.DATABASE_MYSQL_ENGINE + line.substring(pos);
                }
                sb.append(line);
                sb.append("\n");
            }
            String string = sb.toString();
            return string;
        }
    }
}

