/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.convert.util;

import com.liferay.portal.convert.util.ModelMigrator;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ServiceComponent;
import com.liferay.portal.kernel.service.ServiceComponentLocalServiceUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.upgrade.util.Table;
import com.liferay.portal.util.MaintenanceUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;

public class ModelMigratorImpl
implements ModelMigrator {
    private static final Log _log = LogFactoryUtil.getLog(ModelMigratorImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(DataSource dataSource, List<Class<? extends BaseModel<?>>> models) throws IOException, SQLException {
        Dialect dialect = DialectDetector.getDialect(dataSource);
        Connection connection = dataSource.getConnection();
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Migrating database tables");
            }
            HashMap<String, Tuple> modelTableDetails = new HashMap<String, Tuple>();
            for (Class<BaseModel<?>> clazz : models) {
                modelTableDetails.putAll(this.getModelTableDetails(clazz));
            }
            MaintenanceUtil.appendStatus("Processing " + modelTableDetails.size() + " models");
            this.migrateModel(modelTableDetails, DBManagerUtil.getDB((Object)dialect, (DataSource)dataSource), connection);
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    protected Map<String, Tuple> getModelTableDetails(Class<?> implClass) {
        Field[] fields;
        LinkedHashMap<String, Tuple> modelTableDetails = new LinkedHashMap<String, Tuple>();
        for (Field field : fields = implClass.getFields()) {
            Tuple tuple = null;
            String fieldName = field.getName();
            if (fieldName.equals("TABLE_NAME") || fieldName.startsWith("MAPPING_TABLE_") && fieldName.endsWith("_NAME")) {
                tuple = this.getTableDetails(implClass, field, fieldName);
            }
            if (tuple == null) continue;
            String table = (String)tuple.getObject(0);
            modelTableDetails.put(table, tuple);
        }
        return modelTableDetails;
    }

    protected Tuple getTableDetails(Class<?> implClass, Field tableField, String tableFieldVar) {
        try {
            String columnsFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_COLUMNS");
            String sqlCreateFieldVar = StringUtil.replace((String)tableFieldVar, (String)"_NAME", (String)"_SQL_CREATE");
            Field columnsField = implClass.getField(columnsFieldVar);
            Field sqlCreateField = implClass.getField(sqlCreateFieldVar);
            String table = (String)tableField.get("");
            Object[][] columns = (Object[][])columnsField.get(new Object[0][0]);
            String sqlCreate = (String)sqlCreateField.get("");
            return new Tuple(new Object[]{table, columns, sqlCreate});
        }
        catch (Exception e2) {
            return null;
        }
    }

    protected void migrateModel(Map<String, Tuple> modelTableDetails, DB db, Connection connection) throws IOException {
        MaintenanceUtil.appendStatus("<ul>");
        for (Tuple tuple : modelTableDetails.values()) {
            String table = (String)tuple.getObject(0);
            Object[][] columns = (Object[][])tuple.getObject(1);
            String sqlCreate = (String)tuple.getObject(2);
            MaintenanceUtil.appendStatus("<li>Migrating table " + table + "</li>");
            this.migrateTable(db, connection, table, columns, sqlCreate);
        }
        MaintenanceUtil.appendStatus("</ul>");
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Migrating database indexes");
        }
        StartupHelperUtil.updateIndexes(db, connection, false);
        List serviceComponents = ServiceComponentLocalServiceUtil.getLatestServiceComponents();
        HashSet validIndexNames = new HashSet();
        for (ServiceComponent serviceComponent : serviceComponents) {
            String indexesSQL = serviceComponent.getIndexesSQL();
            db.addIndexes(connection, indexesSQL, validIndexNames);
        }
    }

    protected void migrateTable(DB db, Connection connection, String tableName, Object[][] columns, String sqlCreate) {
        Table table = new Table(tableName, columns);
        try {
            table.generateTempFile();
            db.runSQL(connection, sqlCreate);
            table.populateTable(connection);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
            MaintenanceUtil.appendStatus(e2.getMessage());
        }
    }
}

