/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.comment.action;

import com.liferay.message.boards.kernel.exception.DiscussionMaxCommentsException;
import com.liferay.message.boards.kernel.exception.MessageBodyException;
import com.liferay.message.boards.kernel.exception.NoSuchMessageException;
import com.liferay.message.boards.kernel.exception.RequiredMessageException;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContextFunction;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.struts.BaseStrutsAction;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Function;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.servlet.NamespaceServletRequest;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@OSGiBeanProperties(property={"path=/portal/comment/edit_discussion"}, service={StrutsAction.class})
public class EditDiscussionStrutsAction
extends BaseStrutsAction {
    public String execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String namespace = ParamUtil.getString((HttpServletRequest)request, (String)"namespace");
        NamespaceServletRequest namespacedRequest = new NamespaceServletRequest(request, "", namespace);
        String cmd = ParamUtil.getString((HttpServletRequest)namespacedRequest, (String)"cmd");
        try {
            String redirect = PortalUtil.escapeRedirect((String)ParamUtil.getString((HttpServletRequest)request, (String)"redirect"));
            if (cmd.equals("add") || cmd.equals("update")) {
                long commentId = this.updateComment((HttpServletRequest)namespacedRequest);
                boolean ajax = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ajax", (boolean)true);
                if (ajax) {
                    String randomNamespace = ParamUtil.getString((HttpServletRequest)namespacedRequest, (String)"randomNamespace");
                    JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
                    jsonObject.put("commentId", commentId);
                    jsonObject.put("randomNamespace", randomNamespace);
                    this.writeJSON((HttpServletRequest)namespacedRequest, response, jsonObject);
                    return null;
                }
            } else if (cmd.equals("delete")) {
                this.deleteComment((HttpServletRequest)namespacedRequest);
            } else if (cmd.equals("subscribe_to_comments")) {
                this.subscribeToComments((HttpServletRequest)namespacedRequest, true);
            } else if (cmd.equals("unsubscribe_from_comments")) {
                this.subscribeToComments((HttpServletRequest)namespacedRequest, false);
            }
            if (Validator.isNotNull((String)redirect)) {
                response.sendRedirect(redirect);
            }
        }
        catch (DiscussionMaxCommentsException | MessageBodyException | NoSuchMessageException | RequiredMessageException | PrincipalException e2) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.putException((Exception)e2);
            this.writeJSON((HttpServletRequest)namespacedRequest, response, jsonObject);
        }
        return null;
    }

    protected void deleteComment(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long commentId = ParamUtil.getLong((HttpServletRequest)request, (String)"commentId");
        DiscussionPermission discussionPermission = this._getDiscussionPermission(themeDisplay);
        discussionPermission.checkDeletePermission(commentId);
        CommentManagerUtil.deleteComment((long)commentId);
    }

    protected void subscribeToComments(HttpServletRequest request, boolean subscribe) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"className");
        long classPK = ParamUtil.getLong((HttpServletRequest)request, (String)"classPK");
        if (subscribe) {
            CommentManagerUtil.subscribeDiscussion((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)className, (long)classPK);
        } else {
            CommentManagerUtil.unsubscribeDiscussion((long)themeDisplay.getUserId(), (String)className, (long)classPK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long updateComment(HttpServletRequest request) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long commentId = ParamUtil.getLong((HttpServletRequest)request, (String)"commentId");
        String className = ParamUtil.getString((HttpServletRequest)request, (String)"className");
        long classPK = ParamUtil.getLong((HttpServletRequest)request, (String)"classPK");
        long parentCommentId = ParamUtil.getLong((HttpServletRequest)request, (String)"parentCommentId");
        String subject = ParamUtil.getString((HttpServletRequest)request, (String)"subject");
        String body = ParamUtil.getString((HttpServletRequest)request, (String)"body");
        ServiceContextFunction serviceContextFunction = new ServiceContextFunction(request);
        DiscussionPermission discussionPermission = this._getDiscussionPermission(themeDisplay);
        if (commentId <= 0L) {
            User user = null;
            if (themeDisplay.isSignedIn()) {
                user = themeDisplay.getUser();
            } else {
                String emailAddress = ParamUtil.getString((HttpServletRequest)request, (String)"emailAddress");
                user = UserLocalServiceUtil.fetchUserByEmailAddress((long)themeDisplay.getCompanyId(), (String)emailAddress);
                if (user == null || user.getStatus() != 6) {
                    return 0L;
                }
            }
            String name = PrincipalThreadLocal.getName();
            PrincipalThreadLocal.setName((long)user.getUserId());
            try {
                discussionPermission.checkAddPermission(themeDisplay.getCompanyId(), themeDisplay.getScopeGroupId(), className, classPK);
                commentId = CommentManagerUtil.addComment((long)user.getUserId(), (String)className, (long)classPK, (String)user.getFullName(), (long)parentCommentId, (String)subject, (String)body, (Function)serviceContextFunction);
            }
            finally {
                PrincipalThreadLocal.setName((String)name);
            }
        } else {
            Comment comment;
            if ((Validator.isNull((String)className) || classPK == 0L) && (comment = CommentManagerUtil.fetchComment((long)commentId)) != null) {
                className = comment.getClassName();
                classPK = comment.getClassPK();
            }
            discussionPermission.checkUpdatePermission(commentId);
            commentId = CommentManagerUtil.updateComment((long)themeDisplay.getUserId(), (String)className, (long)classPK, (long)commentId, (String)subject, (String)body, (Function)serviceContextFunction);
        }
        boolean subscribe = ParamUtil.getBoolean((HttpServletRequest)request, (String)"subscribe");
        if (subscribe) {
            CommentManagerUtil.subscribeDiscussion((long)themeDisplay.getUserId(), (long)themeDisplay.getScopeGroupId(), (String)className, (long)classPK);
        }
        return commentId;
    }

    protected void writeJSON(HttpServletRequest request, HttpServletResponse response, Object json) throws IOException {
        response.setContentType("application/json");
        ServletResponseUtil.write((HttpServletResponse)response, (String)json.toString());
        response.flushBuffer();
    }

    private DiscussionPermission _getDiscussionPermission(ThemeDisplay themeDisplay) throws PrincipalException {
        DiscussionPermission discussionPermission = CommentManagerUtil.getDiscussionPermission((PermissionChecker)themeDisplay.getPermissionChecker());
        if (discussionPermission == null) {
            throw new PrincipalException("Discussion permission is null");
        }
        return discussionPermission;
    }
}

