/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.captcha;

import com.liferay.portal.kernel.captcha.Captcha;
import com.liferay.portal.kernel.captcha.CaptchaException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@DoPrivileged
public class CaptchaImpl
implements Captcha {
    private static final Log _log = LogFactoryUtil.getLog(CaptchaImpl.class);
    private volatile Captcha _captcha;
    private Captcha _originalCaptcha;

    public void check(HttpServletRequest request) throws CaptchaException {
        this._initialize();
        this._captcha.check(request);
    }

    public void check(PortletRequest portletRequest) throws CaptchaException {
        this._initialize();
        this._captcha.check(portletRequest);
    }

    public String getTaglibPath() {
        this._initialize();
        return this._captcha.getTaglibPath();
    }

    public boolean isEnabled(HttpServletRequest request) {
        this._initialize();
        return this._captcha.isEnabled(request);
    }

    public boolean isEnabled(PortletRequest portletRequest) {
        this._initialize();
        return this._captcha.isEnabled(portletRequest);
    }

    public void serveImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._initialize();
        this._captcha.serveImage(request, response);
    }

    public void serveImage(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        this._initialize();
        this._captcha.serveImage(resourceRequest, resourceResponse);
    }

    public void setCaptcha(Captcha captcha) {
        this._initialize();
        if (captcha == null) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Restoring " + ClassUtil.getClassName((Object)this._originalCaptcha)));
            }
            this._captcha = this._originalCaptcha;
        } else {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Setting " + ClassUtil.getClassName((Object)captcha)));
            }
            this._captcha = captcha;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _initialize() {
        if (this._captcha != null) {
            return;
        }
        CaptchaImpl captchaImpl = this;
        synchronized (captchaImpl) {
            if (this._captcha != null) {
                return;
            }
            try {
                String captchaClassName = PrefsPropsUtil.getString("captcha.engine.impl", PropsValues.CAPTCHA_ENGINE_IMPL);
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Initializing " + captchaClassName));
                }
                this._originalCaptcha = this._captcha = (Captcha)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)captchaClassName);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
    }
}

