/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.action;

import com.liferay.layouts.admin.kernel.util.SitemapUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutSetException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class SitemapAction
extends Action {
    private static final Log _log = LogFactoryUtil.getLog(SitemapAction.class);

    public ActionForward execute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean privateLayout = ParamUtil.getBoolean((HttpServletRequest)request, (String)"privateLayout");
            LayoutSet layoutSet = null;
            if (groupId > 0L) {
                Group group = GroupLocalServiceUtil.getGroup((long)groupId);
                if (group.isStagingGroup()) {
                    groupId = group.getLiveGroupId();
                }
                layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)groupId, (boolean)privateLayout);
            } else {
                String host = PortalUtil.getHost((HttpServletRequest)request);
                host = StringUtil.toLowerCase((String)host);
                VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost((String)(host = host.trim()));
                if (virtualHost != null && virtualHost.getLayoutSetId() != 0L) {
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)virtualHost.getLayoutSetId());
                } else {
                    String groupName = PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME;
                    if (Validator.isNull((String)groupName)) {
                        groupName = "Guest";
                    }
                    Group group = GroupLocalServiceUtil.getGroup((long)themeDisplay.getCompanyId(), (String)groupName);
                    layoutSet = LayoutSetLocalServiceUtil.getLayoutSet((long)group.getGroupId(), (boolean)false);
                }
            }
            String sitemap = SitemapUtil.getSitemap((long)layoutSet.getGroupId(), (boolean)layoutSet.isPrivateLayout(), (ThemeDisplay)themeDisplay);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])sitemap.getBytes("UTF-8"), (String)"text/xml; charset=UTF-8");
        }
        catch (NoSuchLayoutSetException nslse) {
            PortalUtil.sendError((int)404, (Exception)((Object)nslse), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e2, (Throwable)e2);
            }
            PortalUtil.sendError((int)500, (Exception)e2, (HttpServletRequest)request, (HttpServletResponse)response);
        }
        return null;
    }
}

