/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class MailSessionFactoryBean
extends AbstractFactoryBean<Session> {
    private static final Log _log = LogFactoryUtil.getLog(MailSessionFactoryBean.class);
    private String _propertyPrefix;

    public Class<Session> getObjectType() {
        return Session.class;
    }

    public void setPropertyPrefix(String propertyPrefix) {
        this._propertyPrefix = propertyPrefix;
    }

    protected Session createInstance() throws Exception {
        Properties properties = PropsUtil.getProperties(this._propertyPrefix, true);
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull((String)jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (Session)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to lookup " + jndiName), (Throwable)e2);
            }
        }
        Session session = Session.getInstance((Properties)properties);
        if (_log.isDebugEnabled()) {
            session.setDebug(true);
            SortedProperties sortedProperties = new SortedProperties(session.getProperties());
            _log.debug((Object)("Properties for prefix " + this._propertyPrefix));
            sortedProperties.list(System.out);
        }
        return session;
    }
}

