/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.mail.util;

import com.liferay.mail.kernel.model.Filter;
import com.liferay.mail.kernel.util.Hook;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.util.PropsUtil;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;

public class FuseMailHook
implements Hook {
    private static final String _ACCOUNT_TYPE = PropsUtil.get("mail.hook.fusemail.account.type");
    private static final String _GROUP_PARENT = PropsUtil.get("mail.hook.fusemail.group.parent");
    private static final String _PASSWORD = PropsUtil.get("mail.hook.fusemail.password");
    private static final String _URL = PropsUtil.get("mail.hook.fusemail.url");
    private static final String _USERNAME = PropsUtil.get("mail.hook.fusemail.username");
    private static final Log _log = LogFactoryUtil.getLog(FuseMailHook.class);
    private final HttpClient _client = new HttpClient();

    public void addForward(long companyId, long userId, List<Filter> filters, List<String> emailAddresses, boolean leaveCopy) {
    }

    public void addUser(long companyId, long userId, String password, String firstName, String middleName, String lastName, String emailAddress) {
        try {
            String mailUserId = this.getMailUserId(companyId, userId);
            PostMethod method = this.getPostMethod();
            method.addParameter("request", "order");
            method.addParameter("user", mailUserId);
            method.addParameter("password", password);
            method.addParameter("first_name", firstName);
            method.addParameter("last_name", lastName);
            method.addParameter("account_type", _ACCOUNT_TYPE);
            method.addParameter("group_parent", _GROUP_PARENT);
            method.addParameter("alias[0]", emailAddress);
            this.executeMethod(method);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void addVacationMessage(long companyId, long userId, String emailAddress, String vacationMessage) {
    }

    public void deleteEmailAddress(long companyId, long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById((long)userId);
            String mailUserId = this.getMailUserId(companyId, userId);
            PostMethod method = this.getPostMethod();
            method.addParameter("request", "removealias");
            method.addParameter("user", mailUserId);
            method.addParameter("alias", user.getEmailAddress());
            this.executeMethod(method);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void deleteUser(long companyId, long userId) {
        try {
            String mailUserId = this.getMailUserId(companyId, userId);
            PostMethod method = this.getPostMethod();
            method.addParameter("request", "terminate");
            method.addParameter("user", mailUserId);
            this.executeMethod(method);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updateBlocked(long companyId, long userId, List<String> blocked) {
    }

    public void updateEmailAddress(long companyId, long userId, String emailAddress) {
        try {
            this.deleteEmailAddress(companyId, userId);
            String mailUserId = this.getMailUserId(companyId, userId);
            PostMethod method = this.getPostMethod();
            method.addParameter("request", "modify");
            method.addParameter("user", mailUserId);
            method.addParameter("alias[0]", emailAddress);
            this.executeMethod(method);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public void updatePassword(long companyId, long userId, String password) {
        try {
            String mailUserId = this.getMailUserId(companyId, userId);
            PostMethod method = this.getPostMethod();
            method.addParameter("request", "modify");
            method.addParameter("user", mailUserId);
            method.addParameter("password", password);
            this.executeMethod(method);
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    protected int executeMethod(PostMethod method) throws Exception {
        HttpClient client = this.getHttpClient();
        int status = client.executeMethod((HttpMethod)method);
        if (!_log.isDebugEnabled()) {
            return status;
        }
        _log.debug((Object)("Posting to URI: " + method.getURI()));
        NameValuePair[] pairs = method.getParameters();
        if (pairs.length > 0) {
            StringBundler sb = new StringBundler(pairs.length * 3 + 1);
            sb.append("With parameters:\n");
            for (int i = 0; i < pairs.length; ++i) {
                sb.append("\t");
                sb.append((Object)pairs[i]);
                sb.append("\n");
            }
            _log.debug((Object)sb.toString());
        }
        _log.debug((Object)("Status: " + status));
        _log.debug((Object)("Response body: " + method.getResponseBodyAsString()));
        return status;
    }

    protected HttpClient getHttpClient() {
        return this._client;
    }

    protected String getMailUserId(long companyId, long userId) throws Exception {
        Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
        String mailUserId = company.getMx().concat(".").concat(String.valueOf(userId));
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Mail user id " + mailUserId + " for user id " + userId));
        }
        return mailUserId;
    }

    protected PostMethod getPostMethod() {
        PostMethod post = new PostMethod(_URL);
        post.addParameter("PlatformUser", _USERNAME);
        post.addParameter("PlatformPassword", _PASSWORD);
        return post;
    }
}

