/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;

public class TrashUndoUtil {
    public static void addRestoreData(ActionRequest actionRequest, List<ObjectValuePair<String, Long>> entries) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (entries == null || entries.isEmpty()) {
            return;
        }
        ArrayList<String> restoreClassNames = new ArrayList<String>();
        ArrayList<String> restoreEntryLinks = new ArrayList<String>();
        ArrayList<String> restoreEntryMessages = new ArrayList<String>();
        ArrayList<String> restoreLinks = new ArrayList<String>();
        ArrayList<String> restoreMessages = new ArrayList<String>();
        for (ObjectValuePair<String, Long> entry : entries) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)((String)entry.getKey()));
            String restoreEntryLink = trashHandler.getRestoreContainedModelLink((PortletRequest)actionRequest, ((Long)entry.getValue()).longValue());
            String restoreLink = trashHandler.getRestoreContainerModelLink((PortletRequest)actionRequest, ((Long)entry.getValue()).longValue());
            String restoreMessage = trashHandler.getRestoreMessage((PortletRequest)actionRequest, ((Long)entry.getValue()).longValue());
            if (Validator.isNull((String)restoreLink) || Validator.isNull((String)restoreMessage)) continue;
            restoreClassNames.add(trashHandler.getClassName());
            restoreEntryLinks.add(restoreEntryLink);
            TrashRenderer trashRenderer = trashHandler.getTrashRenderer(((Long)entry.getValue()).longValue());
            String restoreEntryTitle = trashRenderer.getTitle(themeDisplay.getLocale());
            restoreEntryMessages.add(restoreEntryTitle);
            restoreLinks.add(restoreLink);
            restoreMessages.add(restoreMessage);
        }
        HashMap<String, ArrayList<String>> data = new HashMap<String, ArrayList<String>>();
        data.put("restoreClassNames", restoreClassNames);
        data.put("restoreEntryLinks", restoreEntryLinks);
        data.put("restoreEntryMessages", restoreEntryMessages);
        data.put("restoreLinks", restoreLinks);
        data.put("restoreMessages", restoreMessages);
        SessionMessages.add((PortletRequest)actionRequest, (String)(PortalUtil.getPortletId((PortletRequest)actionRequest) + ".deleteSuccessData"), data);
    }

    public static void addRestoreData(ActionRequest actionRequest, String className, long classPK) throws Exception {
        ArrayList<ObjectValuePair<String, Long>> entries = new ArrayList<ObjectValuePair<String, Long>>();
        ObjectValuePair objectValuePair = new ObjectValuePair((Object)className, (Object)classPK);
        entries.add(objectValuePair);
        TrashUndoUtil.addRestoreData(actionRequest, entries);
    }
}

