/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.servlet.taglib.DynamicIncludeUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateContextContributor;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import com.liferay.taglib.servlet.PipingServletResponse;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThemeUtil {
    private static final Log _log = LogFactoryUtil.getLog(ThemeUtil.class);
    private static final ServiceTrackerList<TemplateContextContributor> _templateContextContributors = ServiceTrackerCollections.openList(TemplateContextContributor.class, (String)"(type=THEME)");

    public static String getPortletId(HttpServletRequest request) {
        String portletId = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            portletId = portletDisplay.getId();
        }
        return portletId;
    }

    public static void include(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        String extension = theme.getTemplateExtension();
        if (extension.equals("ftl")) {
            ThemeUtil.includeFTL(servletContext, request, response, path, theme, true);
        } else if (extension.equals("vm")) {
            ThemeUtil.includeVM(servletContext, request, response, path, theme, true);
        } else {
            path = theme.getTemplatesPath() + "/" + path;
            ThemeUtil.includeJSP(servletContext, request, response, path, theme);
        }
    }

    public static String includeFTL(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.doDispatch(servletContext, request, response, path, theme, write, "ftl");
    }

    public static void includeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        ThemeUtil.doDispatch(servletContext, request, response, path, theme, true, "jsp");
    }

    public static String includeVM(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme, boolean write) throws Exception {
        return ThemeUtil.doDispatch(servletContext, request, response, path, theme, write, "vm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String doDispatch(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme, boolean write, String extension) throws Exception {
        String pluginServletContextName = GetterUtil.getString((String)theme.getServletContextName());
        ServletContext pluginServletContext = ServletContextPool.get((String)pluginServletContextName);
        ClassLoader pluginClassLoader = null;
        if (pluginServletContext != null) {
            pluginClassLoader = (ClassLoader)pluginServletContext.getAttribute("PLUGIN_CLASS_LOADER");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
            currentThread.setContextClassLoader(pluginClassLoader);
        }
        try {
            if (extension.equals("ftl")) {
                String string = ThemeUtil.doIncludeFTL(servletContext, request, response, path, theme, false, write);
                return string;
            }
            if (extension.equals("jsp")) {
                ThemeUtil.doIncludeJSP(servletContext, request, response, path, theme);
            } else if (extension.equals("vm")) {
                String string = ThemeUtil.doIncludeVM(servletContext, request, response, path, theme, false, write);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (pluginClassLoader != null && pluginClassLoader != contextClassLoader) {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
    }

    protected static String doIncludeFTL(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        String portletId = ThemeUtil.getPortletId(request);
        String resourcePath = theme.getResourcePath(servletContext, portletId, path);
        if (Validator.isNotNull((String)portletId) && PortletConstants.hasInstanceId((String)portletId) && !TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            resourcePath = theme.getResourcePath(servletContext, rootPortletId, path);
        }
        if (Validator.isNotNull((String)portletId) && !TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            resourcePath = theme.getResourcePath(servletContext, null, path);
        }
        if (!TemplateResourceLoaderUtil.hasTemplateResource((String)"ftl", (String)resourcePath)) {
            _log.error((Object)(resourcePath + " does not exist"));
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"ftl", (String)resourcePath);
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)templateResource, (boolean)restricted);
        template.prepare(request);
        for (TemplateContextContributor templateContextContributor : _templateContextContributors) {
            templateContextContributor.prepare((Map)template, request);
        }
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        template.put((Object)"themeServletContext", (Object)themeServletContext);
        PrintWriter writer = null;
        writer = write ? response.getWriter() : new UnsyncStringWriter();
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"ftl");
        templateManager.addTaglibSupport((Map)template, request, response);
        templateManager.addTaglibTheme((Map)template, "taglibLiferay", request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer));
        template.put((Object)"writer", (Object)writer);
        template.processTemplate((Writer)writer);
        if (write) {
            return null;
        }
        return writer.toString();
    }

    protected static void doIncludeJSP(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String path, Theme theme) throws Exception {
        DynamicIncludeUtil.include((HttpServletRequest)request, (HttpServletResponse)response, (String)(ThemeUtil.class.getName() + "#doIncludeJSP"), (boolean)true);
        if (theme.isWARFile()) {
            ServletContext themeServletContext = servletContext.getContext(theme.getContextPath());
            if (themeServletContext == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " cannot find its " + "servlet context at " + theme.getServletContextName()));
            } else {
                RequestDispatcher requestDispatcher = themeServletContext.getRequestDispatcher(path);
                if (requestDispatcher == null) {
                    _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
                } else {
                    requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                }
            }
        } else {
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            if (requestDispatcher == null) {
                _log.error((Object)("Theme " + theme.getThemeId() + " does not have " + path));
            } else {
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    protected static String doIncludeVM(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, String page, Theme theme, boolean restricted, boolean write) throws Exception {
        String servletContextName = GetterUtil.getString((String)theme.getServletContextName());
        if (ServletContextPool.get((String)servletContextName) == null) {
            ServletContextPool.put((String)servletContextName, (ServletContext)servletContext);
        }
        String portletId = ThemeUtil.getPortletId(request);
        String resourcePath = theme.getResourcePath(servletContext, portletId, page);
        boolean checkResourceExists = true;
        if (Validator.isNotNull((String)portletId)) {
            if (PortletConstants.hasInstanceId((String)portletId) && checkResourceExists != TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath)) {
                String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
                resourcePath = theme.getResourcePath(servletContext, rootPortletId, page);
            }
            if (checkResourceExists && checkResourceExists != TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath)) {
                resourcePath = theme.getResourcePath(servletContext, null, page);
            }
        }
        if (checkResourceExists && !TemplateResourceLoaderUtil.hasTemplateResource((String)"vm", (String)resourcePath)) {
            _log.error((Object)(resourcePath + " does not exist"));
            return null;
        }
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)resourcePath);
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + resourcePath);
        }
        TemplateManager templateManager = TemplateManagerUtil.getTemplateManager((String)"vm");
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)restricted);
        template.prepare(request);
        for (TemplateContextContributor templateContextContributor : _templateContextContributors) {
            templateContextContributor.prepare((Map)template, request);
        }
        ServletContext themeServletContext = ServletContextPool.get((String)servletContextName);
        template.put((Object)"themeServletContext", (Object)themeServletContext);
        PrintWriter writer = null;
        writer = write ? response.getWriter() : new UnsyncStringWriter();
        templateManager.addTaglibTheme((Map)template, "taglibLiferay", request, (HttpServletResponse)new PipingServletResponse(response, (Writer)writer));
        template.put((Object)"writer", (Object)writer);
        template.processTemplate((Writer)writer);
        if (write) {
            return null;
        }
        return ((UnsyncStringWriter)writer).toString();
    }
}

