/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class TagResourceBundleUtil {
    private static final ResourceBundle _emptyResourceBundle = new EmptyResourceBundle();

    public static ResourceBundle getResourceBundle(HttpServletRequest request, Locale locale) {
        ResourceBundleLoader resourceBundleLoader = TagResourceBundleUtil.getResourceBundleLoader(request);
        if (resourceBundleLoader != null) {
            return resourceBundleLoader.loadResourceBundle(LanguageUtil.getLanguageId((Locale)locale));
        }
        ResourceBundle portletResourceBundle = TagResourceBundleUtil.getPortletResourceBundle(request, locale);
        ResourceBundle portalResourceBundle = PortalUtil.getResourceBundle((Locale)locale);
        return new AggregateResourceBundle(new ResourceBundle[]{portletResourceBundle, portalResourceBundle});
    }

    public static ResourceBundle getResourceBundle(PageContext pageContext) {
        ResourceBundle resourceBundle = (ResourceBundle)pageContext.getAttribute("resourceBundle");
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
        if (resourceBundle != null) {
            return new AggregateResourceBundle(new ResourceBundle[]{resourceBundle, PortalUtil.getResourceBundle((Locale)locale)});
        }
        return TagResourceBundleUtil.getResourceBundle(request, locale);
    }

    protected static ResourceBundle getPortletResourceBundle(HttpServletRequest request, Locale locale) {
        PortletConfig portletConfig = (PortletConfig)request.getAttribute("javax.portlet.config");
        if (portletConfig != null) {
            return portletConfig.getResourceBundle(locale);
        }
        return _emptyResourceBundle;
    }

    protected static ResourceBundleLoader getResourceBundleLoader(HttpServletRequest request) {
        ResourceBundleLoader resourceBundleLoader = (ResourceBundleLoader)request.getAttribute("RESOURCE_BUNDLE_LOADER");
        if (resourceBundleLoader == null) {
            ServletContext servletContext = request.getServletContext();
            String servletContextName = servletContext.getServletContextName();
            if (Validator.isNull((String)servletContextName)) {
                return null;
            }
            resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByServletContextName((String)servletContextName);
        }
        if (resourceBundleLoader == null) {
            return null;
        }
        return new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, ResourceBundleLoaderUtil.getPortalResourceBundleLoader()});
    }

    private static class EmptyResourceBundle
    extends ResourceBundle {
        private EmptyResourceBundle() {
        }

        @Override
        public boolean containsKey(String key) {
            return false;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return null;
        }
    }
}

