/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.LogUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DirectRequestDispatcherFactoryUtil;
import com.liferay.portal.kernel.servlet.TrackedServletRequest;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIdFactory;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIdFactoryRegistry;
import com.liferay.portal.kernel.servlet.taglib.TagDynamicIncludeUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.CustomJspRegistryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.taglib.servlet.PipingServletResponse;
import com.liferay.taglib.util.AttributesTagSupport;
import com.liferay.taglib.util.ThemeUtil;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;

public class IncludeTag
extends AttributesTagSupport {
    private static final boolean _CLEAN_UP_SET_ATTRIBUTES = false;
    private static final boolean _THEME_JSP_OVERRIDE_ENABLED = GetterUtil.getBoolean((String)PropsUtil.get((String)"theme.jsp.override.enabled"));
    private static final Log _log = LogFactoryUtil.getLog(IncludeTag.class);
    private String _page;
    private boolean _strict;
    private TrackedServletRequest _trackedRequest;
    private boolean _useCustomPage = true;

    @Override
    public int doEndTag() throws JspException {
        try {
            String page = this.getPage();
            if (Validator.isNull((String)page)) {
                page = this.getEndPage();
            }
            this.callSetAttributes();
            if (this.themeResourceExists(page)) {
                this.doIncludeTheme(page);
                int n = 6;
                return n;
            }
            if (!FileAvailabilityUtil.isAvailable(this.servletContext, page)) {
                this.logUnavailablePage(page);
                int n = this.processEndTag();
                return n;
            }
            this.doInclude(page, false);
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.doClearTag();
        }
    }

    @Override
    public int doStartTag() throws JspException {
        try {
            String page = this.getStartPage();
            this.callSetAttributes();
            if (this.themeResourceExists(page)) {
                this.doIncludeTheme(page);
                return 1;
            }
            if (!FileAvailabilityUtil.isAvailable(this.servletContext, page)) {
                this.logUnavailablePage(page);
                return this.processStartTag();
            }
            this.doInclude(page, true);
            return 1;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public void runTag() throws JspException {
        this.doStartTag();
        this.doEndTag();
    }

    public void setPage(String page) {
        this._page = page;
    }

    public void setPortletId(String portletId) {
        if (Validator.isNotNull((String)portletId)) {
            String rootPortletId = PortletConstants.getRootPortletId((String)portletId);
            PortletBag portletBag = PortletBagPool.get((String)rootPortletId);
            this.servletContext = portletBag.getServletContext();
        }
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }

    public void setUseCustomPage(boolean useCustomPage) {
        this._useCustomPage = useCustomPage;
    }

    protected void callSetAttributes() {
        HttpServletRequest request = this.getOriginalServletRequest();
        if (this.isCleanUpSetAttributes()) {
            this._trackedRequest = new TrackedServletRequest(request);
            request = this._trackedRequest;
        }
        this.setNamespacedAttribute(request, "bodyContent", this.getBodyContentWrapper());
        this.setNamespacedAttribute(request, "dynamicAttributes", this.getDynamicAttributes());
        this.setNamespacedAttribute(request, "scopedAttributes", this.getScopedAttributes());
        this.setAttributes(request);
    }

    protected void cleanUp() {
    }

    protected void cleanUpSetAttributes() {
        if (this.isCleanUpSetAttributes() && this._trackedRequest != null) {
            for (String name : this._trackedRequest.getSetAttributes()) {
                this._trackedRequest.removeAttribute(name);
            }
            this._trackedRequest = null;
        }
    }

    protected void doClearTag() {
        this.clearDynamicAttributes();
        this.clearParams();
        this.clearProperties();
        this.cleanUpSetAttributes();
        if (!ServerDetector.isResin()) {
            this.setPage(null);
            this.setUseCustomPage(true);
            this.cleanUp();
        }
    }

    protected void doInclude(String page, boolean dynamicIncludeAscendingPriority) throws JspException {
        block2: {
            try {
                this.include(page, dynamicIncludeAscendingPriority);
            }
            catch (Exception e) {
                String currentURL = (String)this.request.getAttribute("CURRENT_URL");
                String message = "Current URL " + currentURL + " generates exception: " + e.getMessage();
                LogUtil.log((Log)_log, (Throwable)e, (String)message);
                if (!(e instanceof JspException)) break block2;
                throw (JspException)e;
            }
        }
    }

    protected void doIncludeTheme(String page) throws Exception {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        Theme theme = (Theme)this.request.getAttribute("THEME");
        ThemeUtil.include(this.servletContext, this.request, response, page, theme);
    }

    protected Object getBodyContentWrapper() {
        final BodyContent bodyContent = this.getBodyContent();
        if (bodyContent == null) {
            return null;
        }
        return new Object(){

            public String toString() {
                return bodyContent.getString();
            }
        };
    }

    protected String getCustomPage(ServletContext servletContext, HttpServletRequest request, String page) {
        UnicodeProperties typeSettingsProperties;
        String customJspServletContextName;
        if (Validator.isNull((String)page)) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay == null) {
            return null;
        }
        Group group = null;
        long scopeGroupId = themeDisplay.getScopeGroupId();
        try {
            group = StagingUtil.getLiveGroup((long)scopeGroupId);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (group == null) {
            group = GroupLocalServiceUtil.fetchGroup((long)scopeGroupId);
        }
        if (Validator.isNull((String)(customJspServletContextName = (typeSettingsProperties = group.getTypeSettingsProperties()).getProperty("customJspServletContextName")))) {
            return null;
        }
        String customPage = CustomJspRegistryUtil.getCustomJspFileName((String)customJspServletContextName, (String)page);
        if (FileAvailabilityUtil.isAvailable(servletContext, customPage)) {
            return customPage;
        }
        return null;
    }

    protected String getEndPage() {
        return null;
    }

    protected HttpServletRequest getOriginalServletRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected String getPage() {
        return this._page;
    }

    protected String getStartPage() {
        return null;
    }

    protected void include(String page, boolean doStartTag) throws Exception {
        String customPage;
        PipingServletResponse httpServletResponse = null;
        Class<?> clazz = this.getClass();
        String tagClassName = clazz.getName();
        String tagDynamicId = null;
        String tagPointPrefix = null;
        tagPointPrefix = doStartTag ? "doStartTag#" : "doEndTag#";
        TagDynamicIdFactory tagDynamicIdFactory = TagDynamicIdFactoryRegistry.getTagDynamicIdFactory((String)tagClassName);
        if (tagDynamicIdFactory != null) {
            httpServletResponse = new PipingServletResponse((HttpServletResponse)this.pageContext.getResponse(), (Writer)this.pageContext.getOut());
            tagDynamicId = tagDynamicIdFactory.getTagDynamicId(this.request, (HttpServletResponse)httpServletResponse, (Object)this);
            TagDynamicIncludeUtil.include((HttpServletRequest)this.request, (HttpServletResponse)httpServletResponse, (String)tagClassName, (String)tagDynamicId, (String)(tagPointPrefix + "before"), (boolean)doStartTag);
        }
        if (this._useCustomPage && Validator.isNotNull((String)(customPage = this.getCustomPage(this.servletContext, this.request, page)))) {
            page = customPage;
        }
        this.request.setAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT", (Object)this._strict);
        PipingServletResponse response = new PipingServletResponse(this.pageContext);
        this.includePage(page, (HttpServletResponse)response);
        this.request.removeAttribute("SERVLET_CONTEXT_INCLUDE_FILTER_STRICT");
        if (tagDynamicIdFactory != null) {
            TagDynamicIncludeUtil.include((HttpServletRequest)this.request, (HttpServletResponse)httpServletResponse, (String)tagClassName, (String)tagDynamicId, (String)(tagPointPrefix + "after"), (boolean)doStartTag);
        }
    }

    protected void includePage(String page, HttpServletResponse response) throws IOException, ServletException {
        RequestDispatcher requestDispatcher = DirectRequestDispatcherFactoryUtil.getRequestDispatcher((ServletContext)this.servletContext, (String)page);
        requestDispatcher.include((ServletRequest)this.request, (ServletResponse)response);
    }

    protected boolean isCleanUpSetAttributes() {
        return false;
    }

    protected boolean isPortalPage(String page) {
        return page.startsWith("/html/taglib/") && (page.endsWith("/end.jsp") || page.endsWith("/page.jsp") || page.endsWith("/start.jsp"));
    }

    protected boolean isUseCustomPage() {
        return this._useCustomPage;
    }

    protected void logUnavailablePage(String page) {
        if (page == null || !_log.isWarnEnabled()) {
            return;
        }
        StringBundler sb = new StringBundler(8);
        sb.append("Unable to find ");
        sb.append(page);
        sb.append(" in the context ");
        String contextPath = this.servletContext.getContextPath();
        if (contextPath.equals("")) {
            contextPath = "/";
        }
        sb.append(contextPath);
        sb.append(".");
        boolean portalContext = false;
        String portalContextPath = PortalUtil.getPathContext();
        if (portalContextPath.equals("")) {
            portalContextPath = "/";
        }
        if (contextPath.equals(portalContextPath)) {
            portalContext = true;
        }
        if (this.isPortalPage(page)) {
            if (portalContext) {
                return;
            }
            sb.append(" You must not use a taglib from a module and set ");
            sb.append("the attribute \"servletContext\". Inline the ");
            sb.append("content directly where the taglib is invoked.");
        } else if (portalContext) {
            Class<?> clazz = this.getClass();
            if (clazz.equals(IncludeTag.class)) {
                sb.append(" You must set the attribute \"servletContext\" ");
                sb.append("with the value \"<%= application %>\" when ");
                sb.append("invoking a taglib from a module.");
            } else {
                sb.append(" You must not use a taglib from a module and set ");
                sb.append("the attribute \"file\". Inline the content ");
                sb.append("directly where the taglib is invoked.");
            }
        }
        _log.warn((Object)sb.toString());
    }

    protected int processEndTag() throws Exception {
        return 6;
    }

    protected int processStartTag() throws Exception {
        return 1;
    }

    protected void setAttributes(HttpServletRequest request) {
    }

    protected boolean themeResourceExists(String page) throws Exception {
        ThemeDisplay themeDisplay;
        if (page == null || !_THEME_JSP_OVERRIDE_ENABLED || this._strict) {
            return false;
        }
        Theme theme = (Theme)this.request.getAttribute("THEME");
        if (theme == null && (themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY")) != null) {
            theme = themeDisplay.getTheme();
        }
        if (theme == null) {
            return false;
        }
        String portletId = ThemeUtil.getPortletId(this.request);
        boolean exists = theme.resourceExists(this.servletContext, portletId, page);
        if (_log.isDebugEnabled() && exists) {
            String resourcePath = theme.getResourcePath(this.servletContext, null, page);
            _log.debug((Object)resourcePath);
        }
        return exists;
    }
}

