/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.util;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.service.AssetCategoryLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;

public class AssetCategoryUtil {
    public static final String CATEGORY_SEPARATOR = "_CATEGORY_";

    public static long[] filterCategoryIds(long vocabularyId, long[] categoryIds) {
        ArrayList<Long> filteredCategoryIds = new ArrayList<Long>();
        for (long categoryId : categoryIds) {
            AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
            if (category == null || category.getVocabularyId() != vocabularyId) continue;
            filteredCategoryIds.add(category.getCategoryId());
        }
        return ArrayUtil.toArray((Long[])filteredCategoryIds.toArray(new Long[filteredCategoryIds.size()]));
    }

    public static String[] getCategoryIdsTitles(String categoryIds, String categoryNames, long vocabularyId, ThemeDisplay themeDisplay) {
        if (Validator.isNotNull((String)categoryIds)) {
            long[] categoryIdsArray = GetterUtil.getLongValues((String[])StringUtil.split((String)categoryIds));
            if (vocabularyId > 0L) {
                categoryIdsArray = AssetCategoryUtil.filterCategoryIds(vocabularyId, categoryIdsArray);
            }
            categoryIds = "";
            categoryNames = "";
            if (categoryIdsArray.length > 0) {
                StringBundler categoryIdsSb = new StringBundler(categoryIdsArray.length * 2);
                StringBundler categoryNamesSb = new StringBundler(categoryIdsArray.length * 2);
                for (long categoryId : categoryIdsArray) {
                    AssetCategory category = AssetCategoryLocalServiceUtil.fetchCategory((long)categoryId);
                    if (category == null) continue;
                    categoryIdsSb.append(categoryId);
                    categoryIdsSb.append(",");
                    categoryNamesSb.append(category.getTitle(themeDisplay.getLocale()));
                    categoryNamesSb.append(CATEGORY_SEPARATOR);
                }
                if (categoryIdsSb.index() > 0) {
                    categoryIdsSb.setIndex(categoryIdsSb.index() - 1);
                    categoryNamesSb.setIndex(categoryNamesSb.index() - 1);
                    categoryIds = categoryIdsSb.toString();
                    categoryNames = categoryNamesSb.toString();
                }
            }
        }
        return new String[]{categoryIds, categoryNames};
    }
}

