/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class SessionTreeJSClicks {
    private static final Log _log = LogFactoryUtil.getLog(SessionTreeJSClicks.class);

    public static void closeLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.closeNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void closeNode(HttpServletRequest request, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.removeFromList((String)openNodesString, (String)nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, "");
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            break;
        }
    }

    public static void closeNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                for (String nodeId : nodeIds) {
                    openNodesString = StringUtil.removeFromList((String)openNodesString, (String)nodeId);
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            break;
        }
    }

    public static String getOpenNodes(HttpServletRequest request, String treeId) {
        try {
            PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
            return portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            return null;
        }
    }

    public static void openLayoutNodes(HttpServletRequest request, String treeId, boolean privateLayout, long layoutId, boolean recursive) {
        try {
            ArrayList<String> layoutIds = new ArrayList<String>();
            layoutIds.add(String.valueOf(layoutId));
            if (recursive) {
                SessionTreeJSClicks.getLayoutIds(request, privateLayout, layoutId, layoutIds);
            }
            SessionTreeJSClicks.openNodes(request, treeId, layoutIds.toArray(new String[layoutIds.size()]));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    public static void openNode(HttpServletRequest request, String treeId, String nodeId) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            break;
        }
    }

    public static void openNodes(HttpServletRequest request, String treeId, String[] nodeIds) {
        while (true) {
            try {
                PortalPreferences portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((HttpServletRequest)request);
                String openNodesString = portalPreferences.getValue(SessionTreeJSClicks.class.getName(), treeId);
                for (String nodeId : nodeIds) {
                    openNodesString = StringUtil.add((String)openNodesString, (String)nodeId);
                }
                portalPreferences.setValue(SessionTreeJSClicks.class.getName(), treeId, openNodesString);
                return;
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
                return;
            }
            break;
        }
    }

    protected static List<String> getLayoutIds(HttpServletRequest request, boolean privateLayout, long parentLayoutId, List<String> layoutIds) throws Exception {
        long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
        List layouts = LayoutLocalServiceUtil.getLayouts((long)groupId, (boolean)privateLayout, (long)parentLayoutId);
        for (Layout layout : layouts) {
            layoutIds.add(String.valueOf(layout.getLayoutId()));
            SessionTreeJSClicks.getLayoutIds(request, privateLayout, layout.getLayoutId(), layoutIds);
        }
        return layoutIds;
    }
}

