/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui.display.context;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetLink;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.ClassType;
import com.liferay.asset.kernel.model.ClassTypeReader;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.AssetLinkLocalServiceUtil;
import com.liferay.asset.kernel.util.comparator.AssetRendererFactoryTypeNameComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PredicateFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;

public class InputAssetLinksDisplayContext {
    private final long _assetEntryId;
    private List<AssetLink> _assetLinks;
    private String _eventName;
    private final PageContext _pageContext;
    private final PortletRequest _portletRequest;
    private String _randomNamespace;
    private final HttpServletRequest _request;
    private Boolean _stagedLocally;
    private Boolean _stagedReferrerPortlet;
    private final ThemeDisplay _themeDisplay;

    public InputAssetLinksDisplayContext(PageContext pageContext) {
        this._pageContext = pageContext;
        this._request = (HttpServletRequest)pageContext.getRequest();
        this._assetEntryId = GetterUtil.getLong((String)((String)this._request.getAttribute("liferay-ui:input-asset-links:assetEntryId")));
        this._portletRequest = (PortletRequest)this._request.getAttribute("javax.portlet.request");
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public AssetEntry getAssetLinkEntry(AssetLink assetLink) throws PortalException {
        if (this._assetEntryId > 0L || assetLink.getEntryId1() == this._assetEntryId) {
            return AssetEntryLocalServiceUtil.getEntry((long)assetLink.getEntryId2());
        }
        return AssetEntryLocalServiceUtil.getEntry((long)assetLink.getEntryId1());
    }

    public List<AssetLink> getAssetLinks() throws PortalException {
        if (this._assetLinks == null) {
            this._assetLinks = this._createAssetLinks();
        }
        return this._assetLinks;
    }

    public int getAssetLinksCount() throws PortalException {
        List<AssetLink> assetLinks = this.getAssetLinks();
        return assetLinks.size();
    }

    public List<AssetRendererFactory<?>> getAssetRendererFactories() {
        List assetRendererFactories = AssetRendererFactoryRegistryUtil.getAssetRendererFactories((long)this._themeDisplay.getCompanyId());
        assetRendererFactories = ListUtil.filter((List)assetRendererFactories, (PredicateFilter)new PredicateFilter<AssetRendererFactory<?>>(){

            public boolean filter(AssetRendererFactory<?> assetRendererFactory) {
                return assetRendererFactory.isLinkable() && assetRendererFactory.isSelectable();
            }
        });
        return ListUtil.sort((List)assetRendererFactories, (Comparator)new AssetRendererFactoryTypeNameComparator(this._themeDisplay.getLocale()));
    }

    public String getAssetType(AssetEntry entry) {
        AssetRendererFactory assetRendererFactory = entry.getAssetRendererFactory();
        return assetRendererFactory.getTypeName(this._themeDisplay.getLocale());
    }

    public String getEventName() {
        if (this._eventName != null) {
            return this._eventName;
        }
        this._eventName = this._randomNamespace + "selectAsset";
        return this._eventName;
    }

    public String getGroupDescriptiveName(AssetEntry assetEntry) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup((long)assetEntry.getGroupId());
        return group.getDescriptiveName(this._themeDisplay.getLocale());
    }

    public String getRandomNamespace() {
        if (this._randomNamespace != null) {
            return this._randomNamespace;
        }
        String randomKey = PortalUtil.generateRandomKey((HttpServletRequest)this._request, (String)"taglib_ui_input_asset_links_page");
        this._randomNamespace = randomKey + "_";
        return this._randomNamespace;
    }

    public List<Map<String, Object>> getSelectorEntries() throws Exception {
        ArrayList<Map<String, Object>> selectorEntries = new ArrayList<Map<String, Object>>();
        for (AssetRendererFactory<?> assetRendererFactory : this.getAssetRendererFactories()) {
            if (assetRendererFactory.isSupportsClassTypes()) {
                selectorEntries.addAll(this._getSelectorEntries(assetRendererFactory));
                continue;
            }
            HashMap<String, Object> selectorEntry = new HashMap<String, Object>();
            selectorEntry.put("data", this._geSelectorEntryData(assetRendererFactory));
            selectorEntry.put("iconCssClass", this._getSelectorEntryIconCssClass(assetRendererFactory));
            selectorEntry.put("id", this._getSelectorEntryId(assetRendererFactory));
            selectorEntry.put("message", this._getSelectorEntryMessage(assetRendererFactory));
            selectorEntries.add(selectorEntry);
        }
        return selectorEntries;
    }

    private List<AssetLink> _createAssetLinks() throws PortalException {
        ArrayList<AssetLink> assetLinks = new ArrayList<AssetLink>();
        String assetLinksSearchContainerPrimaryKeys = ParamUtil.getString((HttpServletRequest)this._request, (String)"assetLinksSearchContainerPrimaryKeys");
        if (Validator.isNull((String)assetLinksSearchContainerPrimaryKeys) && SessionErrors.isEmpty((PortletRequest)this._portletRequest) && this._assetEntryId > 0L) {
            List directAssetLinks = AssetLinkLocalServiceUtil.getDirectLinks((long)this._assetEntryId, (boolean)false);
            for (AssetLink assetLink : directAssetLinks) {
                AssetEntry assetLinkEntry = this.getAssetLinkEntry(assetLink);
                AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)assetLinkEntry.getClassName());
                if (!assetRendererFactory.isActive(this._themeDisplay.getCompanyId())) continue;
                assetLinks.add(assetLink);
            }
        } else {
            String[] assetEntriesPrimaryKeys;
            for (String assetEntryPrimaryKey : assetEntriesPrimaryKeys = StringUtil.split((String)assetLinksSearchContainerPrimaryKeys)) {
                long assetEntryPrimaryKeyLong = GetterUtil.getLong((String)assetEntryPrimaryKey);
                AssetEntry assetEntry = AssetEntryServiceUtil.getEntry((long)assetEntryPrimaryKeyLong);
                AssetLink assetLink = AssetLinkLocalServiceUtil.createAssetLink((long)0L);
                if (this._assetEntryId > 0L) {
                    assetLink.setEntryId1(this._assetEntryId);
                } else {
                    assetLink.setEntryId1(0L);
                }
                assetLink.setEntryId2(assetEntry.getEntryId());
                assetLinks.add(assetLink);
            }
        }
        return assetLinks;
    }

    private Map<String, Object> _geSelectorEntryData(AssetRendererFactory<?> assetRendererFactory) throws Exception {
        HashMap<String, Object> selectorEntryData = new HashMap<String, Object>();
        PortletURL assetBrowserPortletURL = this._getAssetBrowserPortletURL(assetRendererFactory);
        if (assetBrowserPortletURL != null) {
            selectorEntryData.put("href", assetBrowserPortletURL.toString());
        }
        ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this._pageContext);
        String typeName = assetRendererFactory.getTypeName(this._themeDisplay.getLocale());
        selectorEntryData.put("title", LanguageUtil.format((ResourceBundle)resourceBundle, (String)"select-x", (Object)typeName, (boolean)false));
        selectorEntryData.put("type", assetRendererFactory.getClassName());
        return selectorEntryData;
    }

    private long _getAssetBrowserGroupId(AssetRendererFactory<?> assetRendererFactory) {
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        long groupId = scopeGroup.getGroupId();
        if (this._isStagedLocally() && scopeGroup.isStagingGroup()) {
            boolean stagedReferencePortlet = scopeGroup.isStagedPortlet(assetRendererFactory.getPortletId());
            if (this._isStagedReferrerPortlet() && !stagedReferencePortlet) {
                groupId = scopeGroup.getLiveGroupId();
            }
        }
        return groupId;
    }

    private PortletURL _getAssetBrowserPortletURL(AssetRendererFactory<?> assetRendererFactory) throws Exception {
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)this._request, (String)assetRendererFactory.getClassName(), (PortletProvider.Action)PortletProvider.Action.BROWSE);
        if (portletURL == null) {
            return portletURL;
        }
        long groupId = this._getAssetBrowserGroupId(assetRendererFactory);
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("selectedGroupIds", StringUtil.merge((long[])PortalUtil.getSharedContentSiteGroupIds((long)this._themeDisplay.getCompanyId(), (long)groupId, (long)this._themeDisplay.getUserId())));
        if (this._assetEntryId > 0L) {
            portletURL.setParameter("refererAssetEntryId", String.valueOf(this._assetEntryId));
        }
        portletURL.setParameter("typeSelection", assetRendererFactory.getClassName());
        portletURL.setParameter("eventName", this.getEventName());
        portletURL.setPortletMode(PortletMode.VIEW);
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        return portletURL;
    }

    private List<Map<String, Object>> _getSelectorEntries(AssetRendererFactory<?> assetRendererFactory) throws Exception {
        long groupId = this._getAssetBrowserGroupId(assetRendererFactory);
        ClassTypeReader classTypeReader = assetRendererFactory.getClassTypeReader();
        List classTypes = classTypeReader.getAvailableClassTypes(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), this._themeDisplay.getLocale());
        if (classTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> selectorEntries = new ArrayList<Map<String, Object>>();
        for (ClassType classType : classTypes) {
            HashMap<String, Object> selectorEntry = new HashMap<String, Object>();
            selectorEntry.put("data", this._getSelectorEntryData(assetRendererFactory, classType));
            selectorEntry.put("iconCssClass", this._getSelectorEntryIconCssClass(assetRendererFactory));
            selectorEntry.put("id", this._getSelectorEntryId(assetRendererFactory, classType));
            selectorEntry.put("message", this._getSelectorEntryMessage(classType));
            selectorEntries.add(selectorEntry);
        }
        return selectorEntries;
    }

    private Map<String, Object> _getSelectorEntryData(AssetRendererFactory<?> assetRendererFactory, ClassType classType) throws Exception {
        HashMap<String, Object> selectorEntryData = new HashMap<String, Object>();
        PortletURL portletURL = this._getAssetBrowserPortletURL(assetRendererFactory);
        if (portletURL != null) {
            portletURL.setParameter("subtypeSelectionId", String.valueOf(classType.getClassTypeId()));
            selectorEntryData.put("href", portletURL.toString());
        }
        ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this._pageContext);
        selectorEntryData.put("title", LanguageUtil.format((ResourceBundle)resourceBundle, (String)"select-x", (Object)classType.getName(), (boolean)false));
        selectorEntryData.put("type", classType.getName());
        return selectorEntryData;
    }

    private String _getSelectorEntryIconCssClass(AssetRendererFactory<?> assetRendererFactory) throws Exception {
        return assetRendererFactory.getIconCssClass();
    }

    private String _getSelectorEntryId(AssetRendererFactory<?> assetRendererFactory) {
        return FriendlyURLNormalizerUtil.normalize((String)assetRendererFactory.getTypeName(this._themeDisplay.getLocale()));
    }

    private String _getSelectorEntryId(AssetRendererFactory<?> assetRendererFactory, ClassType classType) {
        String selectorEntryId = String.valueOf(this._getAssetBrowserGroupId(assetRendererFactory));
        selectorEntryId = selectorEntryId + FriendlyURLNormalizerUtil.normalize((String)classType.getName());
        return selectorEntryId;
    }

    private String _getSelectorEntryMessage(AssetRendererFactory<?> assetRendererFactory) {
        return assetRendererFactory.getTypeName(this._themeDisplay.getLocale());
    }

    private String _getSelectorEntryMessage(ClassType classType) {
        return classType.getName();
    }

    private boolean _isStagedLocally() {
        if (this._stagedLocally != null) {
            return this._stagedLocally;
        }
        Group scopeGroup = this._themeDisplay.getScopeGroup();
        this._stagedLocally = scopeGroup.isStaged() && !scopeGroup.isStagedRemotely() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        return this._stagedLocally;
    }

    private boolean _isStagedReferrerPortlet() {
        if (this._stagedReferrerPortlet != null) {
            return this._stagedReferrerPortlet;
        }
        if (this._isStagedLocally()) {
            String className = (String)this._request.getAttribute("liferay-ui:input-asset-links:className");
            AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)className);
            Group scopeGroup = this._themeDisplay.getScopeGroup();
            this._stagedReferrerPortlet = scopeGroup.isStagedPortlet(assetRendererFactory.getPortletId());
        } else {
            this._stagedReferrerPortlet = false;
        }
        return this._stagedReferrerPortlet;
    }
}

