/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.taglib.util.LexiconUtil;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class UserPortraitTag
extends IncludeTag {
    private static final String _PAGE = "/html/taglib/ui/user_portrait/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(UserPortraitTag.class);
    private String _cssClass = "";
    private String _imageCssClass = "";
    private long _userId;
    private String _userName = "";

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setImageCssClass(String imageCssClass) {
        this._imageCssClass = imageCssClass;
    }

    public void setUserId(long userId) {
        this._userId = userId;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @Override
    protected void cleanUp() {
        this._cssClass = "";
        this._imageCssClass = "";
        this._userId = 0L;
        this._userName = "";
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    protected User getUser() {
        return UserLocalServiceUtil.fetchUser((long)this._userId);
    }

    protected String getUserInitials(User user) {
        Object[] userNames;
        if (user != null) {
            return user.getInitials();
        }
        String userName = this._userName;
        if (Validator.isNull((String)userName)) {
            ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
            userName = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"user");
        }
        if ((userNames = StringUtil.split((String)userName, (String)" ")).length > 1) {
            userNames = (String[])ArrayUtil.subset((Object[])userNames, (int)0, (int)2);
        }
        StringBundler sb = new StringBundler(userNames.length);
        for (Object curUserName : userNames) {
            sb.append(StringUtil.toUpperCase((String)StringUtil.shorten((String)curUserName, (int)1)));
        }
        return sb.toString();
    }

    @Override
    protected boolean isCleanUpSetAttributes() {
        return true;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        request.setAttribute("liferay-ui:user-portrait:colorCssClass", (Object)LexiconUtil.getUserColorCssClass(this.getUser()));
        request.setAttribute("liferay-ui:user-portrait:cssClass", (Object)this._cssClass);
        request.setAttribute("liferay-ui:user-portrait:imageCssClass", (Object)this._imageCssClass);
        User user = this.getUser();
        if (user != null && user.getPortraitId() > 0L) {
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            try {
                request.setAttribute("liferay-ui:user-portrait:portraitURL", (Object)user.getPortraitURL(themeDisplay));
            }
            catch (PortalException pe) {
                _log.error((Throwable)pe);
            }
        }
        request.setAttribute("liferay-ui:user-portrait:user", (Object)user);
        request.setAttribute("liferay-ui:user-portrait:userInitials", (Object)this.getUserInitials(user));
        request.setAttribute("liferay-ui:user-portrait:userName", (Object)this._userName);
    }
}

