/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.editor.Editor;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactoryUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletConstants;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.collections.ServiceReferenceMapper;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import com.liferay.taglib.aui.AUIUtil;
import com.liferay.taglib.util.IncludeTag;
import com.liferay.taglib.util.TagResourceBundleUtil;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class InputEditorTag
extends IncludeTag {
    private static final String _EDITOR_WYSIWYG_DEFAULT = PropsUtil.get((String)"editor.wysiwyg.default");
    private static final String _TOOLBAR_SET_DEFAULT = "liferay";
    private static final ServiceTrackerMap<String, Editor> _serviceTrackerMap = ServiceTrackerCollections.singleValueMap(Editor.class, null, (ServiceReferenceMapper)new ServiceReferenceMapper<String, Editor>(){

        public void map(ServiceReference<Editor> serviceReference, ServiceReferenceMapper.Emitter<String> emitter) {
            Registry registry = RegistryUtil.getRegistry();
            Editor editor = (Editor)registry.getService(serviceReference);
            emitter.emit((Object)editor.getName());
        }
    });
    private boolean _allowBrowseDocuments = true;
    private boolean _autoCreate = true;
    private String _configKey;
    private Map<String, String> _configParams;
    private String _contents;
    private String _contentsLanguageId;
    private String _cssClass;
    private Map<String, Object> _data;
    private String _editorName;
    private Map<String, String> _fileBrowserParams;
    private String _height;
    private String _initMethod = "initEditor";
    private boolean _inlineEdit;
    private String _inlineEditSaveURL;
    private String _name = "editor";
    private String _onBlurMethod;
    private String _onChangeMethod;
    private String _onFocusMethod;
    private String _onInitMethod;
    private String _placeholder;
    private boolean _resizable = true;
    private boolean _showSource = true;
    private boolean _skipEditorLoading;
    private String _toolbarSet = "liferay";
    private String _width;

    public static Editor getEditor(HttpServletRequest request, String editorName) {
        if (!BrowserSnifferUtil.isRtf((HttpServletRequest)request)) {
            return (Editor)_serviceTrackerMap.getService((Object)"simple");
        }
        if (Validator.isNull((String)editorName)) {
            return (Editor)_serviceTrackerMap.getService((Object)_EDITOR_WYSIWYG_DEFAULT);
        }
        if (!_serviceTrackerMap.containsKey((Object)editorName)) {
            return (Editor)_serviceTrackerMap.getService((Object)_EDITOR_WYSIWYG_DEFAULT);
        }
        return (Editor)_serviceTrackerMap.getService((Object)editorName);
    }

    public void setAllowBrowseDocuments(boolean allowBrowseDocuments) {
        this._allowBrowseDocuments = allowBrowseDocuments;
    }

    public void setAutoCreate(boolean autoCreate) {
        this._autoCreate = autoCreate;
    }

    public void setConfigKey(String configKey) {
        this._configKey = configKey;
    }

    public void setConfigParams(Map<String, String> configParams) {
        this._configParams = configParams;
    }

    public void setContents(String contents) {
        this._contents = contents;
    }

    public void setContentsLanguageId(String contentsLanguageId) {
        this._contentsLanguageId = contentsLanguageId;
    }

    public void setCssClass(String cssClass) {
        this._cssClass = cssClass;
    }

    public void setData(Map<String, Object> data) {
        this._data = data;
    }

    @Deprecated
    public void setEditorImpl(String editorImpl) {
        this._editorName = PropsUtil.get((String)editorImpl);
    }

    public void setEditorName(String editorName) {
        this._editorName = editorName;
    }

    public void setFileBrowserParams(Map<String, String> fileBrowserParams) {
        this._fileBrowserParams = fileBrowserParams;
    }

    public void setHeight(String height) {
        this._height = height;
    }

    @Deprecated
    public void setInitMethod(String initMethod) {
        this._initMethod = initMethod;
    }

    public void setInlineEdit(boolean inlineEdit) {
        this._inlineEdit = inlineEdit;
    }

    public void setInlineEditSaveURL(String inlineEditSaveURL) {
        this._inlineEditSaveURL = inlineEditSaveURL;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setOnBlurMethod(String onBlurMethod) {
        this._onBlurMethod = onBlurMethod;
    }

    public void setOnChangeMethod(String onChangeMethod) {
        this._onChangeMethod = onChangeMethod;
    }

    public void setOnFocusMethod(String onFocusMethod) {
        this._onFocusMethod = onFocusMethod;
    }

    public void setOnInitMethod(String onInitMethod) {
        this._onInitMethod = onInitMethod;
    }

    public void setPlaceholder(String placeholder) {
        this._placeholder = placeholder;
    }

    public void setResizable(boolean resizable) {
        this._resizable = resizable;
    }

    public void setShowSource(boolean showSource) {
        this._showSource = showSource;
    }

    public void setSkipEditorLoading(boolean skipEditorLoading) {
        this._skipEditorLoading = skipEditorLoading;
    }

    public void setToolbarSet(String toolbarSet) {
        this._toolbarSet = toolbarSet;
    }

    public void setWidth(String width) {
        this._width = width;
    }

    @Override
    protected void cleanUp() {
        this._allowBrowseDocuments = true;
        this._autoCreate = true;
        this._configKey = null;
        this._configParams = null;
        this._contents = null;
        this._contentsLanguageId = null;
        this._cssClass = null;
        this._data = null;
        this._editorName = null;
        this._fileBrowserParams = null;
        this._height = null;
        this._initMethod = "initEditor";
        this._inlineEdit = false;
        this._inlineEditSaveURL = null;
        this._name = "editor";
        this._onChangeMethod = null;
        this._onBlurMethod = null;
        this._onFocusMethod = null;
        this._onInitMethod = null;
        this._placeholder = null;
        this._resizable = true;
        this._showSource = true;
        this._skipEditorLoading = false;
        this._toolbarSet = _TOOLBAR_SET_DEFAULT;
        this._width = null;
    }

    protected String getConfigKey() {
        String configKey = this._configKey;
        if (Validator.isNull((String)configKey)) {
            configKey = this._name;
        }
        return configKey;
    }

    protected String getContentsLanguageId() {
        if (this._contentsLanguageId == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._contentsLanguageId = themeDisplay.getLanguageId();
        }
        return this._contentsLanguageId;
    }

    protected String getCssClasses() {
        Portlet portlet = (Portlet)this.request.getAttribute("RENDER_PORTLET");
        String cssClasses = "portlet ";
        if (portlet != null) {
            cssClasses = cssClasses + portlet.getCssClassWrapper();
        }
        return cssClasses;
    }

    protected Map<String, Object> getData() {
        String portletId = (String)this.request.getAttribute("PORTLET_ID");
        if (portletId == null) {
            return this._data;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Enumeration enumeration = this.request.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (!attributeName.startsWith("liferay-ui:input-editor")) continue;
            attributes.put(attributeName, this.request.getAttribute(attributeName));
        }
        attributes.put("liferay-ui:input-editor:namespace", this.getNamespace());
        ThemeDisplay themeDisplay = (ThemeDisplay)this.request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        EditorConfiguration editorConfiguration = EditorConfigurationFactoryUtil.getEditorConfiguration((String)PortletConstants.getRootPortletId((String)portletId), (String)this.getConfigKey(), (String)this.getEditorName(this.request), attributes, (ThemeDisplay)themeDisplay, (RequestBackedPortletURLFactory)this.getRequestBackedPortletURLFactory());
        Map data = editorConfiguration.getData();
        if (MapUtil.isNotEmpty(this._data)) {
            MapUtil.merge(this._data, (Map)data);
        }
        return data;
    }

    protected Editor getEditor(HttpServletRequest request) {
        return InputEditorTag.getEditor(request, this._editorName);
    }

    protected String getEditorName(HttpServletRequest request) {
        Editor editor = this.getEditor(request);
        return editor.getName();
    }

    protected String getEditorResourceType() {
        Editor editor = this.getEditor(this.request);
        return editor.getResourceType();
    }

    protected String getNamespace() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        PortletResponse portletResponse = (PortletResponse)this.request.getAttribute("javax.portlet.response");
        if (portletRequest == null || portletResponse == null) {
            return AUIUtil.getNamespace(this.request);
        }
        return AUIUtil.getNamespace(portletRequest, portletResponse);
    }

    @Override
    protected String getPage() {
        Editor editor = this.getEditor(this.request);
        return editor.getJspPath();
    }

    protected RequestBackedPortletURLFactory getRequestBackedPortletURLFactory() {
        PortletRequest portletRequest = (PortletRequest)this.request.getAttribute("javax.portlet.request");
        if (portletRequest == null) {
            return RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this.request);
        }
        return RequestBackedPortletURLFactoryUtil.create((PortletRequest)portletRequest);
    }

    protected String getToolbarSet() {
        if (Validator.isNotNull((String)this._toolbarSet)) {
            return this._toolbarSet;
        }
        return _TOOLBAR_SET_DEFAULT;
    }

    @Override
    protected void includePage(String page, HttpServletResponse response) throws IOException, ServletException {
        this.servletContext = PortalWebResourcesUtil.getServletContext((String)this.getEditorResourceType());
        super.includePage(page, response);
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        request.setAttribute("liferay-ui:input-editor:allowBrowseDocuments", (Object)String.valueOf(this._allowBrowseDocuments));
        request.setAttribute("liferay-ui:input-editor:autoCreate", (Object)String.valueOf(this._autoCreate));
        request.setAttribute("liferay-ui:input-editor:configParams", this._configParams);
        request.setAttribute("liferay-ui:input-editor:contents", (Object)this._contents);
        request.setAttribute("liferay-ui:input-editor:contentsLanguageId", (Object)this.getContentsLanguageId());
        request.setAttribute("liferay-ui:input-editor:cssClass", (Object)this._cssClass);
        request.setAttribute("liferay-ui:input-editor:cssClasses", (Object)this.getCssClasses());
        request.setAttribute("liferay-ui:input-editor:editorName", (Object)this.getEditorName(request));
        request.setAttribute("liferay-ui:input-editor:fileBrowserParams", this._fileBrowserParams);
        request.setAttribute("liferay-ui:input-editor:height", (Object)this._height);
        request.setAttribute("liferay-ui:input-editor:initMethod", (Object)this._initMethod);
        request.setAttribute("liferay-ui:input-editor:inlineEdit", (Object)String.valueOf(this._inlineEdit));
        request.setAttribute("liferay-ui:input-editor:inlineEditSaveURL", (Object)this._inlineEditSaveURL);
        request.setAttribute("liferay-ui:input-editor:name", (Object)this._name);
        request.setAttribute("liferay-ui:input-editor:onBlurMethod", (Object)this._onBlurMethod);
        request.setAttribute("liferay-ui:input-editor:onChangeMethod", (Object)this._onChangeMethod);
        request.setAttribute("liferay-ui:input-editor:onFocusMethod", (Object)this._onFocusMethod);
        request.setAttribute("liferay-ui:input-editor:onInitMethod", (Object)this._onInitMethod);
        ResourceBundle resourceBundle = TagResourceBundleUtil.getResourceBundle(this.pageContext);
        if (Validator.isNull((String)this._placeholder)) {
            this._placeholder = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"write-your-content-here");
        }
        request.setAttribute("liferay-ui:input-editor:placeholder", (Object)this._placeholder);
        request.setAttribute("liferay-ui:input-editor:resizable", (Object)String.valueOf(this._resizable));
        request.setAttribute("liferay-ui:input-editor:showSource", (Object)String.valueOf(this._showSource));
        request.setAttribute("liferay-ui:input-editor:skipEditorLoading", (Object)String.valueOf(this._skipEditorLoading));
        request.setAttribute("liferay-ui:input-editor:toolbarSet", (Object)this.getToolbarSet());
        request.setAttribute("liferay-ui:input-editor:width", (Object)this._width);
        request.setAttribute("liferay-ui:input-editor:data", ProxyUtil.newProxyInstance((ClassLoader)ClassLoader.getSystemClassLoader(), (Class[])new Class[]{Map.class}, (InvocationHandler)new LazyDataInvocationHandler()));
    }

    static {
        _serviceTrackerMap.open();
    }

    private class LazyDataInvocationHandler
    implements InvocationHandler {
        private Map<String, Object> _data;

        private LazyDataInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws ReflectiveOperationException {
            if (this._data == null) {
                this._data = InputEditorTag.this.getData();
            }
            return method.invoke(this._data, args);
        }
    }
}

