/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.portal.kernel.util.IntegerWrapper;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.BaseBodyTagSupport;
import com.liferay.taglib.FileAvailabilityUtil;
import com.liferay.taglib.util.PortalIncludeUtil;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;

public class IconListTag
extends BaseBodyTagSupport
implements BodyTag {
    private static final String _END_PAGE = "/html/taglib/ui/icon_list/end.jsp";
    private static final String _START_PAGE = "/html/taglib/ui/icon_list/start.jsp";
    private String _endPage;
    private boolean _showWhenSingleIcon;
    private String _startPage;

    @Override
    public int doAfterBody() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        IntegerWrapper iconCount = (IntegerWrapper)request.getAttribute("liferay-ui:icon-list:icon-count");
        Boolean singleIcon = (Boolean)request.getAttribute("liferay-ui:icon-list:single-icon");
        if (iconCount != null && iconCount.getValue() == 1 && singleIcon == null) {
            this.bodyContent.clearBody();
            request.setAttribute("liferay-ui:icon-list:single-icon", (Object)Boolean.TRUE);
            return 2;
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        try {
            HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
            IntegerWrapper iconCount = (IntegerWrapper)request.getAttribute("liferay-ui:icon-list:icon-count");
            request.removeAttribute("liferay-ui:icon-list:icon-count");
            Boolean singleIcon = (Boolean)request.getAttribute("liferay-ui:icon-list:single-icon");
            request.removeAttribute("liferay-ui:icon-list:single-icon");
            JspWriter jspWriter = this.pageContext.getOut();
            if (iconCount != null && iconCount.getValue() > 1 && (singleIcon == null || this._showWhenSingleIcon)) {
                if (!FileAvailabilityUtil.isAvailable(this.pageContext.getServletContext(), this.getStartPage())) {
                    jspWriter.write("<ul class=\"list-unstyled taglib-icon-list\">");
                } else {
                    PortalIncludeUtil.include(this.pageContext, this._startPage);
                }
            }
            this.writeBodyContent((Writer)jspWriter);
            if (iconCount != null && iconCount.getValue() > 1 && (singleIcon == null || this._showWhenSingleIcon)) {
                if (!FileAvailabilityUtil.isAvailable(this.pageContext.getServletContext(), this.getEndPage())) {
                    jspWriter.write("</ul>");
                } else {
                    PortalIncludeUtil.include(this.pageContext, this._endPage);
                }
            }
            request.removeAttribute("liferay-ui:icon-list:showWhenSingleIcon");
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (!ServerDetector.isResin()) {
                this._endPage = null;
                this._showWhenSingleIcon = false;
                this._startPage = null;
            }
        }
    }

    @Override
    public int doStartTag() {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        request.setAttribute("liferay-ui:icon-list:icon-count", (Object)new IntegerWrapper());
        request.setAttribute("liferay-ui:icon-list:showWhenSingleIcon", (Object)String.valueOf(this._showWhenSingleIcon));
        return 2;
    }

    public void setEndPage(String endPage) {
        this._endPage = endPage;
    }

    public void setShowWhenSingleIcon(boolean showWhenSingleIcon) {
        this._showWhenSingleIcon = showWhenSingleIcon;
    }

    public void setStartPage(String startPage) {
        this._startPage = startPage;
    }

    protected String getEndPage() {
        if (Validator.isNull((String)this._endPage)) {
            return _END_PAGE;
        }
        return this._endPage;
    }

    protected String getStartPage() {
        if (Validator.isNull((String)this._startPage)) {
            return _START_PAGE;
        }
        return this._startPage;
    }
}

