/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.taglib.util.IncludeTag;
import javax.servlet.http.HttpServletRequest;

public class AssetMetadataTag
extends IncludeTag {
    private static final String _PAGE = "/html/taglib/ui/asset_metadata/page.jsp";
    private static final Log _log = LogFactoryUtil.getLog(AssetMetadataTag.class);
    private String _className = "";
    private long _classPK;
    private boolean _filterByMetadata;
    private String[] _metadataFields;

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public String[] getMetadataFields() {
        return this._metadataFields;
    }

    public boolean isFilterByMetadata() {
        return this._filterByMetadata;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setFilterByMetadata(boolean filterByMetadata) {
        this._filterByMetadata = filterByMetadata;
    }

    public void setMetadataFields(String[] metadataFields) {
        this._metadataFields = metadataFields;
    }

    @Override
    protected void cleanUp() {
        this._className = "";
        this._classPK = 0L;
        this._filterByMetadata = false;
        this._metadataFields = null;
    }

    @Override
    protected String getPage() {
        return _PAGE;
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        AssetEntry assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)this._className, (long)this._classPK);
        request.setAttribute("liferay-ui:asset-metadata:assetEntry", (Object)assetEntry);
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)this._className);
        try {
            AssetRenderer assetRenderer = assetRendererFactory.getAssetRenderer(this._classPK);
            request.setAttribute("liferay-ui:asset-metadata:assetRenderer", (Object)assetRenderer);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
        }
        request.setAttribute("liferay-ui:asset-metadata:className", (Object)this._className);
        request.setAttribute("liferay-ui:asset-metadata:classPK", (Object)this._classPK);
        request.setAttribute("liferay-ui:asset-metadata:filterByMetadata", (Object)this._filterByMetadata);
        request.setAttribute("liferay-ui:asset-metadata:metadataFields", (Object)this._metadataFields);
    }
}

