/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.ui;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.Renderer;
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.taglib.util.IncludeTag;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

public class AssetDisplayTag
extends IncludeTag {
    private static final Log _log = LogFactoryUtil.getLog(AssetDisplayTag.class);
    private int _abstractLength = 200;
    private AssetEntry _assetEntry;
    private AssetRendererFactory<?> _assetRendererFactory;
    private String _className;
    private long _classPK;
    private String _page;
    private Renderer _renderer;
    private boolean _showComments;
    private boolean _showExtraInfo;
    private boolean _showHeader;
    private String _template = "full_content";
    private String _viewURL;

    @Override
    public int doEndTag() throws JspException {
        try {
            this.callSetAttributes();
            this.doInclude(null, false);
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.clearDynamicAttributes();
            this.clearParams();
            this.clearProperties();
            this.cleanUpSetAttributes();
            if (!ServerDetector.isResin()) {
                this.setPage(null);
                this.setUseCustomPage(true);
                this.cleanUp();
            }
        }
    }

    public int getAbstractLength() {
        return this._abstractLength;
    }

    public AssetEntry getAssetEntry() {
        return this._assetEntry;
    }

    public AssetRendererFactory<?> getAssetRendererFactory() {
        return this._assetRendererFactory;
    }

    public String getClassName() {
        return this._className;
    }

    public long getClassPK() {
        return this._classPK;
    }

    public Renderer getRenderer() {
        return this._renderer;
    }

    public String getTemplate() {
        return this._template;
    }

    public String getViewURL() {
        return this._viewURL;
    }

    public boolean isShowComments() {
        return this._showComments;
    }

    public boolean isShowExtraInfo() {
        return this._showExtraInfo;
    }

    public boolean isShowHeader() {
        return this._showHeader;
    }

    public void setAbstractLength(int abstractLength) {
        this._abstractLength = abstractLength;
    }

    public void setAssetEntry(AssetEntry assetEntry) {
        this._assetEntry = assetEntry;
    }

    public void setAssetRenderer(AssetRenderer<?> assetRenderer) {
        this._renderer = assetRenderer;
    }

    public void setAssetRendererFactory(AssetRendererFactory<?> assetRendererFactory) {
        this._assetRendererFactory = assetRendererFactory;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public void setClassPK(long classPK) {
        this._classPK = classPK;
    }

    public void setRenderer(Renderer renderer) {
        this._renderer = renderer;
    }

    public void setShowComments(boolean showComments) {
        this._showComments = showComments;
    }

    public void setShowExtraInfo(boolean showExtraInfo) {
        this._showExtraInfo = showExtraInfo;
    }

    public void setShowHeader(boolean showHeader) {
        this._showHeader = showHeader;
    }

    public void setTemplate(String template) {
        this._template = template;
    }

    public void setViewURL(String viewURL) {
        this._viewURL = viewURL;
    }

    @Override
    protected void cleanUp() {
        this._abstractLength = 200;
        this._assetEntry = null;
        this._className = null;
        this._classPK = 0L;
        this._page = null;
        this._renderer = null;
        this._showComments = false;
        this._showExtraInfo = false;
        this._showHeader = false;
        this._template = "full_content";
        this._viewURL = null;
    }

    @Override
    protected String getPage() {
        return this._page;
    }

    @Override
    protected void includePage(String page, HttpServletResponse response) throws IOException, ServletException {
        try {
            boolean include = this._renderer.include(this.request, response, this._template);
            if (include) {
                return;
            }
        }
        catch (Exception e) {
            _log.error((Throwable)e);
        }
        super.includePage("/html/taglib/ui/asset_display/" + this._template + ".jsp", response);
    }

    @Override
    protected void setAttributes(HttpServletRequest request) {
        request.setAttribute("liferay-ui:asset-display:abstractLength", (Object)this._abstractLength);
        AssetEntry assetEntry = this._assetEntry;
        if (assetEntry == null) {
            if (Validator.isNotNull((String)this._className) && this._classPK > 0L) {
                assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)this._className, (long)this._classPK);
            } else if (this._renderer != null) {
                assetEntry = AssetEntryLocalServiceUtil.fetchEntry((String)this._renderer.getClassName(), (long)this._renderer.getClassPK());
            }
        }
        request.setAttribute("liferay-ui:asset-display:assetEntry", (Object)assetEntry);
        if (this._renderer == null && assetEntry != null) {
            this._renderer = assetEntry.getAssetRenderer();
        }
        if (this._renderer instanceof AssetRenderer) {
            AssetRenderer assetRenderer = (AssetRenderer)this._renderer;
            request.setAttribute("ASSET_RENDERER", (Object)assetRenderer);
        } else {
            request.setAttribute("liferay-ui:asset-display:renderer", (Object)this._renderer);
        }
        AssetRendererFactory assetRendererFactory = this._assetRendererFactory;
        if (assetRendererFactory == null && assetEntry != null) {
            assetRendererFactory = assetEntry.getAssetRendererFactory();
        }
        if (assetRendererFactory != null) {
            request.setAttribute("ASSET_RENDERER_FACTORY", (Object)assetRendererFactory);
        }
        request.setAttribute("ASSET_ENTRY_VIEW_URL", (Object)this._viewURL);
        this.addParam("showComments", String.valueOf(this._showComments));
        this.addParam("showExtraInfo", String.valueOf(this._showExtraInfo));
        this.addParam("showHeader", String.valueOf(this._showHeader));
    }
}

